<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

#Preparar las variables con los datos de conexion
require '../conexion.php';

# Conectandose a la base da datos
$conn = mysqli_connect($host, $usuario, $clave, $db);

# Preparo la sentencia con los comando ?
$sql = "
    SELECT nombre_completo, telefono, vendedor
    FROM   Boletos
    WHERE  id = ?
";

# Preparo la consulta
$pre = mysqli_prepare($conn, $sql);

# indico los datos a reemplazar con su tipo
mysqli_stmt_bind_param($pre, "i", $id);

# Ejecuto la consulta
mysqli_stmt_execute($pre);

# asocio los nombres de campo a nombres de variables
mysqli_stmt_bind_result($pre, $nom, $telf, $vend);

# Capturo los resultados y los guardo en un array
while(mysqli_stmt_fetch($pre)) {
  $nombre_completo = $nom;
  $telefono = $telf;
  $vendedor = $vend;
}

# Cierro la consulta y la conexión
mysqli_stmt_close($pre);
mysqli_close($conn);

if (strlen($id)==1) {
  $id_str = "00" . $id;
} elseif (strlen($id)==2) {
  $id_str = "0" . $id;
} else {
  $id_str = $id;
}
if ($telefono==0) {
  $telefono = "";
}

 ?>
<!DOCTYPE html>
<html lang="es" dir="ltr">
  <head>
    <meta charset="utf-8">
    <title>Ticket <?php echo $id_str; ?></title>
    <meta name="description" content="Gran rifa sanmarquina: Canasta de víveres, kit anti COVID y kit regreso a clases.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta property="og:image" content="../afiche.jpg">
    <meta name="twitter:image" content="../afiche.jpg">

  </head>
  <body>
    <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
    	 viewBox="0 0 612 198" style="enable-background:new 0 0 612 198;" xml:space="preserve">
    <style type="text/css">
    	.st0{fill:#EEEBE3;}
    	.st1{fill:#D6B04F;}
    	.st2{fill:#1D1D1B;}
    	.st3{fill:#919DB0;}
    	.st4{fill:none;stroke:#FFFFFF;stroke-width:1.5;stroke-miterlimit:10;}
    	.st5{fill:#FFFFFF;}
    	.st6{font-family:'Futura-CondensedMedium';}
    	.st7{font-size:57px;}
    	.st8{letter-spacing:5;}
    	.st9{font-size:11px;}
    	.st10{letter-spacing:1;}
    </style>
    <rect x="414" class="st0" width="198" height="198"/>
    <rect x="0" class="st1" width="414" height="198"/>
    <g>
    	<path class="st2" d="M491.56,16.09h1.71l1.82,5.41c0.53,1.53,0.99,3.16,1.4,4.9c-0.15-1.05-0.25-2-0.33-2.85s-0.11-1.65-0.11-2.4
    		v-5.06h1.84v13.57h-1.71l-2.05-6.11c-0.19-0.57-0.36-1.15-0.53-1.75c-0.17-0.6-0.32-1.22-0.46-1.88c-0.01-0.08-0.03-0.18-0.06-0.3
    		c-0.03-0.12-0.06-0.25-0.09-0.4c0.02,0.15,0.03,0.28,0.04,0.39s0.02,0.2,0.03,0.28l0.1,1.38l0.1,1.68
    		c0.01,0.09,0.01,0.21,0.01,0.34s0,0.29,0,0.46l0.1,5.92h-1.8V16.09z"/>
    	<path class="st2" d="M505.27,25.19c0,3.08-0.95,4.61-2.86,4.61s-2.86-1.56-2.86-4.68c0-3.13,0.95-4.7,2.85-4.7
    		c0.49,0,0.92,0.09,1.28,0.28c0.36,0.19,0.66,0.48,0.89,0.87s0.41,0.89,0.52,1.49C505.22,23.65,505.27,24.36,505.27,25.19z
    		 M503.53,25.14c0-1.2-0.08-2.03-0.24-2.5c-0.16-0.47-0.44-0.71-0.84-0.71c-0.4,0-0.68,0.23-0.85,0.7
    		c-0.16,0.47-0.24,1.29-0.24,2.45s0.08,1.98,0.24,2.44c0.17,0.47,0.45,0.7,0.85,0.7s0.68-0.23,0.83-0.69
    		C503.45,27.11,503.53,26.31,503.53,25.14z"/>
    	<path class="st2" d="M506.84,20.56h1.68v1.12c0.46-0.85,1.08-1.27,1.85-1.27c0.84,0,1.41,0.42,1.71,1.27
    		c0.45-0.85,1.08-1.27,1.9-1.27c0.64,0,1.13,0.17,1.46,0.51c0.34,0.34,0.5,0.83,0.5,1.49v7.25h-1.69v-5.99
    		c0-0.69-0.06-1.15-0.19-1.38c-0.12-0.24-0.36-0.36-0.72-0.36c-0.4,0-0.68,0.12-0.83,0.37c-0.14,0.24-0.21,0.7-0.21,1.37v5.99h-1.74
    		v-5.99c0-0.32-0.02-0.59-0.05-0.82c-0.03-0.22-0.09-0.4-0.16-0.54s-0.18-0.23-0.3-0.29s-0.28-0.09-0.46-0.09
    		c-0.39,0-0.66,0.13-0.83,0.4s-0.25,0.71-0.25,1.34v5.99h-1.68V20.56z"/>
    	<path class="st2" d="M517.83,14.73h1.68v6.86c0.12-0.22,0.24-0.41,0.36-0.56s0.24-0.27,0.36-0.35c0.23-0.18,0.54-0.26,0.91-0.26
    		c0.39,0,0.72,0.09,1,0.27s0.51,0.46,0.69,0.83c0.18,0.38,0.31,0.85,0.4,1.43s0.13,1.27,0.13,2.07c0,1.65-0.18,2.86-0.53,3.63
    		s-0.9,1.16-1.65,1.16c-0.4,0-0.72-0.09-0.96-0.28s-0.48-0.53-0.72-1.03v1.17h-1.68V14.73z M521.63,25.16
    		c0-1.24-0.08-2.07-0.25-2.51c-0.16-0.47-0.44-0.71-0.85-0.71c-0.39,0-0.66,0.24-0.82,0.72c-0.16,0.47-0.24,1.29-0.24,2.46
    		c0,1.16,0.08,1.98,0.24,2.46c0.16,0.47,0.43,0.71,0.82,0.71c0.4,0,0.68-0.23,0.85-0.7C521.55,27.15,521.63,26.34,521.63,25.16z"/>
    	<path class="st2" d="M524.94,20.56h1.68v1.13c0.29-0.48,0.57-0.82,0.85-1.01s0.65-0.3,1.12-0.33v1.76
    		c-0.12-0.02-0.22-0.03-0.3-0.03c-0.6,0-1.03,0.16-1.29,0.47c-0.25,0.3-0.38,0.84-0.38,1.6v5.51h-1.68V20.56z"/>
    	<path class="st2" d="M533.31,26.59h1.56c-0.12,2.14-1,3.21-2.64,3.21c-0.49,0-0.9-0.09-1.25-0.27c-0.35-0.18-0.64-0.46-0.87-0.84
    		s-0.4-0.86-0.5-1.45c-0.11-0.59-0.16-1.28-0.16-2.09c0-1.61,0.22-2.79,0.67-3.57c0.45-0.77,1.14-1.16,2.08-1.16
    		c1.82,0,2.73,1.61,2.73,4.82v0.21h-3.84c0,1.95,0.39,2.92,1.16,2.92C532.96,28.36,533.31,27.77,533.31,26.59z M533.22,24.23
    		c-0.07-0.96-0.18-1.58-0.33-1.88c-0.15-0.33-0.4-0.5-0.74-0.5c-0.35,0-0.59,0.17-0.74,0.5c-0.15,0.3-0.25,0.93-0.33,1.88H533.22z"
    		/>
    </g>
    <g>
    	<path class="st2" d="M489.08,77.08h5.95v1.6h-2.05v11.97h-1.79V78.68h-2.11V77.08z"/>
    	<path class="st2" d="M498.94,87.58h1.56c-0.12,2.14-1,3.21-2.64,3.21c-0.49,0-0.9-0.09-1.25-0.27c-0.35-0.18-0.64-0.46-0.87-0.84
    		s-0.4-0.86-0.5-1.45c-0.11-0.59-0.16-1.28-0.16-2.09c0-1.61,0.22-2.79,0.67-3.57c0.45-0.77,1.14-1.16,2.08-1.16
    		c1.82,0,2.73,1.61,2.73,4.82v0.21h-3.84c0,1.95,0.39,2.92,1.16,2.92C498.59,89.35,498.94,88.76,498.94,87.58z M498.85,85.22
    		c-0.07-0.96-0.18-1.58-0.33-1.88c-0.15-0.33-0.4-0.5-0.74-0.5c-0.35,0-0.59,0.17-0.74,0.5c-0.15,0.3-0.25,0.93-0.33,1.88H498.85z"
    		/>
    	<path class="st2" d="M502.06,75.71h1.68v14.93h-1.68V75.71z"/>
    	<path class="st2" d="M509.16,87.58h1.56c-0.12,2.14-1,3.21-2.64,3.21c-0.49,0-0.9-0.09-1.25-0.27c-0.35-0.18-0.64-0.46-0.87-0.84
    		s-0.4-0.86-0.5-1.45c-0.11-0.59-0.16-1.28-0.16-2.09c0-1.61,0.22-2.79,0.67-3.57c0.45-0.77,1.14-1.16,2.08-1.16
    		c1.82,0,2.73,1.61,2.73,4.82v0.21h-3.84c0,1.95,0.39,2.92,1.16,2.92C508.81,89.35,509.16,88.76,509.16,87.58z M509.08,85.22
    		c-0.07-0.96-0.18-1.58-0.33-1.88c-0.15-0.33-0.4-0.5-0.74-0.5c-0.35,0-0.59,0.17-0.74,0.5c-0.15,0.3-0.25,0.93-0.33,1.88H509.08z
    		 M509.92,77.77l-1.78,2.43l-0.91-0.52l1.49-2.68L509.92,77.77z"/>
    	<path class="st2" d="M511.64,81.55h0.84v-3.17c0-1.04,0.15-1.77,0.46-2.2s0.83-0.64,1.59-0.64c0.33,0,0.71,0.08,1.14,0.24v1.78
    		c-0.27-0.15-0.51-0.22-0.71-0.22c-0.29,0-0.49,0.08-0.61,0.25c-0.12,0.17-0.18,0.46-0.18,0.86l-0.01,0.69v2.42h1.42v1.34h-1.42
    		v7.76h-1.68v-7.76h-0.84V81.55z"/>
    	<path class="st2" d="M522.08,86.17c0,3.08-0.95,4.61-2.86,4.61s-2.86-1.56-2.86-4.68c0-3.13,0.95-4.7,2.85-4.7
    		c0.49,0,0.92,0.09,1.28,0.28c0.36,0.19,0.66,0.48,0.89,0.87s0.41,0.89,0.52,1.49C522.03,84.64,522.08,85.35,522.08,86.17z
    		 M520.34,86.13c0-1.2-0.08-2.03-0.24-2.5c-0.16-0.47-0.44-0.71-0.84-0.71c-0.4,0-0.68,0.23-0.85,0.7
    		c-0.16,0.47-0.24,1.29-0.24,2.45s0.08,1.98,0.24,2.44c0.17,0.47,0.45,0.7,0.85,0.7s0.68-0.23,0.83-0.69
    		C520.26,88.1,520.34,87.3,520.34,86.13z"/>
    	<path class="st2" d="M523.65,81.55h1.68v1.05c0.48-0.8,1.1-1.2,1.86-1.2c0.74,0,1.27,0.29,1.58,0.87c0.18,0.33,0.26,0.96,0.26,1.91
    		v6.47h-1.68l-0.01-6.08c0-0.62-0.07-1.05-0.22-1.31s-0.4-0.39-0.76-0.39c-0.19,0-0.36,0.03-0.49,0.1
    		c-0.13,0.07-0.24,0.18-0.32,0.33s-0.14,0.34-0.18,0.58c-0.04,0.24-0.06,0.54-0.06,0.89v5.88h-1.68V81.55z"/>
    	<path class="st2" d="M536.3,86.17c0,3.08-0.95,4.61-2.86,4.61s-2.86-1.56-2.86-4.68c0-3.13,0.95-4.7,2.85-4.7
    		c0.49,0,0.92,0.09,1.28,0.28c0.36,0.19,0.66,0.48,0.89,0.87s0.41,0.89,0.52,1.49C536.25,84.64,536.3,85.35,536.3,86.17z
    		 M534.56,86.13c0-1.2-0.08-2.03-0.24-2.5c-0.16-0.47-0.44-0.71-0.84-0.71c-0.4,0-0.68,0.23-0.85,0.7
    		c-0.16,0.47-0.24,1.29-0.24,2.45s0.08,1.98,0.24,2.44c0.17,0.47,0.45,0.7,0.85,0.7s0.68-0.23,0.83-0.69
    		C534.48,88.1,534.56,87.3,534.56,86.13z"/>
    </g>
    <path class="st3" d="M14.79,7.9"/>
    <g>
    	<polyline class="st4" points="10.52,46.2 10.52,10.2 47.08,10.2 	"/>
    	<circle class="st4" cx="21.41" cy="21.24" r="2.46"/>
    	<path class="st4" d="M10.47,14.03"/>
    	<path class="st4" d="M47.04,29.65"/>
    	<path class="st4" d="M15.3,10.2c1.09,3.89-0.73,6.98-5.1,5.43"/>
    	<path class="st4" d="M15.96,29c-0.42-0.05-0.94,0.59-1.97,1.87c-0.55,0.68-0.83,1.04-1.13,1.53c-0.52,0.85-0.79,1.58-0.91,1.92
    		c-0.21,0.6-0.41,1.19-0.45,1.98c-0.06,1.16,0.26,2.04,0.45,2.55c0.28,0.74,0.63,1.67,1.57,2.42c0.3,0.24,0.95,0.75,1.94,0.86
    		c0.94,0.11,1.65-0.21,1.81-0.28c0.76-0.36,1.17-0.91,1.36-1.17c0.36-0.5,0.49-0.94,0.68-1.58c0.23-0.79,0.49-1.7,0.42-2.91
    		c-0.06-0.92-0.29-1.59-0.56-2.37c-0.36-1.02-0.76-1.73-0.87-1.94c-0.29-0.5-0.58-0.87-1.16-1.64C16.24,29.08,16.09,29.02,15.96,29z
    		"/>
    	<path class="st4" d="M21.96,24c-0.32,0.01-0.45,0.37-1.36,1.92c-0.79,1.35-0.88,1.41-1.02,1.87c-0.13,0.43-0.36,1.23-0.11,2.21
    		c0.09,0.34,0.31,1.2,1.13,1.81c0.87,0.65,1.83,0.59,2.09,0.57c0.31-0.03,0.84-0.08,1.36-0.45c0.62-0.45,0.83-1.09,0.92-1.39
    		c0.23-0.75,0.1-1.39,0-1.85c-0.14-0.64-0.38-1.09-0.86-1.97c-0.28-0.51-0.56-0.95-0.85-1.36C22.61,24.45,22.29,23.99,21.96,24z"/>
    	<path class="st4" d="M24.12,21.82c0.01,0.32,0.36,0.46,1.9,1.39c1.34,0.81,1.4,0.9,1.85,1.05c0.43,0.14,1.23,0.39,2.21,0.15
    		c0.34-0.08,1.2-0.29,1.83-1.1c0.67-0.86,0.62-1.81,0.6-2.08c-0.02-0.31-0.06-0.84-0.43-1.37c-0.44-0.63-1.08-0.85-1.37-0.94
    		c-0.75-0.24-1.39-0.13-1.85-0.03c-0.65,0.13-1.09,0.36-1.98,0.83c-0.52,0.27-0.96,0.54-1.37,0.83
    		C24.58,21.18,24.11,21.5,24.12,21.82z"/>
    	<path class="st4" d="M14.68,24.48c1.27,0.26,2.52-0.06,3.25-0.91c0.57-0.67,0.66-1.48,0.66-1.54c0.07-0.72-0.18-1.26-0.29-1.48
    		c-0.46-0.96-1.29-1.37-1.51-1.47c-0.72-0.34-1.36-0.32-1.77-0.3c-0.37,0.01-1.04,0.05-1.77,0.45c-0.23,0.13-0.71,0.43-1.13,0.98
    		c-0.45,0.6-0.59,1.17-0.72,1.74c-0.27,1.18-0.15,2.14-0.11,2.38c0.08,0.58,0.2,1.44,0.83,2.26c0.55,0.71,1.21,1.03,1.66,1.25
    		c0.66,0.32,1.19,0.42,1.96,0.57c0.78,0.15,1.38,0.18,2.11,0.23c0.77,0.04,1.41,0.05,1.89,0.04"/>
    	<path class="st4" d="M24.64,14.18c0.25,1.27-0.08,2.52-0.93,3.24c-0.67,0.57-1.49,0.65-1.55,0.65c-0.72,0.06-1.26-0.19-1.47-0.3
    		c-0.95-0.47-1.36-1.3-1.46-1.52c-0.34-0.72-0.31-1.37-0.29-1.78c0.02-0.37,0.06-1.04,0.47-1.77c0.13-0.23,0.43-0.71,0.99-1.12
    		c0.6-0.45,1.17-0.58,1.74-0.7c1.19-0.27,2.14-0.13,2.38-0.09c0.58,0.08,1.44,0.21,2.26,0.85c0.7,0.55,1.02,1.22,1.23,1.67
    		c0.31,0.66,0.41,1.19,0.55,1.97c0.14,0.78,0.17,1.38,0.21,2.11c0.04,0.77,0.04,1.41,0.02,1.89"/>
    	<path class="st4" d="M28.8,14.3c-0.05,0.42,0.59,0.94,1.87,1.97c0.68,0.55,1.04,0.83,1.53,1.13c0.85,0.52,1.58,0.79,1.92,0.91
    		c0.6,0.21,1.19,0.41,1.98,0.45c1.16,0.06,2.04-0.26,2.55-0.45c0.74-0.28,1.67-0.63,2.42-1.57c0.24-0.3,0.75-0.95,0.86-1.94
    		c0.11-0.94-0.21-1.65-0.28-1.81c-0.36-0.76-0.91-1.17-1.17-1.36c-0.5-0.36-0.94-0.49-1.58-0.68c-0.79-0.23-1.7-0.49-2.91-0.42
    		c-0.92,0.06-1.59,0.29-2.37,0.56c-1.02,0.36-1.73,0.76-1.94,0.87c-0.5,0.29-0.87,0.58-1.64,1.16C28.87,14.02,28.82,14.17,28.8,14.3
    		z"/>
    </g>
    <g>
    	<path class="st5" d="M35.41,65.52h5.54v0.88c0,4.4-0.39,7.38-1.16,8.92c-0.76,1.58-2.19,2.37-4.28,2.37c-2.16,0-3.7-0.88-4.61-2.64
    		c-0.91-1.76-1.36-4.71-1.36-8.86c0-4.75,0.5-7.91,1.49-9.48c0.94-1.47,2.38-2.21,4.32-2.21c1.48,0,2.64,0.36,3.47,1.07
    		c0.84,0.72,1.49,1.91,1.96,3.56l-2.84,1.19c-0.13-0.6-0.27-1.1-0.42-1.5S37.19,58.1,37,57.87c-0.37-0.46-0.93-0.69-1.67-0.69
    		c-1.02,0-1.71,0.62-2.08,1.88c-0.37,1.31-0.56,3.66-0.56,7.05c0,3.43,0.19,5.75,0.57,6.96s1.1,1.82,2.15,1.82
    		c0.97,0,1.65-0.43,2.04-1.29c0.4-0.92,0.6-2.39,0.6-4.42v-0.62V68.1h-2.65V65.52z"/>
    	<path class="st5" d="M45.93,54.79h4.01c1.66,0,2.9,0.4,3.71,1.19c1.03,1.03,1.54,2.59,1.54,4.7c0,1.62-0.27,2.92-0.81,3.9
    		c-0.54,0.98-1.32,1.59-2.32,1.82l4.16,11h-3.09l-4.15-11.07v11.07h-3.05V54.79z M48.97,64.81c1.18,0,2.02-0.27,2.5-0.82
    		s0.73-1.47,0.73-2.77c0-0.7-0.05-1.3-0.15-1.8s-0.26-0.9-0.48-1.22s-0.5-0.54-0.85-0.69s-0.76-0.22-1.24-0.22h-0.51V64.81z"/>
    	<path class="st5" d="M63.74,54.79h2.37l4.85,22.62h-3.02L67.09,73h-4.48l-0.86,4.41h-2.93L63.74,54.79z M66.65,70.64l-0.67-3.6
    		c-0.45-2.45-0.82-5.07-1.1-7.85c-0.14,1.36-0.31,2.73-0.53,4.12c-0.21,1.39-0.47,2.87-0.76,4.43l-0.56,2.9H66.65z"/>
    	<path class="st5" d="M74.7,54.79h2.84l3.03,9.02c0.88,2.55,1.66,5.27,2.33,8.16c-0.24-1.75-0.42-3.33-0.54-4.75s-0.18-2.75-0.18-4
    		v-8.44h3.06v22.62h-2.86l-3.41-10.18c-0.31-0.95-0.61-1.92-0.89-2.92s-0.53-2.04-0.77-3.13c-0.02-0.14-0.05-0.3-0.1-0.5
    		s-0.1-0.42-0.15-0.67c0.03,0.25,0.05,0.47,0.07,0.65s0.03,0.33,0.04,0.46l0.16,2.3l0.16,2.8c0.01,0.16,0.02,0.35,0.02,0.57
    		s0.01,0.48,0.01,0.76l0.16,9.86h-3V54.79z"/>
    	<path class="st5" d="M98.84,54.79h4.01c1.66,0,2.9,0.4,3.71,1.19c1.03,1.03,1.54,2.59,1.54,4.7c0,1.62-0.27,2.92-0.81,3.9
    		c-0.54,0.98-1.32,1.59-2.32,1.82l4.16,11h-3.09l-4.15-11.07v11.07h-3.05V54.79z M101.89,64.81c1.18,0,2.02-0.27,2.5-0.82
    		s0.73-1.47,0.73-2.77c0-0.7-0.05-1.3-0.15-1.8s-0.26-0.9-0.48-1.22s-0.5-0.54-0.85-0.69s-0.76-0.22-1.24-0.22h-0.51V64.81z"/>
    	<path class="st5" d="M113.43,54.79h3.05v22.62h-3.05V54.79z"/>
    	<path class="st5" d="M121.92,54.79h8.14v2.58h-5.1v7.15h4.6v2.58h-4.6v10.31h-3.05V54.79z"/>
    	<path class="st5" d="M137.21,54.79h2.37l4.85,22.62h-3.02L140.57,73h-4.48l-0.86,4.41h-2.93L137.21,54.79z M140.13,70.64l-0.67-3.6
    		c-0.45-2.45-0.82-5.07-1.1-7.85c-0.14,1.36-0.31,2.73-0.53,4.12c-0.21,1.39-0.47,2.87-0.76,4.43l-0.56,2.9H140.13z"/>
    	<path class="st5" d="M163.88,55.26v2.97c-0.93-0.66-1.76-1-2.5-1c-0.8,0-1.46,0.28-1.96,0.85c-0.51,0.54-0.76,1.25-0.76,2.15
    		c0,0.79,0.18,1.47,0.54,2.04c0.19,0.3,0.49,0.69,0.92,1.17s0.97,1.05,1.65,1.73c1.24,1.26,2.08,2.35,2.53,3.27
    		c0.45,0.89,0.67,1.98,0.67,3.27c0,1.75-0.49,3.19-1.48,4.32c-0.99,1.1-2.25,1.66-3.79,1.66c-1.3,0-2.41-0.36-3.33-1.07V73.6
    		c1.08,0.79,2.07,1.19,2.96,1.19c0.83,0,1.48-0.28,1.95-0.83s0.7-1.3,0.7-2.25c0-0.82-0.18-1.56-0.54-2.21
    		c-0.19-0.31-0.44-0.67-0.78-1.08s-0.75-0.86-1.25-1.36c-0.77-0.76-1.41-1.44-1.92-2.02s-0.88-1.1-1.13-1.54
    		c-0.47-0.86-0.7-1.94-0.7-3.25c0-1.77,0.46-3.17,1.38-4.2c0.93-1.04,2.17-1.57,3.74-1.57C161.85,54.49,162.89,54.75,163.88,55.26z"
    		/>
    	<path class="st5" d="M173.03,54.79h2.37l4.85,22.62h-3.02L176.39,73h-4.48l-0.86,4.41h-2.93L173.03,54.79z M175.95,70.64l-0.67-3.6
    		c-0.45-2.45-0.82-5.07-1.1-7.85c-0.14,1.36-0.31,2.73-0.53,4.12c-0.21,1.39-0.47,2.87-0.76,4.43l-0.56,2.9H175.95z"/>
    	<path class="st5" d="M183.99,54.79h2.84l3.03,9.02c0.88,2.55,1.66,5.27,2.33,8.16c-0.24-1.75-0.42-3.33-0.54-4.75
    		s-0.18-2.75-0.18-4v-8.44h3.06v22.62h-2.86l-3.41-10.18c-0.31-0.95-0.61-1.92-0.89-2.92s-0.53-2.04-0.77-3.13
    		c-0.02-0.14-0.05-0.3-0.1-0.5s-0.1-0.42-0.15-0.67c0.03,0.25,0.05,0.47,0.07,0.65s0.03,0.33,0.04,0.46l0.16,2.3l0.16,2.8
    		c0.01,0.16,0.02,0.35,0.02,0.57s0.01,0.48,0.01,0.76l0.16,9.86h-3V54.79z"/>
    	<path class="st5" d="M201.04,54.79h2.61l1.99,9.23c0.24,1.15,0.47,2.31,0.67,3.46c0.2,1.16,0.38,2.37,0.55,3.64
    		c0.02-0.17,0.03-0.29,0.04-0.39s0.02-0.16,0.03-0.2l0.42-2.59l0.38-2.46l0.34-1.63l1.77-9.07h2.64l2.08,22.62h-2.92l-0.51-7.68
    		c-0.02-0.39-0.04-0.73-0.05-1.01s-0.02-0.52-0.02-0.7l-0.13-3.03l-0.07-2.78c0-0.02,0-0.06-0.01-0.12c0-0.06-0.01-0.15-0.02-0.26
    		l-0.07,0.45c-0.08,0.54-0.15,1.01-0.21,1.41s-0.12,0.74-0.17,1.01l-0.38,2.07l-0.15,0.78l-1.9,9.87h-2.05l-1.79-8.53
    		c-0.24-1.12-0.46-2.26-0.65-3.42c-0.19-1.16-0.36-2.37-0.52-3.64l-0.88,15.59h-2.87L201.04,54.79z"/>
    	<path class="st5" d="M222.26,54.79h2.37l4.85,22.62h-3.02L225.61,73h-4.48l-0.86,4.41h-2.93L222.26,54.79z M225.17,70.64l-0.67-3.6
    		c-0.45-2.45-0.82-5.07-1.1-7.85c-0.14,1.36-0.31,2.73-0.53,4.12c-0.21,1.39-0.47,2.87-0.76,4.43l-0.56,2.9H225.17z"/>
    	<path class="st5" d="M233.22,54.79h4.01c1.66,0,2.9,0.4,3.71,1.19c1.03,1.03,1.54,2.59,1.54,4.7c0,1.62-0.27,2.92-0.81,3.9
    		c-0.54,0.98-1.32,1.59-2.32,1.82l4.16,11h-3.09l-4.15-11.07v11.07h-3.05V54.79z M236.26,64.81c1.18,0,2.02-0.27,2.5-0.82
    		s0.73-1.47,0.73-2.77c0-0.7-0.05-1.3-0.15-1.8s-0.26-0.9-0.48-1.22s-0.5-0.54-0.85-0.69s-0.76-0.22-1.24-0.22h-0.51V64.81z"/>
    	<path class="st5" d="M259.78,77.75l-1.92,1.38l-1.55-2.21c-0.93,0.52-1.91,0.78-2.94,0.78c-2.2,0-3.75-0.93-4.66-2.78
    		c-0.9-1.91-1.35-5.12-1.35-9.61c0-3.93,0.44-6.7,1.32-8.33c0.88-1.64,2.37-2.46,4.47-2.46c2.21,0,3.76,0.9,4.66,2.71
    		c0.89,1.77,1.33,4.9,1.33,9.4c0,4.07-0.42,6.9-1.27,8.48L259.78,77.75z M254.38,70.23l1.26,1.79c0.21-1.45,0.31-3.08,0.31-4.89
    		c0-3.89-0.19-6.51-0.56-7.88c-0.37-1.32-1.11-1.98-2.21-1.98c-1.04,0-1.73,0.56-2.09,1.68c-0.36,1.07-0.54,3.24-0.54,6.5
    		c0,3.66,0.19,6.16,0.56,7.5c0.37,1.28,1.09,1.92,2.17,1.92c0.43,0,0.84-0.14,1.23-0.41l-1.93-2.78L254.38,70.23z"/>
    	<path class="st5" d="M264.1,54.79h2.99v15.98c0,1.63,0.15,2.71,0.44,3.25c0.3,0.54,0.9,0.81,1.79,0.81s1.47-0.23,1.76-0.7
    		c0.29-0.48,0.44-1.45,0.44-2.92V54.79h2.99v16.42c0,2.46-0.38,4.13-1.13,5c-0.9,0.99-2.27,1.48-4.12,1.48
    		c-2.03,0-3.46-0.63-4.29-1.9c-0.58-0.87-0.86-2.54-0.86-5.01V54.79z"/>
    	<path class="st5" d="M279.94,54.79h3.05v22.62h-3.05V54.79z"/>
    	<path class="st5" d="M288.42,54.79h2.84l3.03,9.02c0.88,2.55,1.66,5.27,2.33,8.16c-0.24-1.75-0.42-3.33-0.54-4.75
    		s-0.18-2.75-0.18-4v-8.44h3.06v22.62h-2.86l-3.41-10.18c-0.31-0.95-0.61-1.92-0.89-2.92s-0.53-2.04-0.77-3.13
    		c-0.02-0.14-0.05-0.3-0.1-0.5s-0.1-0.42-0.15-0.67c0.03,0.25,0.05,0.47,0.07,0.65s0.03,0.33,0.04,0.46l0.16,2.3l0.16,2.8
    		c0.01,0.16,0.02,0.35,0.02,0.57s0.01,0.48,0.01,0.76l0.16,9.86h-3V54.79z"/>
    	<path class="st5" d="M308.05,54.79h2.37l4.85,22.62h-3.02L311.4,73h-4.48l-0.86,4.41h-2.93L308.05,54.79z M310.96,70.64l-0.67-3.6
    		c-0.45-2.45-0.82-5.07-1.1-7.85c-0.14,1.36-0.31,2.73-0.53,4.12c-0.21,1.39-0.47,2.87-0.76,4.43l-0.56,2.9H310.96z"/>
    	<path class="st5" d="M325.42,68.51h5.33v2.29h-5.33V68.51z"/>
    	<path class="st5" d="M342.61,54.79h8.14v2.58h-5.1v7.15h4.6v2.58h-4.6v10.31h-3.05V54.79z"/>
    	<path class="st5" d="M363.93,55.16v2.74c-0.78-0.38-1.44-0.57-1.96-0.57c-0.72,0-1.34,0.18-1.86,0.53
    		c-0.52,0.36-0.95,0.91-1.28,1.65c-0.34,0.74-0.59,1.68-0.75,2.82c-0.16,1.14-0.24,2.48-0.24,4.04c0,5.59,1.43,8.38,4.29,8.38
    		c0.5,0,1.1-0.16,1.8-0.47v2.8c-0.73,0.41-1.55,0.62-2.46,0.62c-4.58,0-6.87-3.74-6.87-11.22c0-4.04,0.56-7.05,1.68-9.02
    		c1.12-1.97,2.83-2.96,5.13-2.96C362.26,54.49,363.1,54.71,363.93,55.16z"/>
    	<path class="st5" d="M369.51,54.79h2.61l1.99,9.23c0.24,1.15,0.47,2.31,0.67,3.46c0.2,1.16,0.38,2.37,0.55,3.64
    		c0.02-0.17,0.03-0.29,0.04-0.39s0.02-0.16,0.03-0.2l0.42-2.59l0.38-2.46l0.34-1.63l1.77-9.07h2.64l2.08,22.62h-2.92l-0.51-7.68
    		c-0.02-0.39-0.04-0.73-0.05-1.01c-0.01-0.28-0.02-0.52-0.02-0.7l-0.13-3.03l-0.07-2.78c0-0.02,0-0.06-0.01-0.12
    		c0-0.06-0.01-0.15-0.02-0.26l-0.07,0.45c-0.08,0.54-0.15,1.01-0.21,1.41c-0.06,0.4-0.12,0.74-0.17,1.01l-0.38,2.07l-0.15,0.78
    		l-1.9,9.87h-2.05l-1.79-8.53c-0.24-1.12-0.46-2.26-0.65-3.42c-0.19-1.16-0.36-2.37-0.52-3.64l-0.88,15.59h-2.87L369.51,54.79z"/>
    </g>
    <g>
    	<path class="st5" d="M163.42,143.62v1.79c-0.56-0.4-1.06-0.6-1.51-0.6c-0.48,0-0.88,0.17-1.18,0.51c-0.31,0.32-0.46,0.75-0.46,1.29
    		c0,0.48,0.11,0.88,0.33,1.22c0.11,0.18,0.29,0.42,0.55,0.71c0.26,0.29,0.59,0.63,0.99,1.04c0.75,0.76,1.25,1.41,1.52,1.96
    		c0.27,0.53,0.4,1.19,0.4,1.96c0,1.05-0.3,1.92-0.89,2.6c-0.59,0.66-1.35,1-2.28,1c-0.78,0-1.45-0.21-2-0.64v-1.81
    		c0.65,0.48,1.24,0.71,1.78,0.71c0.5,0,0.89-0.17,1.17-0.5c0.28-0.33,0.42-0.78,0.42-1.35c0-0.49-0.11-0.94-0.33-1.33
    		c-0.11-0.19-0.27-0.4-0.47-0.65c-0.2-0.24-0.45-0.52-0.75-0.82c-0.46-0.46-0.85-0.86-1.15-1.21c-0.31-0.35-0.53-0.66-0.68-0.92
    		c-0.28-0.52-0.42-1.17-0.42-1.96c0-1.06,0.28-1.91,0.83-2.53c0.56-0.63,1.31-0.94,2.25-0.94
    		C162.21,143.16,162.83,143.31,163.42,143.62z"/>
    	<path class="st5" d="M172.99,141.98h1.42l-8.1,18.7h-1.44L172.99,141.98z"/>
    	<path class="st5" d="M182.15,143.34h4.32v1.58h-2.93l-0.44,3.42h0.22c0.53,0,1.01,0.08,1.42,0.26c0.41,0.17,0.76,0.42,1.04,0.75
    		c0.28,0.33,0.5,0.73,0.64,1.22c0.15,0.48,0.22,1.03,0.22,1.65c0,1.53-0.33,2.73-1,3.6c-0.66,0.86-1.59,1.29-2.77,1.29
    		c-0.66,0-1.38-0.19-2.16-0.56l0.46-1.62c0.63,0.33,1.15,0.49,1.58,0.49c0.6,0,1.07-0.27,1.43-0.81c0.35-0.55,0.53-1.28,0.53-2.2
    		c0-1.74-0.75-2.62-2.25-2.62c-0.37,0-0.74,0.06-1.12,0.17L182.15,143.34z"/>
    	<path class="st5" d="M190.49,154.9c0.29,0,0.54,0.11,0.75,0.33c0.21,0.21,0.32,0.47,0.32,0.77s-0.11,0.55-0.32,0.77
    		c-0.22,0.21-0.48,0.31-0.77,0.31c-0.15,0-0.29-0.03-0.43-0.08c-0.13-0.06-0.25-0.13-0.35-0.23c-0.1-0.1-0.18-0.21-0.23-0.34
    		c-0.06-0.13-0.08-0.27-0.08-0.43c0-0.3,0.11-0.55,0.32-0.77C189.91,155,190.18,154.9,190.49,154.9z"/>
    	<path class="st5" d="M200.31,150.25c0,2.44-0.23,4.21-0.7,5.29c-0.46,1.04-1.25,1.57-2.37,1.57s-1.91-0.53-2.38-1.58
    		c-0.46-1.02-0.7-2.82-0.7-5.38s0.23-4.36,0.7-5.38c0.46-1.06,1.25-1.58,2.37-1.58c1.03,0,1.8,0.46,2.29,1.39
    		C200.04,145.55,200.31,147.44,200.31,150.25z M198.44,150.25c0-2.05-0.09-3.48-0.26-4.26c-0.18-0.78-0.5-1.17-0.96-1.17
    		s-0.79,0.39-0.97,1.16c-0.18,0.78-0.26,2.17-0.26,4.18c0,2.01,0.09,3.41,0.26,4.19c0.18,0.78,0.5,1.16,0.97,1.16
    		c0.46,0,0.78-0.38,0.95-1.15C198.35,153.63,198.44,152.26,198.44,150.25z"/>
    	<path class="st5" d="M208.95,150.25c0,2.44-0.23,4.21-0.7,5.29c-0.46,1.04-1.25,1.57-2.37,1.57s-1.91-0.53-2.38-1.58
    		c-0.46-1.02-0.7-2.82-0.7-5.38s0.23-4.36,0.7-5.38c0.46-1.06,1.25-1.58,2.37-1.58c1.03,0,1.8,0.46,2.29,1.39
    		C208.69,145.55,208.95,147.44,208.95,150.25z M207.08,150.25c0-2.05-0.09-3.48-0.26-4.26c-0.18-0.78-0.5-1.17-0.96-1.17
    		s-0.79,0.39-0.97,1.16c-0.18,0.78-0.26,2.17-0.26,4.18c0,2.01,0.09,3.41,0.26,4.19c0.18,0.78,0.5,1.16,0.97,1.16
    		c0.46,0,0.78-0.38,0.95-1.15C206.99,153.63,207.08,152.26,207.08,150.25z"/>
    	<path class="st5" d="M221.27,143.62v1.79c-0.56-0.4-1.06-0.6-1.51-0.6c-0.48,0-0.88,0.17-1.18,0.51c-0.31,0.32-0.46,0.75-0.46,1.29
    		c0,0.48,0.11,0.88,0.33,1.22c0.11,0.18,0.29,0.42,0.55,0.71c0.26,0.29,0.59,0.63,0.99,1.04c0.75,0.76,1.25,1.41,1.52,1.96
    		c0.27,0.53,0.4,1.19,0.4,1.96c0,1.05-0.3,1.92-0.89,2.6c-0.59,0.66-1.35,1-2.28,1c-0.78,0-1.45-0.21-2-0.64v-1.81
    		c0.65,0.48,1.24,0.71,1.78,0.71c0.5,0,0.89-0.17,1.17-0.5c0.28-0.33,0.42-0.78,0.42-1.35c0-0.49-0.11-0.94-0.33-1.33
    		c-0.11-0.19-0.27-0.4-0.47-0.65c-0.2-0.24-0.45-0.52-0.75-0.82c-0.46-0.46-0.85-0.86-1.15-1.21c-0.31-0.35-0.53-0.66-0.68-0.92
    		c-0.28-0.52-0.42-1.17-0.42-1.96c0-1.06,0.28-1.91,0.83-2.53c0.56-0.63,1.31-0.94,2.25-0.94
    		C220.06,143.16,220.68,143.31,221.27,143.62z"/>
    	<path class="st5" d="M231.45,150.48c0,2.4-0.27,4.11-0.8,5.12s-1.43,1.51-2.69,1.51c-1.32,0-2.25-0.54-2.79-1.63
    		c-0.53-1.06-0.8-2.95-0.8-5.66c0-2.42,0.26-4.13,0.79-5.13c0.53-1.01,1.44-1.51,2.71-1.51c1.14,0,1.98,0.39,2.54,1.17
    		c0.36,0.52,0.63,1.27,0.79,2.23C231.37,147.46,231.45,148.76,231.45,150.48z M229.53,150.67c0-2.35-0.11-3.92-0.32-4.69
    		c-0.21-0.78-0.64-1.16-1.29-1.16s-1.09,0.36-1.3,1.07c-0.21,0.72-0.32,2.15-0.32,4.32c0,1.99,0.11,3.37,0.33,4.14
    		c0.23,0.73,0.66,1.09,1.29,1.09c0.62,0,1.04-0.34,1.27-1.02C229.41,153.74,229.53,152.49,229.53,150.67z"/>
    	<path class="st5" d="M234.44,143.34h1.83v12.05h2.99v1.55h-4.83V143.34z"/>
    	<path class="st5" d="M241.58,143.34h4.87v1.55h-3.04v4.31h2.7v1.55h-2.7v4.64h3.04v1.55h-4.87V143.34z"/>
    	<path class="st5" d="M253.84,143.62v1.79c-0.56-0.4-1.06-0.6-1.51-0.6c-0.48,0-0.88,0.17-1.18,0.51c-0.31,0.32-0.46,0.75-0.46,1.29
    		c0,0.48,0.11,0.88,0.33,1.22c0.11,0.18,0.29,0.42,0.55,0.71c0.26,0.29,0.59,0.63,0.99,1.04c0.75,0.76,1.25,1.41,1.52,1.96
    		c0.27,0.53,0.4,1.19,0.4,1.96c0,1.05-0.3,1.92-0.89,2.6c-0.59,0.66-1.35,1-2.28,1c-0.78,0-1.45-0.21-2-0.64v-1.81
    		c0.65,0.48,1.24,0.71,1.78,0.71c0.5,0,0.89-0.17,1.17-0.5c0.28-0.33,0.42-0.78,0.42-1.35c0-0.49-0.11-0.94-0.33-1.33
    		c-0.11-0.19-0.27-0.4-0.47-0.65c-0.2-0.24-0.45-0.52-0.75-0.82c-0.46-0.46-0.85-0.86-1.15-1.21c-0.31-0.35-0.53-0.66-0.68-0.92
    		c-0.28-0.52-0.42-1.17-0.42-1.96c0-1.06,0.28-1.91,0.83-2.53c0.56-0.63,1.31-0.94,2.25-0.94
    		C252.63,143.16,253.25,143.31,253.84,143.62z"/>
    </g>
    <g>
    	<polyline class="st4" points="46.16,190.19 10.16,190.19 10.16,153.62 	"/>
    	<circle class="st4" cx="21.2" cy="179.3" r="2.46"/>
    	<path class="st4" d="M13.99,190.24"/>
    	<path class="st4" d="M29.62,153.67"/>
    	<path class="st4" d="M10.16,185.41c3.89-1.09,6.98,0.73,5.43,5.1"/>
    	<path class="st4" d="M28.97,184.75c-0.05,0.42,0.59,0.94,1.87,1.97c0.68,0.55,1.04,0.83,1.53,1.13c0.85,0.52,1.58,0.79,1.92,0.91
    		c0.6,0.21,1.19,0.41,1.98,0.45c1.16,0.06,2.04-0.26,2.55-0.45c0.74-0.28,1.67-0.63,2.42-1.57c0.24-0.3,0.75-0.95,0.86-1.94
    		c0.11-0.94-0.21-1.65-0.28-1.81c-0.36-0.76-0.91-1.17-1.17-1.36c-0.5-0.36-0.94-0.49-1.58-0.68c-0.79-0.23-1.7-0.49-2.91-0.42
    		c-0.92,0.06-1.59,0.29-2.37,0.56c-1.02,0.36-1.73,0.76-1.94,0.87c-0.5,0.29-0.87,0.58-1.64,1.16
    		C29.04,184.47,28.99,184.62,28.97,184.75z"/>
    	<path class="st4" d="M23.97,178.74c0.01,0.32,0.37,0.45,1.92,1.36c1.35,0.79,1.41,0.88,1.87,1.02c0.43,0.13,1.23,0.36,2.21,0.11
    		c0.34-0.09,1.2-0.31,1.81-1.13c0.65-0.87,0.59-1.83,0.57-2.09c-0.03-0.31-0.08-0.84-0.45-1.36c-0.45-0.62-1.09-0.83-1.39-0.92
    		c-0.75-0.23-1.39-0.1-1.85,0c-0.64,0.14-1.09,0.38-1.97,0.86c-0.51,0.28-0.95,0.56-1.36,0.85
    		C24.41,178.09,23.96,178.42,23.97,178.74z"/>
    	<path class="st4" d="M21.79,176.59c0.32-0.01,0.46-0.36,1.39-1.9c0.81-1.34,0.9-1.4,1.05-1.85c0.14-0.43,0.39-1.23,0.15-2.21
    		c-0.08-0.34-0.29-1.2-1.1-1.83c-0.86-0.67-1.81-0.62-2.08-0.6c-0.31,0.02-0.84,0.06-1.37,0.43c-0.63,0.44-0.85,1.08-0.94,1.37
    		c-0.24,0.75-0.13,1.39-0.03,1.85c0.13,0.65,0.36,1.09,0.83,1.98c0.27,0.52,0.54,0.96,0.83,1.37
    		C21.14,176.13,21.46,176.59,21.79,176.59z"/>
    	<path class="st4" d="M24.45,186.03c0.26-1.27-0.06-2.52-0.91-3.25c-0.67-0.57-1.48-0.66-1.54-0.66c-0.72-0.07-1.26,0.18-1.48,0.29
    		c-0.96,0.46-1.37,1.29-1.47,1.51c-0.34,0.72-0.32,1.36-0.3,1.77c0.01,0.37,0.05,1.04,0.45,1.77c0.13,0.23,0.43,0.71,0.98,1.13
    		c0.6,0.45,1.17,0.59,1.74,0.72c1.18,0.27,2.14,0.15,2.38,0.11c0.58-0.08,1.44-0.2,2.26-0.83c0.71-0.55,1.03-1.21,1.25-1.66
    		c0.32-0.66,0.42-1.19,0.57-1.96c0.15-0.78,0.18-1.38,0.23-2.11c0.04-0.77,0.05-1.41,0.04-1.89"/>
    	<path class="st4" d="M14.15,176.07c1.27-0.25,2.52,0.08,3.24,0.93c0.57,0.67,0.65,1.49,0.65,1.55c0.06,0.72-0.19,1.26-0.3,1.47
    		c-0.47,0.95-1.3,1.36-1.52,1.46c-0.72,0.34-1.37,0.31-1.78,0.29c-0.37-0.02-1.04-0.06-1.77-0.47c-0.23-0.13-0.71-0.43-1.12-0.99
    		c-0.45-0.6-0.58-1.17-0.7-1.74c-0.27-1.19-0.13-2.14-0.09-2.38c0.08-0.58,0.21-1.44,0.85-2.26c0.55-0.7,1.22-1.02,1.67-1.23
    		c0.66-0.31,1.19-0.41,1.97-0.55c0.78-0.14,1.38-0.17,2.11-0.21c0.77-0.04,1.41-0.04,1.89-0.02"/>
    	<path class="st4" d="M14.27,171.91c0.42,0.05,0.94-0.59,1.97-1.87c0.55-0.68,0.83-1.04,1.13-1.53c0.52-0.85,0.79-1.58,0.91-1.92
    		c0.21-0.6,0.41-1.19,0.45-1.98c0.06-1.16-0.26-2.04-0.45-2.55c-0.28-0.74-0.63-1.67-1.57-2.42c-0.3-0.24-0.95-0.75-1.94-0.86
    		c-0.94-0.11-1.65,0.21-1.81,0.28c-0.76,0.36-1.17,0.91-1.36,1.17c-0.36,0.5-0.49,0.94-0.68,1.58c-0.23,0.79-0.49,1.7-0.42,2.91
    		c0.06,0.92,0.29,1.59,0.56,2.37c0.36,1.02,0.76,1.73,0.87,1.94c0.29,0.5,0.58,0.87,1.16,1.64
    		C13.99,171.83,14.14,171.89,14.27,171.91z"/>
    </g>
    <g>
    	<polyline class="st4" points="405.11,153.91 405.11,189.91 368.54,189.91 	"/>
    	<circle class="st4" cx="394.22" cy="178.87" r="2.46"/>
    	<path class="st4" d="M405.15,186.08"/>
    	<path class="st4" d="M368.59,170.45"/>
    	<path class="st4" d="M400.33,189.91c-1.09-3.89,0.73-6.98,5.1-5.43"/>
    	<path class="st4" d="M399.67,171.1c0.42,0.05,0.94-0.59,1.97-1.87c0.55-0.68,0.83-1.04,1.13-1.53c0.52-0.85,0.79-1.58,0.91-1.92
    		c0.21-0.6,0.41-1.19,0.45-1.98c0.06-1.16-0.26-2.04-0.45-2.55c-0.28-0.74-0.63-1.67-1.57-2.42c-0.3-0.24-0.95-0.75-1.94-0.86
    		c-0.94-0.11-1.65,0.21-1.81,0.28c-0.76,0.36-1.17,0.91-1.36,1.17c-0.36,0.5-0.49,0.94-0.68,1.58c-0.23,0.79-0.49,1.7-0.42,2.91
    		c0.06,0.92,0.29,1.59,0.56,2.37c0.36,1.02,0.76,1.73,0.87,1.94c0.29,0.5,0.58,0.87,1.16,1.64
    		C399.39,171.03,399.54,171.09,399.67,171.1z"/>
    	<path class="st4" d="M393.66,176.1c0.32-0.01,0.45-0.37,1.36-1.92c0.79-1.35,0.88-1.41,1.02-1.87c0.13-0.43,0.36-1.23,0.11-2.21
    		c-0.09-0.34-0.31-1.2-1.13-1.81c-0.87-0.65-1.83-0.59-2.09-0.57c-0.31,0.03-0.84,0.08-1.36,0.45c-0.62,0.45-0.83,1.09-0.92,1.39
    		c-0.23,0.75-0.1,1.39,0,1.85c0.14,0.64,0.38,1.09,0.86,1.97c0.28,0.51,0.56,0.95,0.85,1.36
    		C393.01,175.66,393.34,176.11,393.66,176.1z"/>
    	<path class="st4" d="M391.51,178.28c-0.01-0.32-0.36-0.46-1.9-1.39c-1.34-0.81-1.4-0.9-1.85-1.05c-0.43-0.14-1.23-0.39-2.21-0.15
    		c-0.34,0.08-1.2,0.29-1.83,1.1c-0.67,0.86-0.62,1.81-0.6,2.08c0.02,0.31,0.06,0.84,0.43,1.37c0.44,0.63,1.08,0.85,1.37,0.94
    		c0.75,0.24,1.39,0.13,1.85,0.03c0.65-0.13,1.09-0.36,1.98-0.83c0.52-0.27,0.96-0.54,1.37-0.83
    		C391.05,178.93,391.51,178.61,391.51,178.28z"/>
    	<path class="st4" d="M400.95,175.62c-1.27-0.26-2.52,0.06-3.25,0.91c-0.57,0.67-0.66,1.48-0.66,1.54
    		c-0.07,0.72,0.18,1.26,0.29,1.48c0.46,0.96,1.29,1.37,1.51,1.47c0.72,0.34,1.36,0.32,1.77,0.3c0.37-0.01,1.04-0.05,1.77-0.45
    		c0.23-0.13,0.71-0.43,1.13-0.98c0.45-0.6,0.59-1.17,0.72-1.74c0.27-1.18,0.15-2.14,0.11-2.38c-0.08-0.58-0.2-1.44-0.83-2.26
    		c-0.55-0.71-1.21-1.03-1.66-1.25c-0.66-0.32-1.19-0.42-1.96-0.57c-0.78-0.15-1.38-0.18-2.11-0.23c-0.77-0.04-1.41-0.05-1.89-0.04"
    		/>
    	<path class="st4" d="M390.98,185.92c-0.25-1.27,0.08-2.52,0.93-3.24c0.67-0.57,1.49-0.65,1.55-0.65c0.72-0.06,1.26,0.19,1.47,0.3
    		c0.95,0.47,1.36,1.3,1.46,1.52c0.34,0.72,0.31,1.37,0.29,1.78c-0.02,0.37-0.06,1.04-0.47,1.77c-0.13,0.23-0.43,0.71-0.99,1.12
    		c-0.6,0.45-1.17,0.58-1.74,0.7c-1.19,0.27-2.14,0.13-2.38,0.09c-0.58-0.08-1.44-0.21-2.26-0.85c-0.7-0.55-1.02-1.22-1.23-1.67
    		c-0.31-0.66-0.41-1.19-0.55-1.97c-0.14-0.78-0.17-1.38-0.21-2.11c-0.04-0.77-0.04-1.41-0.02-1.89"/>
    	<path class="st4" d="M386.83,185.8c0.05-0.42-0.59-0.94-1.87-1.97c-0.68-0.55-1.04-0.83-1.53-1.13c-0.85-0.52-1.58-0.79-1.92-0.91
    		c-0.6-0.21-1.19-0.41-1.98-0.45c-1.16-0.06-2.04,0.26-2.55,0.45c-0.74,0.28-1.67,0.63-2.42,1.57c-0.24,0.3-0.75,0.95-0.86,1.94
    		c-0.11,0.94,0.21,1.65,0.28,1.81c0.36,0.76,0.91,1.17,1.17,1.36c0.5,0.36,0.94,0.49,1.58,0.68c0.79,0.23,1.7,0.49,2.91,0.42
    		c0.92-0.06,1.59-0.29,2.37-0.56c1.02-0.36,1.73-0.76,1.94-0.87c0.5-0.29,0.87-0.58,1.64-1.16
    		C386.75,186.08,386.81,185.93,386.83,185.8z"/>
    </g>
    <g>
    	<polyline class="st4" points="369.02,9.66 405.02,9.66 405.02,46.22 	"/>
    	<circle class="st4" cx="393.97" cy="20.55" r="2.46"/>
    	<path class="st4" d="M401.19,9.61"/>
    	<path class="st4" d="M385.56,46.18"/>
    	<path class="st4" d="M405.02,14.44c-3.89,1.09-6.98-0.73-5.43-5.1"/>
    	<path class="st4" d="M386.21,15.1c0.05-0.42-0.59-0.94-1.87-1.97c-0.68-0.55-1.04-0.83-1.53-1.13c-0.85-0.52-1.58-0.79-1.92-0.91
    		c-0.6-0.21-1.19-0.41-1.98-0.45c-1.16-0.06-2.04,0.26-2.55,0.45c-0.74,0.28-1.67,0.63-2.42,1.57c-0.24,0.3-0.75,0.95-0.86,1.94
    		c-0.11,0.94,0.21,1.65,0.28,1.81c0.36,0.76,0.91,1.17,1.17,1.36c0.5,0.36,0.94,0.49,1.58,0.68c0.79,0.23,1.7,0.49,2.91,0.42
    		c0.92-0.06,1.59-0.29,2.37-0.56c1.02-0.36,1.73-0.76,1.94-0.87c0.5-0.29,0.87-0.58,1.64-1.16
    		C386.13,15.38,386.19,15.23,386.21,15.1z"/>
    	<path class="st4" d="M391.21,21.11c-0.01-0.32-0.37-0.45-1.92-1.36c-1.35-0.79-1.41-0.88-1.87-1.02c-0.43-0.13-1.23-0.36-2.21-0.11
    		c-0.34,0.09-1.2,0.31-1.81,1.13c-0.65,0.87-0.59,1.83-0.57,2.09c0.03,0.31,0.08,0.84,0.45,1.36c0.45,0.62,1.09,0.83,1.39,0.92
    		c0.75,0.23,1.39,0.1,1.85,0c0.64-0.14,1.09-0.38,1.97-0.86c0.51-0.28,0.95-0.56,1.36-0.85C390.77,21.76,391.22,21.43,391.21,21.11z
    		"/>
    	<path class="st4" d="M393.39,23.26c-0.32,0.01-0.46,0.36-1.39,1.9c-0.81,1.34-0.9,1.4-1.05,1.85c-0.14,0.43-0.39,1.23-0.15,2.21
    		c0.08,0.34,0.29,1.2,1.1,1.83c0.86,0.67,1.81,0.62,2.08,0.6c0.31-0.02,0.84-0.06,1.37-0.43c0.63-0.44,0.85-1.08,0.94-1.37
    		c0.24-0.75,0.13-1.39,0.03-1.85c-0.13-0.65-0.36-1.09-0.83-1.98c-0.27-0.52-0.54-0.96-0.83-1.37
    		C394.03,23.72,393.72,23.26,393.39,23.26z"/>
    	<path class="st4" d="M390.73,13.82c-0.26,1.27,0.06,2.52,0.91,3.25c0.67,0.57,1.48,0.66,1.54,0.66c0.72,0.07,1.26-0.18,1.48-0.29
    		c0.96-0.46,1.37-1.29,1.47-1.51c0.34-0.72,0.32-1.36,0.3-1.77c-0.01-0.37-0.05-1.04-0.45-1.77c-0.13-0.23-0.43-0.71-0.98-1.13
    		c-0.6-0.45-1.17-0.59-1.74-0.72c-1.18-0.27-2.14-0.15-2.38-0.11c-0.58,0.08-1.44,0.2-2.26,0.83c-0.71,0.55-1.03,1.21-1.25,1.66
    		c-0.32,0.66-0.42,1.19-0.57,1.96c-0.15,0.78-0.18,1.38-0.23,2.11c-0.04,0.77-0.05,1.41-0.04,1.89"/>
    	<path class="st4" d="M401.03,23.78c-1.27,0.25-2.52-0.08-3.24-0.93c-0.57-0.67-0.65-1.49-0.65-1.55c-0.06-0.72,0.19-1.26,0.3-1.47
    		c0.47-0.95,1.3-1.36,1.52-1.46c0.72-0.34,1.37-0.31,1.78-0.29c0.37,0.02,1.04,0.06,1.77,0.47c0.23,0.13,0.71,0.43,1.12,0.99
    		c0.45,0.6,0.58,1.17,0.7,1.74c0.27,1.19,0.13,2.14,0.09,2.38c-0.08,0.58-0.21,1.44-0.85,2.26c-0.55,0.7-1.22,1.02-1.67,1.23
    		c-0.66,0.31-1.19,0.41-1.97,0.55c-0.78,0.14-1.38,0.17-2.11,0.21c-0.77,0.04-1.41,0.04-1.89,0.02"/>
    	<path class="st4" d="M400.91,27.94c-0.42-0.05-0.94,0.59-1.97,1.87c-0.55,0.68-0.83,1.04-1.13,1.53c-0.52,0.85-0.79,1.58-0.91,1.92
    		c-0.21,0.6-0.41,1.19-0.45,1.98c-0.06,1.16,0.26,2.04,0.45,2.55c0.28,0.74,0.63,1.67,1.57,2.42c0.3,0.24,0.95,0.75,1.94,0.86
    		c0.94,0.11,1.65-0.21,1.81-0.28c0.76-0.36,1.17-0.91,1.36-1.17c0.36-0.5,0.49-0.94,0.68-1.58c0.23-0.79,0.49-1.7,0.42-2.91
    		c-0.06-0.92-0.29-1.59-0.56-2.37c-0.36-1.02-0.76-1.73-0.87-1.94c-0.29-0.5-0.58-0.87-1.16-1.64
    		C401.19,28.02,401.04,27.96,400.91,27.94z"/>
    </g>
    <g>
    	<path class="st2" d="M85.85,26.03c0,0.34-0.04,0.67-0.12,0.98c-0.08,0.31-0.21,0.59-0.39,0.83c-0.18,0.24-0.42,0.43-0.72,0.58
    		s-0.66,0.22-1.09,0.22c-0.43,0-0.8-0.07-1.09-0.22c-0.3-0.14-0.54-0.34-0.72-0.58c-0.18-0.24-0.31-0.52-0.39-0.83
    		c-0.08-0.31-0.12-0.64-0.12-0.98v-3.93h0.59v3.78c0,0.23,0.02,0.47,0.06,0.73c0.04,0.26,0.12,0.5,0.25,0.72
    		c0.12,0.22,0.3,0.41,0.52,0.55c0.23,0.14,0.52,0.22,0.9,0.22s0.67-0.07,0.9-0.22c0.23-0.14,0.4-0.33,0.52-0.55
    		c0.12-0.22,0.21-0.46,0.25-0.72c0.04-0.26,0.06-0.5,0.06-0.73v-3.78h0.59V26.03z"/>
    	<path class="st2" d="M88.38,22.09h0.77l3.88,5.58h0.02v-5.58h0.59v6.37h-0.77l-3.88-5.58h-0.02v5.58h-0.59V22.09z"/>
    	<path class="st2" d="M96.28,22.09h0.59v6.37h-0.59V22.09z"/>
    	<path class="st2" d="M98.62,22.09h0.64l2.05,5.59l2.07-5.59h0.63l-2.42,6.37h-0.59L98.62,22.09z"/>
    	<path class="st2" d="M105.75,22.09h3.9v0.54h-3.3v2.27h3.1v0.54h-3.1v2.48h3.45v0.54h-4.04V22.09z"/>
    	<path class="st2" d="M111.99,22.09h1.67c0.08,0,0.2,0,0.34,0.01c0.14,0.01,0.3,0.02,0.47,0.05c0.17,0.03,0.34,0.08,0.51,0.14
    		c0.17,0.07,0.33,0.16,0.47,0.29s0.25,0.29,0.34,0.48c0.09,0.19,0.13,0.43,0.13,0.7c0,0.31-0.05,0.56-0.16,0.76
    		c-0.11,0.2-0.24,0.36-0.4,0.48c-0.16,0.12-0.33,0.21-0.53,0.27s-0.38,0.1-0.55,0.13l1.85,3.06h-0.67l-1.79-3.02h-1.11v3.02h-0.59
    		V22.09z M112.59,24.9h1.26c0.31,0,0.57-0.04,0.76-0.12c0.2-0.08,0.35-0.17,0.45-0.29c0.11-0.11,0.18-0.24,0.22-0.37
    		s0.06-0.25,0.06-0.36c0-0.11-0.02-0.23-0.06-0.36c-0.04-0.13-0.11-0.25-0.22-0.37c-0.11-0.11-0.26-0.21-0.45-0.29
    		c-0.19-0.08-0.45-0.12-0.76-0.12h-1.26V24.9z"/>
    	<path class="st2" d="M118.4,27.29c0.16,0.27,0.36,0.47,0.61,0.6c0.25,0.13,0.53,0.2,0.85,0.2c0.2,0,0.38-0.03,0.56-0.09
    		c0.17-0.06,0.33-0.14,0.45-0.25c0.13-0.11,0.23-0.24,0.31-0.39c0.08-0.15,0.11-0.33,0.11-0.52c0-0.22-0.05-0.41-0.14-0.55
    		c-0.09-0.14-0.22-0.26-0.37-0.36c-0.16-0.09-0.33-0.17-0.53-0.24c-0.2-0.07-0.4-0.13-0.6-0.2c-0.21-0.07-0.41-0.14-0.6-0.22
    		s-0.37-0.19-0.53-0.33c-0.16-0.14-0.28-0.3-0.37-0.51c-0.09-0.2-0.14-0.46-0.14-0.76c0-0.28,0.06-0.53,0.17-0.75
    		c0.11-0.22,0.26-0.4,0.45-0.55s0.41-0.26,0.65-0.33s0.5-0.11,0.77-0.11c0.35,0,0.67,0.06,0.97,0.18c0.3,0.12,0.55,0.33,0.77,0.62
    		l-0.51,0.37c-0.15-0.21-0.33-0.37-0.53-0.47c-0.2-0.1-0.44-0.16-0.72-0.16c-0.19,0-0.38,0.03-0.55,0.08
    		c-0.17,0.05-0.33,0.13-0.45,0.23s-0.23,0.22-0.31,0.37s-0.12,0.33-0.12,0.53c0,0.32,0.08,0.56,0.24,0.73
    		c0.16,0.17,0.36,0.31,0.61,0.41c0.24,0.1,0.51,0.19,0.79,0.26c0.29,0.08,0.55,0.18,0.79,0.3c0.24,0.13,0.45,0.3,0.61,0.53
    		c0.16,0.23,0.24,0.54,0.24,0.93c0,0.29-0.05,0.54-0.16,0.77c-0.11,0.22-0.25,0.41-0.44,0.56c-0.18,0.15-0.4,0.27-0.63,0.35
    		c-0.24,0.08-0.49,0.12-0.75,0.12c-0.42,0-0.81-0.07-1.16-0.22c-0.35-0.15-0.66-0.39-0.91-0.74L118.4,27.29z"/>
    	<path class="st2" d="M124.13,22.09h0.59v6.37h-0.59V22.09z"/>
    	<path class="st2" d="M127.29,22.09h1.97c0.55,0,1.02,0.07,1.4,0.2c0.38,0.13,0.7,0.31,0.96,0.52s0.46,0.44,0.6,0.7
    		c0.15,0.26,0.25,0.5,0.32,0.73c0.07,0.23,0.11,0.45,0.13,0.63s0.03,0.32,0.03,0.4c0,0.08-0.01,0.21-0.03,0.4s-0.06,0.4-0.13,0.63
    		c-0.07,0.23-0.18,0.48-0.32,0.73s-0.35,0.49-0.6,0.7c-0.25,0.21-0.57,0.38-0.96,0.52c-0.38,0.14-0.85,0.2-1.4,0.2h-1.97V22.09z
    		 M127.89,27.93h1.22c0.42,0,0.81-0.05,1.18-0.16c0.37-0.1,0.68-0.27,0.95-0.48c0.27-0.22,0.48-0.49,0.64-0.82
    		c0.16-0.33,0.23-0.73,0.23-1.18s-0.08-0.85-0.23-1.18c-0.16-0.33-0.37-0.61-0.64-0.82c-0.27-0.22-0.59-0.38-0.95-0.48
    		c-0.37-0.1-0.76-0.16-1.18-0.16h-1.22V27.93z"/>
    	<path class="st2" d="M136.9,22.09h0.61l2.68,6.37h-0.67l-0.69-1.69h-3.38l-0.72,1.69h-0.62L136.9,22.09z M137.17,22.74l-1.48,3.49
    		h2.92L137.17,22.74z"/>
    	<path class="st2" d="M141.93,22.09h1.97c0.55,0,1.02,0.07,1.4,0.2c0.38,0.13,0.7,0.31,0.96,0.52s0.46,0.44,0.6,0.7
    		c0.15,0.26,0.25,0.5,0.32,0.73c0.07,0.23,0.11,0.45,0.13,0.63s0.03,0.32,0.03,0.4c0,0.08-0.01,0.21-0.03,0.4s-0.06,0.4-0.13,0.63
    		c-0.07,0.23-0.18,0.48-0.32,0.73s-0.35,0.49-0.6,0.7c-0.25,0.21-0.57,0.38-0.96,0.52c-0.38,0.14-0.85,0.2-1.4,0.2h-1.97V22.09z
    		 M142.52,27.93h1.22c0.42,0,0.81-0.05,1.18-0.16c0.37-0.1,0.68-0.27,0.95-0.48c0.27-0.22,0.48-0.49,0.64-0.82
    		c0.16-0.33,0.23-0.73,0.23-1.18s-0.08-0.85-0.23-1.18c-0.16-0.33-0.37-0.61-0.64-0.82c-0.27-0.22-0.59-0.38-0.95-0.48
    		c-0.37-0.1-0.76-0.16-1.18-0.16h-1.22V27.93z"/>
    	<path class="st2" d="M152.82,22.09h0.77l3.88,5.58h0.02v-5.58h0.59v6.37h-0.77l-3.88-5.58h-0.02v5.58h-0.59V22.09z"/>
    	<path class="st2" d="M162.67,22.09h0.61l2.68,6.37h-0.67l-0.69-1.69h-3.38l-0.72,1.69h-0.62L162.67,22.09z M162.95,22.74
    		l-1.48,3.49h2.92L162.95,22.74z"/>
    	<path class="st2" d="M173.03,27.47c-0.31,0.41-0.66,0.71-1.06,0.89c-0.4,0.18-0.84,0.27-1.31,0.27c-0.49,0-0.93-0.08-1.34-0.25
    		s-0.75-0.4-1.04-0.69c-0.29-0.3-0.51-0.65-0.67-1.06c-0.16-0.41-0.24-0.86-0.24-1.35s0.08-0.93,0.24-1.34
    		c0.16-0.41,0.39-0.76,0.67-1.06s0.63-0.53,1.04-0.7c0.4-0.17,0.85-0.25,1.34-0.25c0.43,0,0.84,0.08,1.21,0.23
    		c0.38,0.15,0.7,0.41,0.99,0.77l-0.49,0.41c-0.2-0.3-0.45-0.52-0.76-0.66c-0.31-0.14-0.63-0.21-0.95-0.21
    		c-0.41,0-0.79,0.07-1.12,0.22s-0.62,0.34-0.85,0.59c-0.23,0.25-0.41,0.55-0.54,0.89s-0.19,0.71-0.19,1.11s0.06,0.77,0.19,1.11
    		c0.13,0.34,0.31,0.64,0.54,0.89c0.23,0.25,0.52,0.45,0.85,0.59c0.33,0.14,0.71,0.22,1.12,0.22c0.16,0,0.33-0.02,0.5-0.06
    		c0.17-0.04,0.34-0.1,0.51-0.18c0.17-0.08,0.32-0.18,0.47-0.31s0.28-0.27,0.4-0.45L173.03,27.47z"/>
    	<path class="st2" d="M175.02,22.09h0.59v6.37h-0.59V22.09z"/>
    	<path class="st2" d="M177.84,25.28c0-0.49,0.08-0.93,0.24-1.34c0.16-0.41,0.39-0.76,0.67-1.06s0.63-0.53,1.04-0.7
    		c0.4-0.17,0.85-0.25,1.34-0.25s0.93,0.08,1.34,0.25c0.41,0.17,0.75,0.4,1.04,0.7s0.51,0.65,0.68,1.06
    		c0.16,0.41,0.24,0.85,0.24,1.34s-0.08,0.93-0.24,1.35c-0.16,0.41-0.39,0.76-0.68,1.06c-0.29,0.3-0.63,0.53-1.04,0.69
    		c-0.4,0.17-0.85,0.25-1.34,0.25s-0.93-0.08-1.34-0.25s-0.75-0.4-1.04-0.69c-0.29-0.3-0.51-0.65-0.67-1.06
    		C177.93,26.21,177.84,25.77,177.84,25.28z M178.44,25.28c0,0.4,0.06,0.77,0.19,1.11c0.13,0.34,0.31,0.64,0.54,0.89
    		c0.23,0.25,0.52,0.45,0.85,0.59c0.33,0.14,0.71,0.22,1.12,0.22s0.79-0.07,1.12-0.22c0.33-0.14,0.62-0.34,0.85-0.59
    		s0.41-0.55,0.54-0.89c0.13-0.34,0.19-0.71,0.19-1.11s-0.06-0.77-0.19-1.11s-0.31-0.64-0.54-0.89s-0.52-0.45-0.85-0.59
    		s-0.71-0.22-1.12-0.22s-0.79,0.07-1.12,0.22s-0.62,0.34-0.85,0.59c-0.23,0.25-0.41,0.55-0.54,0.89S178.44,24.88,178.44,25.28z"/>
    	<path class="st2" d="M186.66,22.09h0.77l3.88,5.58h0.02v-5.58h0.59v6.37h-0.77l-3.88-5.58h-0.02v5.58h-0.59V22.09z"/>
    	<path class="st2" d="M196.52,22.09h0.61l2.68,6.37h-0.67l-0.69-1.69h-3.38l-0.72,1.69h-0.62L196.52,22.09z M196.8,22.74l-1.48,3.49
    		h2.92L196.8,22.74z"/>
    	<path class="st2" d="M201.63,22.09h0.59v5.83h2.97v0.54h-3.56V22.09z"/>
    	<path class="st2" d="M210.21,22.09h0.89l2.32,5.35l2.32-5.35h0.85v6.37H216v-5.62h-0.02l-2.43,5.62h-0.26l-2.47-5.62h-0.02v5.62
    		h-0.59V22.09z"/>
    	<path class="st2" d="M221.13,22.09h0.61l2.68,6.37h-0.67l-0.69-1.69h-3.38l-0.72,1.69h-0.62L221.13,22.09z M221.4,22.74l-1.48,3.49
    		h2.92L221.4,22.74z"/>
    	<path class="st2" d="M226.98,25.72l-2.34-3.63h0.71l1.93,3.02l1.97-3.02h0.67l-2.34,3.63v2.75h-0.59V25.72z"/>
    	<path class="st2" d="M231.22,25.28c0-0.49,0.08-0.93,0.24-1.34c0.16-0.41,0.39-0.76,0.67-1.06s0.63-0.53,1.04-0.7
    		c0.4-0.17,0.85-0.25,1.34-0.25s0.93,0.08,1.34,0.25c0.41,0.17,0.75,0.4,1.04,0.7s0.51,0.65,0.68,1.06
    		c0.16,0.41,0.24,0.85,0.24,1.34s-0.08,0.93-0.24,1.35c-0.16,0.41-0.39,0.76-0.68,1.06c-0.29,0.3-0.63,0.53-1.04,0.69
    		c-0.4,0.17-0.85,0.25-1.34,0.25s-0.93-0.08-1.34-0.25s-0.75-0.4-1.04-0.69c-0.29-0.3-0.51-0.65-0.67-1.06
    		C231.3,26.21,231.22,25.77,231.22,25.28z M231.82,25.28c0,0.4,0.06,0.77,0.19,1.11c0.13,0.34,0.31,0.64,0.54,0.89
    		c0.23,0.25,0.52,0.45,0.85,0.59c0.33,0.14,0.71,0.22,1.12,0.22s0.79-0.07,1.12-0.22c0.33-0.14,0.62-0.34,0.85-0.59
    		s0.41-0.55,0.54-0.89c0.13-0.34,0.19-0.71,0.19-1.11s-0.06-0.77-0.19-1.11s-0.31-0.64-0.54-0.89s-0.52-0.45-0.85-0.59
    		s-0.71-0.22-1.12-0.22s-0.79,0.07-1.12,0.22s-0.62,0.34-0.85,0.59c-0.23,0.25-0.41,0.55-0.54,0.89S231.82,24.88,231.82,25.28z"/>
    	<path class="st2" d="M240.04,22.09h1.67c0.08,0,0.2,0,0.34,0.01c0.14,0.01,0.3,0.02,0.47,0.05c0.17,0.03,0.34,0.08,0.51,0.14
    		c0.17,0.07,0.33,0.16,0.47,0.29s0.25,0.29,0.34,0.48c0.09,0.19,0.13,0.43,0.13,0.7c0,0.31-0.05,0.56-0.16,0.76
    		c-0.11,0.2-0.24,0.36-0.4,0.48c-0.16,0.12-0.33,0.21-0.53,0.27s-0.38,0.1-0.55,0.13l1.85,3.06h-0.67l-1.79-3.02h-1.11v3.02h-0.59
    		V22.09z M240.64,24.9h1.26c0.31,0,0.57-0.04,0.76-0.12c0.2-0.08,0.35-0.17,0.45-0.29c0.11-0.11,0.18-0.24,0.22-0.37
    		s0.06-0.25,0.06-0.36c0-0.11-0.02-0.23-0.06-0.36c-0.04-0.13-0.11-0.25-0.22-0.37c-0.11-0.11-0.26-0.21-0.45-0.29
    		c-0.19-0.08-0.45-0.12-0.76-0.12h-1.26V24.9z"/>
    	<path class="st2" d="M249.44,22.09h1.97c0.55,0,1.02,0.07,1.4,0.2c0.38,0.13,0.7,0.31,0.96,0.52s0.46,0.44,0.6,0.7
    		c0.15,0.26,0.25,0.5,0.32,0.73c0.07,0.23,0.11,0.45,0.13,0.63s0.03,0.32,0.03,0.4c0,0.08-0.01,0.21-0.03,0.4s-0.06,0.4-0.13,0.63
    		c-0.07,0.23-0.18,0.48-0.32,0.73s-0.35,0.49-0.6,0.7c-0.25,0.21-0.57,0.38-0.96,0.52c-0.38,0.14-0.85,0.2-1.4,0.2h-1.97V22.09z
    		 M250.03,27.93h1.22c0.42,0,0.81-0.05,1.18-0.16c0.37-0.1,0.68-0.27,0.95-0.48c0.27-0.22,0.48-0.49,0.64-0.82
    		c0.16-0.33,0.23-0.73,0.23-1.18s-0.08-0.85-0.23-1.18c-0.16-0.33-0.37-0.61-0.64-0.82c-0.27-0.22-0.59-0.38-0.95-0.48
    		c-0.37-0.1-0.76-0.16-1.18-0.16h-1.22V27.93z"/>
    	<path class="st2" d="M257.09,22.09h3.9v0.54h-3.3v2.27h3.1v0.54h-3.1v2.48h3.45v0.54h-4.04V22.09z"/>
    	<path class="st2" d="M266.74,27.29c0.16,0.27,0.36,0.47,0.61,0.6c0.25,0.13,0.53,0.2,0.85,0.2c0.2,0,0.38-0.03,0.56-0.09
    		c0.17-0.06,0.33-0.14,0.45-0.25c0.13-0.11,0.23-0.24,0.31-0.39c0.08-0.15,0.11-0.33,0.11-0.52c0-0.22-0.05-0.41-0.14-0.55
    		c-0.09-0.14-0.22-0.26-0.37-0.36c-0.16-0.09-0.33-0.17-0.53-0.24c-0.2-0.07-0.4-0.13-0.6-0.2c-0.21-0.07-0.41-0.14-0.6-0.22
    		s-0.37-0.19-0.53-0.33c-0.16-0.14-0.28-0.3-0.37-0.51c-0.09-0.2-0.14-0.46-0.14-0.76c0-0.28,0.06-0.53,0.17-0.75
    		c0.11-0.22,0.26-0.4,0.45-0.55s0.41-0.26,0.65-0.33s0.5-0.11,0.77-0.11c0.35,0,0.67,0.06,0.97,0.18c0.3,0.12,0.55,0.33,0.77,0.62
    		l-0.51,0.37c-0.15-0.21-0.33-0.37-0.53-0.47c-0.2-0.1-0.44-0.16-0.72-0.16c-0.19,0-0.38,0.03-0.55,0.08
    		c-0.17,0.05-0.33,0.13-0.45,0.23s-0.23,0.22-0.31,0.37s-0.12,0.33-0.12,0.53c0,0.32,0.08,0.56,0.24,0.73
    		c0.16,0.17,0.36,0.31,0.61,0.41c0.24,0.1,0.51,0.19,0.79,0.26c0.29,0.08,0.55,0.18,0.79,0.3c0.24,0.13,0.45,0.3,0.61,0.53
    		c0.16,0.23,0.24,0.54,0.24,0.93c0,0.29-0.05,0.54-0.16,0.77c-0.11,0.22-0.25,0.41-0.44,0.56c-0.18,0.15-0.4,0.27-0.63,0.35
    		c-0.24,0.08-0.49,0.12-0.75,0.12c-0.42,0-0.81-0.07-1.16-0.22c-0.35-0.15-0.66-0.39-0.91-0.74L266.74,27.29z"/>
    	<path class="st2" d="M274.42,22.09h0.61l2.68,6.37h-0.67l-0.69-1.69h-3.38l-0.72,1.69h-0.62L274.42,22.09z M274.7,22.74l-1.48,3.49
    		h2.92L274.7,22.74z"/>
    	<path class="st2" d="M279.54,22.09h0.77l3.88,5.58h0.02v-5.58h0.59v6.37h-0.77l-3.88-5.58h-0.02v5.58h-0.59V22.09z"/>
    	<path class="st2" d="M290.61,22.09h0.89l2.32,5.35l2.32-5.35h0.85v6.37h-0.59v-5.62h-0.02l-2.43,5.62h-0.26l-2.47-5.62h-0.02v5.62
    		h-0.59V22.09z"/>
    	<path class="st2" d="M301.53,22.09h0.61l2.68,6.37h-0.67l-0.69-1.69h-3.38l-0.72,1.69h-0.62L301.53,22.09z M301.81,22.74
    		l-1.48,3.49h2.92L301.81,22.74z"/>
    	<path class="st2" d="M306.64,22.09h1.67c0.08,0,0.2,0,0.34,0.01c0.14,0.01,0.3,0.02,0.47,0.05c0.17,0.03,0.34,0.08,0.51,0.14
    		s0.33,0.16,0.47,0.29c0.14,0.13,0.25,0.29,0.34,0.48s0.14,0.43,0.14,0.7c0,0.31-0.05,0.56-0.16,0.76c-0.11,0.2-0.24,0.36-0.4,0.48
    		s-0.33,0.21-0.53,0.27c-0.19,0.06-0.38,0.1-0.55,0.13l1.86,3.06h-0.68l-1.79-3.02h-1.11v3.02h-0.59V22.09z M307.24,24.9h1.26
    		c0.31,0,0.57-0.04,0.76-0.12c0.2-0.08,0.35-0.17,0.46-0.29c0.11-0.11,0.18-0.24,0.22-0.37s0.06-0.25,0.06-0.36
    		c0-0.11-0.02-0.23-0.06-0.36c-0.04-0.13-0.11-0.25-0.22-0.37c-0.11-0.11-0.26-0.21-0.46-0.29s-0.45-0.12-0.76-0.12h-1.26V24.9z"/>
    	<path class="st2" d="M318.13,27.47c-0.31,0.41-0.66,0.71-1.06,0.89c-0.4,0.18-0.84,0.27-1.3,0.27c-0.49,0-0.93-0.08-1.34-0.25
    		c-0.4-0.17-0.75-0.4-1.04-0.69c-0.29-0.3-0.51-0.65-0.67-1.06c-0.16-0.41-0.24-0.86-0.24-1.35s0.08-0.93,0.24-1.34
    		c0.16-0.41,0.39-0.76,0.67-1.06s0.63-0.53,1.04-0.7c0.41-0.17,0.85-0.25,1.34-0.25c0.43,0,0.84,0.08,1.21,0.23
    		c0.38,0.15,0.7,0.41,0.99,0.77l-0.49,0.41c-0.2-0.3-0.45-0.52-0.76-0.66c-0.31-0.14-0.62-0.21-0.95-0.21
    		c-0.41,0-0.79,0.07-1.12,0.22s-0.62,0.34-0.85,0.59c-0.23,0.25-0.41,0.55-0.54,0.89s-0.19,0.71-0.19,1.11s0.06,0.77,0.19,1.11
    		c0.13,0.34,0.31,0.64,0.54,0.89c0.23,0.25,0.52,0.45,0.85,0.59c0.33,0.14,0.71,0.22,1.12,0.22c0.16,0,0.33-0.02,0.5-0.06
    		s0.34-0.1,0.51-0.18c0.17-0.08,0.32-0.18,0.47-0.31c0.15-0.12,0.28-0.27,0.4-0.45L318.13,27.47z"/>
    	<path class="st2" d="M319.7,25.28c0-0.49,0.08-0.93,0.24-1.34c0.16-0.41,0.39-0.76,0.67-1.06s0.63-0.53,1.04-0.7
    		c0.41-0.17,0.85-0.25,1.34-0.25s0.93,0.08,1.34,0.25c0.4,0.17,0.75,0.4,1.04,0.7s0.51,0.65,0.67,1.06
    		c0.16,0.41,0.24,0.85,0.24,1.34s-0.08,0.93-0.24,1.35c-0.16,0.41-0.39,0.76-0.67,1.06c-0.29,0.3-0.63,0.53-1.04,0.69
    		c-0.41,0.17-0.85,0.25-1.34,0.25s-0.93-0.08-1.34-0.25c-0.4-0.17-0.75-0.4-1.04-0.69c-0.29-0.3-0.51-0.65-0.67-1.06
    		C319.78,26.21,319.7,25.77,319.7,25.28z M320.29,25.28c0,0.4,0.06,0.77,0.19,1.11c0.13,0.34,0.31,0.64,0.54,0.89
    		c0.23,0.25,0.52,0.45,0.85,0.59c0.33,0.14,0.71,0.22,1.12,0.22s0.79-0.07,1.12-0.22c0.33-0.14,0.62-0.34,0.85-0.59
    		c0.23-0.25,0.41-0.55,0.54-0.89c0.13-0.34,0.19-0.71,0.19-1.11s-0.06-0.77-0.19-1.11s-0.31-0.64-0.54-0.89
    		c-0.23-0.25-0.52-0.45-0.85-0.59s-0.71-0.22-1.12-0.22s-0.79,0.07-1.12,0.22s-0.62,0.34-0.85,0.59c-0.23,0.25-0.41,0.55-0.54,0.89
    		S320.29,24.88,320.29,25.28z"/>
    	<path class="st2" d="M328.69,27.29c0.16,0.27,0.36,0.47,0.61,0.6c0.25,0.13,0.53,0.2,0.85,0.2c0.2,0,0.38-0.03,0.56-0.09
    		c0.17-0.06,0.33-0.14,0.46-0.25c0.13-0.11,0.23-0.24,0.31-0.39c0.08-0.15,0.11-0.33,0.11-0.52c0-0.22-0.05-0.41-0.14-0.55
    		c-0.09-0.14-0.22-0.26-0.37-0.36c-0.16-0.09-0.33-0.17-0.53-0.24s-0.4-0.13-0.6-0.2c-0.21-0.07-0.41-0.14-0.6-0.22
    		s-0.37-0.19-0.53-0.33c-0.16-0.14-0.28-0.3-0.37-0.51c-0.09-0.2-0.14-0.46-0.14-0.76c0-0.28,0.05-0.53,0.17-0.75
    		c0.11-0.22,0.26-0.4,0.45-0.55c0.19-0.15,0.41-0.26,0.65-0.33s0.5-0.11,0.77-0.11c0.35,0,0.67,0.06,0.97,0.18
    		c0.3,0.12,0.55,0.33,0.77,0.62l-0.51,0.37c-0.15-0.21-0.33-0.37-0.53-0.47s-0.44-0.16-0.72-0.16c-0.19,0-0.38,0.03-0.55,0.08
    		c-0.17,0.05-0.33,0.13-0.45,0.23c-0.13,0.1-0.23,0.22-0.31,0.37c-0.08,0.15-0.12,0.33-0.12,0.53c0,0.32,0.08,0.56,0.24,0.73
    		c0.16,0.17,0.36,0.31,0.61,0.41s0.51,0.19,0.79,0.26c0.28,0.08,0.55,0.18,0.79,0.3s0.45,0.3,0.61,0.53s0.24,0.54,0.24,0.93
    		c0,0.29-0.05,0.54-0.16,0.77c-0.11,0.22-0.25,0.41-0.44,0.56c-0.18,0.15-0.39,0.27-0.63,0.35c-0.24,0.08-0.49,0.12-0.75,0.12
    		c-0.42,0-0.81-0.07-1.16-0.22c-0.35-0.15-0.66-0.39-0.91-0.74L328.69,27.29z"/>
    	<path class="st2" d="M105.67,32.89h3.9v0.54h-3.3v2.27h3.1v0.54h-3.1v2.48h3.45v0.54h-4.04V32.89z"/>
    	<path class="st2" d="M112.08,38.09c0.16,0.27,0.36,0.47,0.61,0.6s0.53,0.2,0.85,0.2c0.2,0,0.38-0.03,0.56-0.09
    		c0.17-0.06,0.33-0.14,0.45-0.25c0.13-0.11,0.23-0.24,0.31-0.39c0.08-0.15,0.11-0.33,0.11-0.52c0-0.22-0.05-0.41-0.14-0.55
    		c-0.09-0.14-0.22-0.26-0.37-0.36s-0.33-0.17-0.53-0.24c-0.2-0.07-0.4-0.13-0.6-0.2c-0.21-0.07-0.41-0.14-0.6-0.23
    		s-0.37-0.19-0.53-0.33c-0.16-0.13-0.28-0.3-0.37-0.51c-0.09-0.2-0.14-0.46-0.14-0.76c0-0.28,0.06-0.53,0.17-0.75
    		c0.11-0.22,0.26-0.4,0.45-0.55c0.19-0.15,0.41-0.26,0.65-0.33c0.25-0.08,0.5-0.11,0.77-0.11c0.35,0,0.67,0.06,0.97,0.18
    		c0.3,0.12,0.55,0.33,0.77,0.62l-0.51,0.37c-0.15-0.21-0.33-0.37-0.53-0.47c-0.2-0.1-0.44-0.16-0.72-0.16
    		c-0.19,0-0.38,0.03-0.55,0.08c-0.17,0.05-0.33,0.13-0.45,0.23s-0.23,0.22-0.31,0.37c-0.08,0.15-0.12,0.33-0.12,0.53
    		c0,0.32,0.08,0.56,0.24,0.73c0.16,0.17,0.36,0.31,0.61,0.41c0.24,0.1,0.51,0.19,0.79,0.26c0.29,0.08,0.55,0.18,0.79,0.3
    		c0.24,0.13,0.45,0.3,0.61,0.53c0.16,0.22,0.24,0.54,0.24,0.93c0,0.29-0.05,0.54-0.16,0.76c-0.11,0.22-0.25,0.41-0.44,0.56
    		c-0.18,0.15-0.4,0.27-0.63,0.35c-0.24,0.08-0.49,0.12-0.75,0.12c-0.42,0-0.81-0.07-1.16-0.22c-0.35-0.15-0.66-0.39-0.91-0.74
    		L112.08,38.09z"/>
    	<path class="st2" d="M123.06,38.27c-0.31,0.41-0.66,0.71-1.06,0.89c-0.4,0.18-0.84,0.27-1.31,0.27c-0.49,0-0.93-0.08-1.34-0.25
    		c-0.4-0.16-0.75-0.4-1.04-0.69s-0.51-0.65-0.67-1.06c-0.16-0.41-0.24-0.86-0.24-1.34c0-0.49,0.08-0.93,0.24-1.34
    		c0.16-0.41,0.39-0.76,0.67-1.06c0.29-0.3,0.63-0.53,1.04-0.7s0.85-0.25,1.34-0.25c0.43,0,0.84,0.08,1.21,0.23s0.7,0.41,0.99,0.77
    		l-0.49,0.41c-0.2-0.3-0.45-0.52-0.76-0.66c-0.31-0.14-0.63-0.21-0.95-0.21c-0.41,0-0.79,0.07-1.12,0.22
    		c-0.33,0.14-0.62,0.34-0.85,0.59c-0.23,0.25-0.41,0.55-0.54,0.89s-0.19,0.71-0.19,1.11c0,0.4,0.06,0.76,0.19,1.11
    		s0.31,0.64,0.54,0.89c0.23,0.25,0.52,0.45,0.85,0.59c0.33,0.14,0.71,0.22,1.12,0.22c0.16,0,0.33-0.02,0.5-0.06
    		c0.17-0.04,0.34-0.1,0.51-0.18s0.32-0.18,0.47-0.31c0.15-0.12,0.28-0.27,0.4-0.45L123.06,38.27z"/>
    	<path class="st2" d="M129.57,36.83c0,0.34-0.04,0.67-0.12,0.98c-0.08,0.31-0.21,0.59-0.39,0.83c-0.18,0.24-0.42,0.43-0.72,0.58
    		c-0.3,0.14-0.66,0.22-1.09,0.22c-0.43,0-0.8-0.07-1.09-0.22c-0.3-0.14-0.54-0.34-0.72-0.58c-0.18-0.24-0.31-0.52-0.39-0.83
    		c-0.08-0.31-0.12-0.64-0.12-0.98v-3.93h0.59v3.78c0,0.23,0.02,0.47,0.06,0.73c0.04,0.26,0.12,0.5,0.25,0.72
    		c0.12,0.22,0.3,0.4,0.52,0.55c0.23,0.14,0.52,0.22,0.9,0.22s0.67-0.07,0.9-0.22c0.23-0.14,0.4-0.33,0.52-0.55
    		c0.12-0.22,0.21-0.46,0.25-0.72c0.04-0.26,0.06-0.5,0.06-0.73v-3.78h0.59V36.83z"/>
    	<path class="st2" d="M132.1,32.89h3.9v0.54h-3.3v2.27h3.1v0.54h-3.1v2.48h3.45v0.54h-4.04V32.89z"/>
    	<path class="st2" d="M138.34,32.89h0.59v5.83h2.97v0.54h-3.56V32.89z"/>
    	<path class="st2" d="M145.69,32.89h0.61l2.68,6.37h-0.67l-0.69-1.69h-3.38l-0.72,1.69h-0.62L145.69,32.89z M145.97,33.54
    		l-1.48,3.49h2.92L145.97,33.54z"/>
    	<path class="st2" d="M154.04,32.89h1.84c0.22,0,0.45,0.03,0.7,0.08c0.24,0.05,0.46,0.14,0.67,0.27c0.2,0.13,0.37,0.3,0.5,0.52
    		c0.13,0.22,0.19,0.49,0.19,0.82c0,0.29-0.05,0.54-0.16,0.75c-0.1,0.21-0.25,0.38-0.42,0.52c-0.18,0.14-0.38,0.24-0.61,0.3
    		c-0.23,0.07-0.47,0.1-0.72,0.1h-1.38v3.02h-0.59V32.89z M154.64,35.7h1.35c0.17,0,0.33-0.02,0.5-0.06s0.31-0.1,0.43-0.19
    		s0.23-0.2,0.31-0.35c0.08-0.14,0.12-0.32,0.12-0.53c0-0.2-0.04-0.38-0.12-0.52c-0.08-0.14-0.19-0.26-0.31-0.36s-0.28-0.16-0.45-0.2
    		s-0.34-0.06-0.5-0.06h-1.31V35.7z"/>
    	<path class="st2" d="M160.11,32.89h1.67c0.08,0,0.2,0,0.34,0.01c0.14,0.01,0.3,0.02,0.47,0.05c0.17,0.03,0.34,0.08,0.51,0.14
    		c0.17,0.07,0.33,0.16,0.47,0.29s0.25,0.29,0.34,0.48c0.09,0.19,0.13,0.43,0.13,0.7c0,0.31-0.05,0.56-0.16,0.76
    		c-0.11,0.2-0.24,0.36-0.4,0.48c-0.16,0.12-0.33,0.21-0.53,0.28c-0.19,0.06-0.38,0.1-0.55,0.13l1.85,3.06h-0.67l-1.79-3.02h-1.11
    		v3.02h-0.59V32.89z M160.7,35.7h1.26c0.31,0,0.57-0.04,0.76-0.12c0.2-0.08,0.35-0.17,0.45-0.29s0.18-0.24,0.22-0.37
    		s0.06-0.25,0.06-0.36c0-0.11-0.02-0.23-0.06-0.36s-0.11-0.25-0.22-0.37s-0.26-0.21-0.45-0.29c-0.19-0.08-0.45-0.12-0.76-0.12h-1.26
    		V35.7z"/>
    	<path class="st2" d="M165.93,36.08c0-0.49,0.08-0.93,0.24-1.34c0.16-0.41,0.39-0.76,0.67-1.06c0.29-0.3,0.63-0.53,1.04-0.7
    		s0.85-0.25,1.34-0.25s0.93,0.08,1.34,0.25c0.41,0.17,0.75,0.4,1.04,0.7c0.29,0.3,0.51,0.65,0.68,1.06
    		c0.16,0.41,0.24,0.86,0.24,1.34c0,0.49-0.08,0.93-0.24,1.34c-0.16,0.41-0.39,0.77-0.68,1.06s-0.63,0.53-1.04,0.69
    		c-0.4,0.17-0.85,0.25-1.34,0.25s-0.93-0.08-1.34-0.25c-0.4-0.16-0.75-0.4-1.04-0.69s-0.51-0.65-0.67-1.06
    		C166.01,37.02,165.93,36.57,165.93,36.08z M166.53,36.08c0,0.4,0.06,0.76,0.19,1.11s0.31,0.64,0.54,0.89
    		c0.23,0.25,0.52,0.45,0.85,0.59c0.33,0.14,0.71,0.22,1.12,0.22s0.79-0.07,1.12-0.22c0.33-0.14,0.62-0.34,0.85-0.59
    		c0.23-0.25,0.41-0.55,0.54-0.89s0.19-0.71,0.19-1.11c0-0.4-0.06-0.77-0.19-1.11s-0.31-0.64-0.54-0.89s-0.52-0.45-0.85-0.59
    		c-0.33-0.14-0.71-0.22-1.12-0.22s-0.79,0.07-1.12,0.22c-0.33,0.14-0.62,0.34-0.85,0.59c-0.23,0.25-0.41,0.55-0.54,0.89
    		S166.53,35.68,166.53,36.08z"/>
    	<path class="st2" d="M174.75,32.89h3.82v0.54h-3.22v2.27h3v0.54h-3v3.02h-0.59V32.89z"/>
    	<path class="st2" d="M180.66,32.89h3.9v0.54h-3.3v2.27h3.1v0.54h-3.1v2.48h3.45v0.54h-4.04V32.89z"/>
    	<path class="st2" d="M187.06,38.09c0.16,0.27,0.36,0.47,0.61,0.6s0.53,0.2,0.85,0.2c0.2,0,0.38-0.03,0.56-0.09
    		c0.17-0.06,0.33-0.14,0.45-0.25c0.13-0.11,0.23-0.24,0.31-0.39c0.08-0.15,0.11-0.33,0.11-0.52c0-0.22-0.05-0.41-0.14-0.55
    		c-0.09-0.14-0.22-0.26-0.37-0.36s-0.33-0.17-0.53-0.24c-0.2-0.07-0.4-0.13-0.6-0.2c-0.21-0.07-0.41-0.14-0.6-0.23
    		s-0.37-0.19-0.53-0.33c-0.16-0.13-0.28-0.3-0.37-0.51c-0.09-0.2-0.14-0.46-0.14-0.76c0-0.28,0.06-0.53,0.17-0.75
    		c0.11-0.22,0.26-0.4,0.45-0.55c0.19-0.15,0.41-0.26,0.65-0.33c0.25-0.08,0.5-0.11,0.77-0.11c0.35,0,0.67,0.06,0.97,0.18
    		c0.3,0.12,0.55,0.33,0.77,0.62l-0.51,0.37c-0.15-0.21-0.33-0.37-0.53-0.47c-0.2-0.1-0.44-0.16-0.72-0.16
    		c-0.19,0-0.38,0.03-0.55,0.08c-0.17,0.05-0.33,0.13-0.45,0.23s-0.23,0.22-0.31,0.37c-0.08,0.15-0.12,0.33-0.12,0.53
    		c0,0.32,0.08,0.56,0.24,0.73c0.16,0.17,0.36,0.31,0.61,0.41c0.24,0.1,0.51,0.19,0.79,0.26c0.29,0.08,0.55,0.18,0.79,0.3
    		c0.24,0.13,0.45,0.3,0.61,0.53c0.16,0.22,0.24,0.54,0.24,0.93c0,0.29-0.05,0.54-0.16,0.76c-0.11,0.22-0.25,0.41-0.44,0.56
    		c-0.18,0.15-0.4,0.27-0.63,0.35c-0.24,0.08-0.49,0.12-0.75,0.12c-0.42,0-0.81-0.07-1.16-0.22c-0.35-0.15-0.66-0.39-0.91-0.74
    		L187.06,38.09z"/>
    	<path class="st2" d="M192.8,32.89h0.59v6.37h-0.59V32.89z"/>
    	<path class="st2" d="M195.62,36.08c0-0.49,0.08-0.93,0.24-1.34c0.16-0.41,0.39-0.76,0.67-1.06c0.29-0.3,0.63-0.53,1.04-0.7
    		s0.85-0.25,1.34-0.25s0.93,0.08,1.34,0.25c0.41,0.17,0.75,0.4,1.04,0.7c0.29,0.3,0.51,0.65,0.68,1.06
    		c0.16,0.41,0.24,0.86,0.24,1.34c0,0.49-0.08,0.93-0.24,1.34c-0.16,0.41-0.39,0.77-0.68,1.06s-0.63,0.53-1.04,0.69
    		c-0.4,0.17-0.85,0.25-1.34,0.25s-0.93-0.08-1.34-0.25c-0.4-0.16-0.75-0.4-1.04-0.69s-0.51-0.65-0.67-1.06
    		C195.7,37.02,195.62,36.57,195.62,36.08z M196.22,36.08c0,0.4,0.06,0.76,0.19,1.11s0.31,0.64,0.54,0.89
    		c0.23,0.25,0.52,0.45,0.85,0.59c0.33,0.14,0.71,0.22,1.12,0.22s0.79-0.07,1.12-0.22c0.33-0.14,0.62-0.34,0.85-0.59
    		c0.23-0.25,0.41-0.55,0.54-0.89s0.19-0.71,0.19-1.11c0-0.4-0.06-0.77-0.19-1.11s-0.31-0.64-0.54-0.89s-0.52-0.45-0.85-0.59
    		c-0.33-0.14-0.71-0.22-1.12-0.22s-0.79,0.07-1.12,0.22c-0.33,0.14-0.62,0.34-0.85,0.59c-0.23,0.25-0.41,0.55-0.54,0.89
    		S196.22,35.68,196.22,36.08z"/>
    	<path class="st2" d="M204.44,32.89h0.77l3.88,5.58h0.02v-5.58h0.59v6.37h-0.77l-3.88-5.58h-0.02v5.58h-0.59V32.89z"/>
    	<path class="st2" d="M214.3,32.89h0.61l2.68,6.37h-0.67l-0.69-1.69h-3.38l-0.72,1.69h-0.62L214.3,32.89z M214.58,33.54l-1.48,3.49
    		h2.92L214.58,33.54z"/>
    	<path class="st2" d="M219.41,32.89H220v5.83h2.97v0.54h-3.56V32.89z"/>
    	<path class="st2" d="M227.97,32.89h1.97c0.55,0,1.02,0.07,1.4,0.2c0.38,0.13,0.7,0.31,0.96,0.52s0.46,0.44,0.6,0.7
    		s0.25,0.5,0.32,0.73c0.07,0.23,0.11,0.45,0.13,0.63c0.02,0.19,0.03,0.32,0.03,0.4c0,0.08-0.01,0.21-0.03,0.4
    		c-0.02,0.19-0.06,0.4-0.13,0.63c-0.07,0.23-0.18,0.48-0.32,0.73c-0.15,0.26-0.35,0.49-0.6,0.7s-0.57,0.38-0.96,0.52
    		c-0.38,0.13-0.85,0.2-1.4,0.2h-1.97V32.89z M228.56,38.73h1.22c0.42,0,0.81-0.05,1.18-0.16c0.37-0.11,0.68-0.27,0.95-0.48
    		s0.48-0.49,0.64-0.82c0.16-0.33,0.23-0.73,0.23-1.18s-0.08-0.85-0.23-1.18c-0.16-0.33-0.37-0.61-0.64-0.82
    		c-0.27-0.22-0.59-0.38-0.95-0.48c-0.37-0.1-0.76-0.16-1.18-0.16h-1.22V38.73z"/>
    	<path class="st2" d="M235.62,32.89h3.9v0.54h-3.3v2.27h3.1v0.54h-3.1v2.48h3.45v0.54h-4.04V32.89z"/>
    	<path class="st2" d="M245.1,32.89h3.9v0.54h-3.3v2.27h3.1v0.54h-3.1v2.48h3.45v0.54h-4.04V32.89z"/>
    	<path class="st2" d="M251.5,38.09c0.16,0.27,0.36,0.47,0.61,0.6s0.53,0.2,0.85,0.2c0.2,0,0.38-0.03,0.56-0.09
    		c0.17-0.06,0.33-0.14,0.45-0.25c0.13-0.11,0.23-0.24,0.31-0.39c0.08-0.15,0.11-0.33,0.11-0.52c0-0.22-0.05-0.41-0.14-0.55
    		c-0.09-0.14-0.22-0.26-0.37-0.36s-0.33-0.17-0.53-0.24c-0.2-0.07-0.4-0.13-0.6-0.2c-0.21-0.07-0.41-0.14-0.6-0.23
    		s-0.37-0.19-0.53-0.33c-0.16-0.13-0.28-0.3-0.37-0.51c-0.09-0.2-0.14-0.46-0.14-0.76c0-0.28,0.06-0.53,0.17-0.75
    		c0.11-0.22,0.26-0.4,0.45-0.55c0.19-0.15,0.41-0.26,0.65-0.33c0.25-0.08,0.5-0.11,0.77-0.11c0.35,0,0.67,0.06,0.97,0.18
    		c0.3,0.12,0.55,0.33,0.77,0.62l-0.51,0.37c-0.15-0.21-0.33-0.37-0.53-0.47c-0.2-0.1-0.44-0.16-0.72-0.16
    		c-0.19,0-0.38,0.03-0.55,0.08c-0.17,0.05-0.33,0.13-0.45,0.23s-0.23,0.22-0.31,0.37c-0.08,0.15-0.12,0.33-0.12,0.53
    		c0,0.32,0.08,0.56,0.24,0.73c0.16,0.17,0.36,0.31,0.61,0.41c0.24,0.1,0.51,0.19,0.79,0.26c0.29,0.08,0.55,0.18,0.79,0.3
    		c0.24,0.13,0.45,0.3,0.61,0.53c0.16,0.22,0.24,0.54,0.24,0.93c0,0.29-0.05,0.54-0.16,0.76c-0.11,0.22-0.25,0.41-0.44,0.56
    		c-0.18,0.15-0.4,0.27-0.63,0.35c-0.24,0.08-0.49,0.12-0.75,0.12c-0.42,0-0.81-0.07-1.16-0.22c-0.35-0.15-0.66-0.39-0.91-0.74
    		L251.5,38.09z"/>
    	<path class="st2" d="M258.65,33.43h-2.18v-0.54h4.95v0.54h-2.18v5.83h-0.59V33.43z"/>
    	<path class="st2" d="M264.64,32.89h0.61l2.68,6.37h-0.67l-0.69-1.69h-3.38l-0.72,1.69h-0.62L264.64,32.89z M264.92,33.54
    		l-1.48,3.49h2.92L264.92,33.54z"/>
    	<path class="st2" d="M269.68,32.89h1.97c0.55,0,1.02,0.07,1.4,0.2c0.38,0.13,0.7,0.31,0.96,0.52s0.46,0.44,0.6,0.7
    		s0.25,0.5,0.32,0.73c0.07,0.23,0.11,0.45,0.13,0.63c0.02,0.19,0.03,0.32,0.03,0.4c0,0.08-0.01,0.21-0.03,0.4
    		c-0.02,0.19-0.06,0.4-0.13,0.63c-0.07,0.23-0.18,0.48-0.32,0.73c-0.15,0.26-0.35,0.49-0.6,0.7s-0.57,0.38-0.96,0.52
    		c-0.38,0.13-0.85,0.2-1.4,0.2h-1.97V32.89z M270.27,38.73h1.22c0.42,0,0.81-0.05,1.18-0.16c0.37-0.11,0.68-0.27,0.95-0.48
    		s0.48-0.49,0.64-0.82c0.16-0.33,0.23-0.73,0.23-1.18s-0.08-0.85-0.23-1.18c-0.16-0.33-0.37-0.61-0.64-0.82
    		c-0.27-0.22-0.59-0.38-0.95-0.48c-0.37-0.1-0.76-0.16-1.18-0.16h-1.22V38.73z"/>
    	<path class="st2" d="M278.04,31.2h0.72l-1.21,1.3h-0.45L278.04,31.2z M277.33,32.89h0.59v6.37h-0.59V32.89z"/>
    	<path class="st2" d="M280.74,38.09c0.16,0.27,0.36,0.47,0.61,0.6s0.53,0.2,0.85,0.2c0.2,0,0.38-0.03,0.56-0.09
    		c0.17-0.06,0.33-0.14,0.45-0.25c0.13-0.11,0.23-0.24,0.31-0.39c0.08-0.15,0.11-0.33,0.11-0.52c0-0.22-0.05-0.41-0.14-0.55
    		c-0.09-0.14-0.22-0.26-0.37-0.36s-0.33-0.17-0.53-0.24c-0.2-0.07-0.4-0.13-0.6-0.2c-0.21-0.07-0.41-0.14-0.6-0.23
    		s-0.37-0.19-0.53-0.33c-0.16-0.13-0.28-0.3-0.37-0.51c-0.09-0.2-0.14-0.46-0.14-0.76c0-0.28,0.06-0.53,0.17-0.75
    		c0.11-0.22,0.26-0.4,0.45-0.55c0.19-0.15,0.41-0.26,0.65-0.33c0.25-0.08,0.5-0.11,0.77-0.11c0.35,0,0.67,0.06,0.97,0.18
    		c0.3,0.12,0.55,0.33,0.77,0.62l-0.51,0.37c-0.15-0.21-0.33-0.37-0.53-0.47c-0.2-0.1-0.44-0.16-0.72-0.16
    		c-0.19,0-0.38,0.03-0.55,0.08c-0.17,0.05-0.33,0.13-0.45,0.23s-0.23,0.22-0.31,0.37c-0.08,0.15-0.12,0.33-0.12,0.53
    		c0,0.32,0.08,0.56,0.24,0.73c0.16,0.17,0.36,0.31,0.61,0.41c0.24,0.1,0.51,0.19,0.79,0.26c0.29,0.08,0.55,0.18,0.79,0.3
    		c0.24,0.13,0.45,0.3,0.61,0.53c0.16,0.22,0.24,0.54,0.24,0.93c0,0.29-0.05,0.54-0.16,0.76c-0.11,0.22-0.25,0.41-0.44,0.56
    		c-0.18,0.15-0.4,0.27-0.63,0.35c-0.24,0.08-0.49,0.12-0.75,0.12c-0.42,0-0.81-0.07-1.16-0.22c-0.35-0.15-0.66-0.39-0.91-0.74
    		L280.74,38.09z"/>
    	<path class="st2" d="M287.88,33.43h-2.18v-0.54h4.95v0.54h-2.18v5.83h-0.59V33.43z"/>
    	<path class="st2" d="M292.54,32.89h0.59v6.37h-0.59V32.89z"/>
    	<path class="st2" d="M301.02,38.27c-0.31,0.41-0.66,0.71-1.06,0.89c-0.4,0.18-0.84,0.27-1.31,0.27c-0.49,0-0.93-0.08-1.34-0.25
    		c-0.4-0.16-0.75-0.4-1.04-0.69s-0.51-0.65-0.67-1.06c-0.16-0.41-0.24-0.86-0.24-1.34c0-0.49,0.08-0.93,0.24-1.34
    		c0.16-0.41,0.39-0.76,0.67-1.06c0.29-0.3,0.63-0.53,1.04-0.7s0.85-0.25,1.34-0.25c0.43,0,0.84,0.08,1.21,0.23s0.7,0.41,0.99,0.77
    		l-0.49,0.41c-0.2-0.3-0.45-0.52-0.76-0.66c-0.31-0.14-0.63-0.21-0.95-0.21c-0.41,0-0.79,0.07-1.12,0.22
    		c-0.33,0.14-0.62,0.34-0.85,0.59c-0.23,0.25-0.41,0.55-0.54,0.89s-0.19,0.71-0.19,1.11c0,0.4,0.06,0.76,0.19,1.11
    		s0.31,0.64,0.54,0.89c0.23,0.25,0.52,0.45,0.85,0.59c0.33,0.14,0.71,0.22,1.12,0.22c0.16,0,0.33-0.02,0.5-0.06
    		c0.17-0.04,0.34-0.1,0.51-0.18s0.32-0.18,0.47-0.31c0.15-0.12,0.28-0.27,0.4-0.45L301.02,38.27z"/>
    	<path class="st2" d="M304.96,32.89h0.61l2.68,6.37h-0.67l-0.69-1.69h-3.37l-0.72,1.69h-0.62L304.96,32.89z M305.24,33.54
    		l-1.48,3.49h2.92L305.24,33.54z"/>
    </g>
    <g>
    	<path class="st2" d="M107.64,94.1h2.24c0.27,0,0.56,0.03,0.85,0.09c0.3,0.06,0.57,0.17,0.81,0.32c0.25,0.15,0.45,0.37,0.6,0.63
    		s0.24,0.6,0.24,1.01c0,0.35-0.06,0.66-0.19,0.91s-0.3,0.47-0.52,0.63s-0.47,0.29-0.75,0.37s-0.58,0.12-0.89,0.12h-1.68v3.7h-0.73
    		V94.1z M108.37,97.54h1.65c0.21,0,0.41-0.02,0.6-0.07c0.2-0.05,0.37-0.12,0.53-0.23c0.15-0.11,0.28-0.25,0.37-0.42
    		c0.1-0.18,0.14-0.39,0.14-0.65c0-0.25-0.05-0.46-0.15-0.64c-0.1-0.18-0.23-0.32-0.38-0.43c-0.16-0.11-0.34-0.2-0.54-0.25
    		c-0.21-0.05-0.41-0.08-0.62-0.08h-1.61V97.54z"/>
    	<path class="st2" d="M113.96,94.1H116c0.1,0,0.24,0,0.42,0.01c0.18,0.01,0.37,0.03,0.57,0.07c0.21,0.04,0.41,0.1,0.63,0.18
    		c0.21,0.08,0.4,0.2,0.57,0.35c0.17,0.15,0.31,0.35,0.42,0.58c0.11,0.23,0.16,0.52,0.16,0.86c0,0.37-0.06,0.68-0.19,0.92
    		c-0.13,0.24-0.29,0.44-0.48,0.59s-0.41,0.26-0.64,0.34s-0.46,0.12-0.67,0.15l2.27,3.74h-0.83l-2.19-3.7h-1.35v3.7h-0.73V94.1z
    		 M114.68,97.54h1.54c0.38,0,0.69-0.05,0.93-0.14c0.24-0.1,0.42-0.21,0.56-0.35c0.13-0.14,0.22-0.29,0.27-0.45
    		c0.05-0.16,0.07-0.31,0.07-0.44c0-0.13-0.02-0.28-0.07-0.44c-0.05-0.16-0.14-0.31-0.27-0.45c-0.13-0.14-0.32-0.26-0.56-0.35
    		c-0.24-0.1-0.55-0.14-0.93-0.14h-1.54V97.54z"/>
    	<path class="st2" d="M120.48,94.1h0.73v7.79h-0.73V94.1z"/>
    	<path class="st2" d="M123.26,94.1h1.09l2.84,6.53l2.84-6.53h1.03v7.79h-0.73v-6.86h-0.02l-2.97,6.86h-0.32l-3.01-6.86h-0.02v6.86
    		h-0.73V94.1z"/>
    	<path class="st2" d="M133.12,94.1h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V94.1z"/>
    	<path class="st2" d="M139.64,94.1h2.05c0.1,0,0.24,0,0.42,0.01c0.18,0.01,0.37,0.03,0.57,0.07c0.21,0.04,0.41,0.1,0.63,0.18
    		c0.21,0.08,0.4,0.2,0.57,0.35c0.17,0.15,0.31,0.35,0.42,0.58c0.11,0.23,0.16,0.52,0.16,0.86c0,0.37-0.06,0.68-0.19,0.92
    		c-0.13,0.24-0.29,0.44-0.48,0.59s-0.41,0.26-0.64,0.34s-0.46,0.12-0.67,0.15l2.27,3.74h-0.83l-2.19-3.7h-1.35v3.7h-0.73V94.1z
    		 M140.37,97.54h1.54c0.38,0,0.69-0.05,0.93-0.14c0.24-0.1,0.42-0.21,0.56-0.35c0.13-0.14,0.22-0.29,0.27-0.45
    		c0.05-0.16,0.07-0.31,0.07-0.44c0-0.13-0.02-0.28-0.07-0.44c-0.05-0.16-0.14-0.31-0.27-0.45c-0.13-0.14-0.32-0.26-0.56-0.35
    		c-0.24-0.1-0.55-0.14-0.93-0.14h-1.54V97.54z"/>
    	<path class="st2" d="M149.02,94.1h2.24c0.27,0,0.56,0.03,0.85,0.09c0.3,0.06,0.57,0.17,0.81,0.32c0.25,0.15,0.45,0.37,0.6,0.63
    		s0.24,0.6,0.24,1.01c0,0.35-0.06,0.66-0.19,0.91s-0.3,0.47-0.52,0.63s-0.47,0.29-0.75,0.37s-0.58,0.12-0.89,0.12h-1.68v3.7h-0.73
    		V94.1z M149.75,97.54h1.65c0.21,0,0.41-0.02,0.6-0.07c0.2-0.05,0.37-0.12,0.53-0.23c0.15-0.11,0.28-0.25,0.37-0.42
    		c0.1-0.18,0.14-0.39,0.14-0.65c0-0.25-0.05-0.46-0.15-0.64c-0.1-0.18-0.23-0.32-0.38-0.43c-0.16-0.11-0.34-0.2-0.54-0.25
    		c-0.21-0.05-0.41-0.08-0.62-0.08h-1.61V97.54z"/>
    	<path class="st2" d="M155.34,94.1h2.05c0.1,0,0.24,0,0.42,0.01c0.18,0.01,0.37,0.03,0.57,0.07c0.21,0.04,0.41,0.1,0.63,0.18
    		c0.21,0.08,0.4,0.2,0.57,0.35c0.17,0.15,0.31,0.35,0.42,0.58c0.11,0.23,0.16,0.52,0.16,0.86c0,0.37-0.06,0.68-0.19,0.92
    		c-0.13,0.24-0.29,0.44-0.48,0.59s-0.41,0.26-0.64,0.34s-0.46,0.12-0.67,0.15l2.27,3.74h-0.83l-2.19-3.7h-1.35v3.7h-0.73V94.1z
    		 M156.06,97.54h1.54c0.38,0,0.69-0.05,0.93-0.14c0.24-0.1,0.42-0.21,0.56-0.35c0.13-0.14,0.22-0.29,0.27-0.45
    		c0.05-0.16,0.07-0.31,0.07-0.44c0-0.13-0.02-0.28-0.07-0.44c-0.05-0.16-0.14-0.31-0.27-0.45c-0.13-0.14-0.32-0.26-0.56-0.35
    		c-0.24-0.1-0.55-0.14-0.93-0.14h-1.54V97.54z"/>
    	<path class="st2" d="M161.86,94.1h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V94.1z"/>
    	<path class="st2" d="M168.31,94.1h1.09l2.84,6.53l2.84-6.53h1.03v7.79h-0.73v-6.86h-0.02l-2.97,6.86h-0.32l-3.01-6.86h-0.02v6.86
    		h-0.73V94.1z"/>
    	<path class="st2" d="M178.16,94.1h0.73v7.79h-0.73V94.1z"/>
    	<path class="st2" d="M180.52,98c0-0.59,0.1-1.14,0.3-1.64c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85
    		c0.5-0.21,1.04-0.31,1.63-0.31c0.59,0,1.14,0.1,1.63,0.31c0.49,0.21,0.92,0.49,1.27,0.85c0.35,0.36,0.63,0.79,0.82,1.29
    		c0.2,0.5,0.3,1.05,0.3,1.64c0,0.59-0.1,1.14-0.3,1.64c-0.2,0.5-0.47,0.94-0.82,1.3c-0.35,0.36-0.78,0.65-1.27,0.85
    		c-0.5,0.2-1.04,0.3-1.63,0.3c-0.59,0-1.14-0.1-1.63-0.3c-0.5-0.2-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.79-0.83-1.3
    		C180.62,99.14,180.52,98.59,180.52,98z M181.24,98c0,0.48,0.08,0.94,0.23,1.35c0.15,0.42,0.37,0.78,0.66,1.09
    		c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26s0.96-0.09,1.37-0.26c0.41-0.18,0.75-0.42,1.04-0.73
    		s0.51-0.67,0.66-1.09c0.15-0.42,0.23-0.87,0.23-1.35s-0.08-0.94-0.23-1.35c-0.15-0.42-0.37-0.78-0.66-1.09s-0.63-0.55-1.04-0.73
    		c-0.41-0.18-0.86-0.26-1.37-0.26s-0.96,0.09-1.37,0.26c-0.41,0.18-0.75,0.42-1.04,0.73c-0.29,0.31-0.51,0.67-0.66,1.09
    		C181.32,97.06,181.24,97.51,181.24,98z"/>
    	<path class="st2" d="M190.03,97.27c0-0.15,0.05-0.27,0.15-0.37c0.1-0.1,0.23-0.15,0.37-0.15c0.15,0,0.27,0.05,0.37,0.15
    		c0.1,0.1,0.15,0.23,0.15,0.37c0,0.15-0.05,0.27-0.15,0.37c-0.1,0.1-0.23,0.15-0.37,0.15c-0.15,0-0.27-0.05-0.37-0.15
    		C190.08,97.54,190.03,97.42,190.03,97.27z M190.03,101.43c0-0.15,0.05-0.27,0.15-0.37c0.1-0.1,0.23-0.15,0.37-0.15
    		c0.15,0,0.27,0.05,0.37,0.15c0.1,0.1,0.15,0.23,0.15,0.37s-0.05,0.27-0.15,0.37c-0.1,0.1-0.23,0.15-0.37,0.15
    		c-0.15,0-0.27-0.05-0.37-0.15C190.08,101.7,190.03,101.58,190.03,101.43z"/>
    	<path class="st2" d="M202.33,100.67c-0.37,0.51-0.81,0.87-1.3,1.09c-0.49,0.22-1.02,0.33-1.6,0.33c-0.59,0-1.14-0.1-1.63-0.3
    		c-0.5-0.2-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.79-0.83-1.3c-0.2-0.5-0.3-1.05-0.3-1.64c0-0.59,0.1-1.14,0.3-1.64
    		c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85c0.5-0.21,1.04-0.31,1.63-0.31c0.53,0,1.02,0.09,1.48,0.28
    		s0.86,0.5,1.2,0.94l-0.59,0.5c-0.24-0.37-0.55-0.63-0.93-0.8c-0.38-0.17-0.76-0.25-1.16-0.25c-0.51,0-0.96,0.09-1.37,0.26
    		c-0.41,0.18-0.75,0.42-1.04,0.73c-0.29,0.31-0.51,0.67-0.66,1.09c-0.15,0.42-0.23,0.87-0.23,1.35s0.08,0.94,0.23,1.35
    		c0.15,0.42,0.37,0.78,0.66,1.09c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26c0.2,0,0.4-0.02,0.62-0.07
    		c0.21-0.05,0.42-0.12,0.62-0.22c0.2-0.1,0.39-0.22,0.58-0.37c0.18-0.15,0.34-0.33,0.48-0.54L202.33,100.67z"/>
    	<path class="st2" d="M206.05,94.1h0.75l3.28,7.79h-0.81l-0.85-2.07h-4.12l-0.88,2.07h-0.76L206.05,94.1z M206.39,94.9l-1.81,4.27
    		h3.58L206.39,94.9z"/>
    	<path class="st2" d="M211.2,94.1h0.94l4.74,6.82h0.02V94.1h0.73v7.79h-0.94l-4.74-6.82h-0.02v6.82h-0.73V94.1z"/>
    	<path class="st2" d="M222.14,94.1h0.75l3.28,7.79h-0.81l-0.85-2.07h-4.12l-0.88,2.07h-0.76L222.14,94.1z M222.48,94.9l-1.81,4.27
    		h3.58L222.48,94.9z"/>
    	<path class="st2" d="M227.5,100.45c0.19,0.33,0.44,0.58,0.74,0.74c0.3,0.16,0.65,0.24,1.04,0.24c0.24,0,0.47-0.04,0.68-0.11
    		c0.21-0.07,0.4-0.18,0.56-0.31c0.16-0.13,0.28-0.29,0.37-0.48c0.09-0.19,0.14-0.4,0.14-0.63c0-0.27-0.06-0.49-0.17-0.67
    		c-0.11-0.18-0.27-0.32-0.46-0.43c-0.19-0.11-0.41-0.21-0.64-0.29c-0.24-0.08-0.48-0.16-0.74-0.24c-0.25-0.08-0.5-0.17-0.74-0.27
    		c-0.24-0.1-0.45-0.24-0.64-0.4c-0.19-0.17-0.34-0.37-0.46-0.62c-0.11-0.25-0.17-0.56-0.17-0.92c0-0.34,0.07-0.65,0.2-0.92
    		s0.32-0.49,0.55-0.67s0.5-0.32,0.8-0.41c0.3-0.09,0.62-0.14,0.95-0.14c0.43,0,0.82,0.08,1.18,0.23c0.36,0.15,0.68,0.4,0.94,0.75
    		l-0.63,0.45c-0.18-0.26-0.4-0.45-0.64-0.58c-0.25-0.13-0.54-0.19-0.87-0.19c-0.23,0-0.46,0.03-0.67,0.09
    		c-0.21,0.06-0.4,0.15-0.56,0.27s-0.28,0.27-0.38,0.46c-0.1,0.18-0.14,0.4-0.14,0.65c0,0.39,0.1,0.69,0.3,0.9
    		c0.2,0.21,0.45,0.37,0.74,0.5s0.62,0.23,0.97,0.32c0.35,0.09,0.67,0.21,0.97,0.37c0.3,0.15,0.54,0.37,0.74,0.64
    		c0.2,0.27,0.3,0.65,0.3,1.14c0,0.35-0.07,0.66-0.2,0.94c-0.13,0.27-0.31,0.5-0.53,0.69c-0.22,0.19-0.48,0.33-0.78,0.42
    		c-0.29,0.1-0.6,0.14-0.91,0.14c-0.51,0-0.99-0.09-1.42-0.27c-0.43-0.18-0.8-0.48-1.11-0.91L227.5,100.45z"/>
    	<path class="st2" d="M235.13,94.76h-2.66V94.1h6.05v0.66h-2.66v7.13h-0.73V94.76z"/>
    	<path class="st2" d="M241.36,94.1h0.75l3.28,7.79h-0.81l-0.85-2.07h-4.12l-0.88,2.07h-0.76L241.36,94.1z M241.7,94.9l-1.81,4.27
    		h3.58L241.7,94.9z"/>
    	<path class="st2" d="M249.27,94.1h2.41c0.67,0,1.25,0.08,1.72,0.25s0.86,0.38,1.17,0.63c0.31,0.26,0.56,0.54,0.74,0.85
    		c0.18,0.31,0.31,0.61,0.4,0.9c0.08,0.29,0.14,0.54,0.16,0.78s0.03,0.39,0.03,0.49s-0.01,0.26-0.03,0.49
    		c-0.02,0.23-0.08,0.49-0.16,0.78s-0.22,0.58-0.4,0.9c-0.18,0.31-0.43,0.6-0.74,0.85c-0.31,0.26-0.7,0.47-1.17,0.63
    		s-1.04,0.25-1.72,0.25h-2.41V94.1z M249.99,101.23h1.5c0.51,0,0.99-0.06,1.44-0.19c0.45-0.13,0.84-0.32,1.17-0.59
    		c0.33-0.26,0.59-0.6,0.78-1.01c0.19-0.41,0.29-0.89,0.29-1.45c0-0.56-0.1-1.04-0.29-1.45c-0.19-0.41-0.45-0.74-0.78-1.01
    		c-0.33-0.26-0.72-0.46-1.17-0.59c-0.45-0.13-0.93-0.19-1.44-0.19h-1.5V101.23z"/>
    	<path class="st2" d="M257.52,94.1h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V94.1z"/>
    	<path class="st2" d="M265.8,94.1h0.78l2.51,6.83l2.53-6.83h0.77l-2.96,7.79h-0.73L265.8,94.1z"/>
    	<path class="st2" d="M274.29,92.04h0.88l-1.47,1.58h-0.55L274.29,92.04z M273.42,94.1h0.73v7.79h-0.73V94.1z"/>
    	<path class="st2" d="M275.18,94.1h0.78l2.51,6.83L281,94.1h0.77l-2.96,7.79h-0.73L275.18,94.1z"/>
    	<path class="st2" d="M282.8,94.1h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V94.1z"/>
    	<path class="st2" d="M289.33,94.1h2.05c0.1,0,0.24,0,0.42,0.01c0.18,0.01,0.37,0.03,0.57,0.07c0.21,0.04,0.41,0.1,0.63,0.18
    		c0.21,0.08,0.4,0.2,0.57,0.35c0.17,0.15,0.31,0.35,0.42,0.58c0.11,0.23,0.16,0.52,0.16,0.86c0,0.37-0.06,0.68-0.19,0.92
    		c-0.13,0.24-0.29,0.44-0.48,0.59s-0.41,0.26-0.64,0.34s-0.46,0.12-0.67,0.15l2.27,3.74h-0.83l-2.19-3.7h-1.35v3.7h-0.73V94.1z
    		 M290.05,97.54h1.54c0.38,0,0.69-0.05,0.93-0.14c0.24-0.1,0.42-0.21,0.56-0.35c0.13-0.14,0.22-0.29,0.27-0.45
    		c0.05-0.16,0.07-0.31,0.07-0.44c0-0.13-0.02-0.28-0.07-0.44c-0.05-0.16-0.14-0.31-0.27-0.45c-0.13-0.14-0.32-0.26-0.56-0.35
    		c-0.24-0.1-0.55-0.14-0.93-0.14h-1.54V97.54z"/>
    	<path class="st2" d="M295.85,94.1h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V94.1z"/>
    	<path class="st2" d="M302.58,100.45c0.19,0.33,0.44,0.58,0.74,0.74c0.3,0.16,0.65,0.24,1.04,0.24c0.24,0,0.47-0.04,0.68-0.11
    		c0.21-0.07,0.4-0.18,0.56-0.31c0.16-0.13,0.28-0.29,0.37-0.48c0.09-0.19,0.14-0.4,0.14-0.63c0-0.27-0.06-0.49-0.17-0.67
    		c-0.11-0.18-0.27-0.32-0.46-0.43c-0.19-0.11-0.41-0.21-0.64-0.29c-0.24-0.08-0.48-0.16-0.74-0.24c-0.25-0.08-0.5-0.17-0.74-0.27
    		c-0.24-0.1-0.45-0.24-0.64-0.4c-0.19-0.17-0.34-0.37-0.46-0.62c-0.11-0.25-0.17-0.56-0.17-0.92c0-0.34,0.07-0.65,0.2-0.92
    		s0.32-0.49,0.55-0.67s0.5-0.32,0.8-0.41c0.3-0.09,0.62-0.14,0.95-0.14c0.43,0,0.82,0.08,1.18,0.23c0.36,0.15,0.68,0.4,0.94,0.75
    		l-0.63,0.45c-0.18-0.26-0.4-0.45-0.64-0.58c-0.25-0.13-0.54-0.19-0.87-0.19c-0.23,0-0.46,0.03-0.67,0.09
    		c-0.21,0.06-0.4,0.15-0.56,0.27s-0.28,0.27-0.38,0.46c-0.1,0.18-0.14,0.4-0.14,0.65c0,0.39,0.1,0.69,0.3,0.9
    		c0.2,0.21,0.45,0.37,0.74,0.5s0.62,0.23,0.97,0.32c0.35,0.09,0.67,0.21,0.97,0.37c0.3,0.15,0.54,0.37,0.74,0.64
    		c0.2,0.27,0.3,0.65,0.3,1.14c0,0.35-0.07,0.66-0.2,0.94c-0.13,0.27-0.31,0.5-0.53,0.69c-0.22,0.19-0.48,0.33-0.78,0.42
    		c-0.29,0.1-0.6,0.14-0.91,0.14c-0.51,0-0.99-0.09-1.42-0.27c-0.43-0.18-0.8-0.48-1.11-0.91L302.58,100.45z"/>
    	<path class="st2" d="M115.43,113.65c0.19,0.33,0.44,0.58,0.74,0.74c0.3,0.16,0.65,0.24,1.04,0.24c0.24,0,0.47-0.04,0.68-0.11
    		c0.21-0.07,0.4-0.18,0.56-0.31s0.28-0.29,0.37-0.48c0.09-0.19,0.14-0.4,0.14-0.63c0-0.27-0.06-0.5-0.17-0.67
    		c-0.11-0.18-0.27-0.32-0.46-0.43c-0.19-0.11-0.41-0.21-0.64-0.29c-0.24-0.08-0.48-0.16-0.74-0.24c-0.25-0.08-0.5-0.17-0.74-0.28
    		c-0.24-0.1-0.45-0.24-0.64-0.4c-0.19-0.17-0.34-0.37-0.46-0.62s-0.17-0.56-0.17-0.92c0-0.34,0.07-0.65,0.2-0.92
    		s0.32-0.49,0.55-0.67s0.5-0.32,0.8-0.41s0.62-0.14,0.95-0.14c0.43,0,0.82,0.08,1.18,0.23c0.36,0.15,0.68,0.4,0.94,0.75l-0.63,0.45
    		c-0.18-0.26-0.4-0.45-0.64-0.58c-0.25-0.13-0.54-0.19-0.87-0.19c-0.23,0-0.46,0.03-0.67,0.09c-0.21,0.06-0.4,0.15-0.56,0.28
    		c-0.16,0.12-0.28,0.27-0.38,0.46c-0.1,0.18-0.14,0.4-0.14,0.65c0,0.39,0.1,0.69,0.3,0.9c0.2,0.21,0.45,0.37,0.74,0.49
    		c0.3,0.12,0.62,0.23,0.97,0.32s0.67,0.21,0.97,0.37c0.3,0.15,0.54,0.37,0.74,0.64c0.2,0.28,0.3,0.66,0.3,1.14
    		c0,0.35-0.07,0.66-0.2,0.94s-0.31,0.5-0.53,0.69c-0.22,0.19-0.48,0.33-0.78,0.42c-0.29,0.1-0.6,0.14-0.91,0.14
    		c-0.51,0-0.99-0.09-1.42-0.27s-0.8-0.48-1.11-0.91L115.43,113.65z"/>
    	<path class="st2" d="M121.34,107.3h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V107.3z"/>
    	<path class="st2" d="M134.28,114.59c-0.46,0.26-0.93,0.44-1.41,0.54c-0.49,0.11-0.98,0.16-1.49,0.16c-0.59,0-1.14-0.1-1.63-0.3
    		s-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.8-0.83-1.3c-0.2-0.5-0.3-1.05-0.3-1.64c0-0.59,0.1-1.14,0.3-1.64
    		c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85s1.04-0.31,1.63-0.31c1.16,0,2.09,0.36,2.81,1.08l-0.53,0.55
    		c-0.12-0.14-0.26-0.27-0.43-0.39c-0.17-0.12-0.36-0.22-0.56-0.31c-0.2-0.08-0.41-0.15-0.63-0.2c-0.22-0.05-0.44-0.07-0.65-0.07
    		c-0.51,0-0.96,0.09-1.37,0.26c-0.41,0.18-0.75,0.42-1.04,0.73c-0.29,0.31-0.51,0.67-0.66,1.09c-0.15,0.42-0.23,0.87-0.23,1.35
    		c0,0.48,0.08,0.93,0.23,1.35c0.15,0.42,0.37,0.78,0.66,1.09c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26
    		c0.42,0,0.81-0.03,1.18-0.1c0.37-0.07,0.7-0.19,1-0.36v-2.62h-1.87v-0.66h2.6V114.59z"/>
    	<path class="st2" d="M141.95,112.11c0,0.42-0.05,0.82-0.14,1.2c-0.1,0.38-0.25,0.72-0.48,1.01c-0.22,0.29-0.52,0.53-0.88,0.7
    		c-0.36,0.18-0.81,0.26-1.34,0.26c-0.53,0-0.97-0.09-1.34-0.26c-0.36-0.18-0.66-0.41-0.88-0.7c-0.22-0.29-0.38-0.63-0.48-1.01
    		c-0.1-0.38-0.14-0.78-0.14-1.2v-4.81H137v4.62c0,0.28,0.03,0.58,0.08,0.89c0.05,0.32,0.15,0.61,0.3,0.88
    		c0.15,0.27,0.36,0.5,0.64,0.67c0.27,0.18,0.64,0.26,1.09,0.26c0.45,0,0.82-0.09,1.09-0.26c0.27-0.18,0.49-0.4,0.64-0.67
    		c0.15-0.27,0.25-0.56,0.3-0.88c0.05-0.31,0.08-0.61,0.08-0.89v-4.62h0.73V112.11z"/>
    	<path class="st2" d="M143.94,107.3h0.94l4.74,6.82h0.02v-6.82h0.73v7.79h-0.94l-4.74-6.82h-0.02v6.82h-0.73V107.3z"/>
    	<path class="st2" d="M152.4,107.3h2.41c0.67,0,1.25,0.08,1.72,0.25c0.47,0.16,0.86,0.38,1.17,0.63c0.31,0.26,0.56,0.54,0.74,0.85
    		s0.31,0.61,0.4,0.9s0.14,0.54,0.16,0.78c0.02,0.23,0.03,0.39,0.03,0.49c0,0.09-0.01,0.26-0.03,0.49c-0.02,0.23-0.08,0.49-0.16,0.78
    		s-0.22,0.58-0.4,0.9s-0.43,0.6-0.74,0.85c-0.31,0.26-0.7,0.47-1.17,0.63s-1.04,0.25-1.72,0.25h-2.41V107.3z M153.13,114.43h1.5
    		c0.51,0,0.99-0.06,1.44-0.19c0.45-0.13,0.84-0.32,1.17-0.59c0.33-0.26,0.59-0.6,0.78-1.01c0.19-0.41,0.29-0.89,0.29-1.45
    		c0-0.56-0.1-1.04-0.29-1.45c-0.19-0.41-0.45-0.74-0.78-1.01c-0.33-0.26-0.72-0.46-1.17-0.59c-0.45-0.13-0.93-0.19-1.44-0.19h-1.5
    		V114.43z"/>
    	<path class="st2" d="M160.15,111.2c0-0.59,0.1-1.14,0.3-1.64c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85
    		s1.04-0.31,1.63-0.31c0.59,0,1.14,0.1,1.63,0.31c0.49,0.21,0.92,0.49,1.27,0.85c0.35,0.36,0.63,0.79,0.82,1.29
    		c0.2,0.5,0.3,1.04,0.3,1.64c0,0.59-0.1,1.14-0.3,1.64c-0.2,0.5-0.47,0.93-0.82,1.3c-0.35,0.36-0.78,0.65-1.27,0.85
    		c-0.5,0.2-1.04,0.3-1.63,0.3c-0.59,0-1.14-0.1-1.63-0.3s-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.8-0.83-1.3
    		C160.24,112.34,160.15,111.79,160.15,111.2z M160.87,111.2c0,0.48,0.08,0.93,0.23,1.35c0.15,0.42,0.37,0.78,0.66,1.09
    		c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26s0.96-0.09,1.37-0.26c0.41-0.18,0.75-0.42,1.04-0.73
    		c0.29-0.31,0.51-0.67,0.66-1.09c0.15-0.42,0.23-0.87,0.23-1.35c0-0.48-0.08-0.94-0.23-1.35c-0.15-0.42-0.37-0.78-0.66-1.09
    		s-0.63-0.55-1.04-0.73c-0.41-0.18-0.86-0.26-1.37-0.26s-0.96,0.09-1.37,0.26c-0.41,0.18-0.75,0.42-1.04,0.73
    		c-0.29,0.31-0.51,0.67-0.66,1.09C160.95,110.26,160.87,110.71,160.87,111.2z"/>
    	<path class="st2" d="M172.69,107.3h2.24c0.27,0,0.56,0.03,0.85,0.09s0.57,0.17,0.81,0.32s0.45,0.37,0.6,0.63s0.24,0.6,0.24,1.01
    		c0,0.35-0.06,0.66-0.19,0.91c-0.13,0.26-0.3,0.47-0.52,0.63s-0.47,0.29-0.75,0.37c-0.28,0.08-0.58,0.12-0.89,0.12h-1.68v3.7h-0.73
    		V107.3z M173.41,110.74h1.65c0.21,0,0.41-0.02,0.6-0.07c0.2-0.05,0.37-0.12,0.53-0.23c0.15-0.11,0.28-0.25,0.37-0.42
    		c0.1-0.18,0.14-0.39,0.14-0.65c0-0.25-0.05-0.46-0.15-0.64c-0.1-0.18-0.23-0.32-0.38-0.43c-0.16-0.11-0.34-0.2-0.54-0.25
    		c-0.21-0.05-0.41-0.08-0.62-0.08h-1.61V110.74z"/>
    	<path class="st2" d="M179,107.3h2.05c0.1,0,0.24,0,0.42,0.01c0.18,0.01,0.37,0.03,0.57,0.07c0.21,0.04,0.41,0.1,0.63,0.18
    		c0.21,0.08,0.4,0.2,0.57,0.35c0.17,0.15,0.31,0.35,0.42,0.58c0.11,0.23,0.16,0.52,0.16,0.86c0,0.37-0.06,0.68-0.19,0.92
    		c-0.13,0.24-0.29,0.44-0.48,0.59s-0.41,0.26-0.64,0.34s-0.46,0.12-0.67,0.15l2.27,3.74h-0.83l-2.19-3.7h-1.35v3.7H179V107.3z
    		 M179.73,110.74h1.54c0.38,0,0.69-0.05,0.93-0.14c0.24-0.09,0.42-0.21,0.56-0.35c0.13-0.14,0.22-0.29,0.27-0.45
    		s0.07-0.31,0.07-0.44s-0.02-0.28-0.07-0.44s-0.14-0.31-0.27-0.45c-0.13-0.14-0.32-0.26-0.56-0.35c-0.24-0.09-0.55-0.14-0.93-0.14
    		h-1.54V110.74z"/>
    	<path class="st2" d="M185.52,107.3h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V107.3z"/>
    	<path class="st2" d="M191.97,107.3h1.09l2.84,6.53l2.84-6.53h1.03v7.79h-0.73v-6.86h-0.02l-2.97,6.86h-0.32l-3.01-6.86h-0.02v6.86
    		h-0.73V107.3z"/>
    	<path class="st2" d="M201.82,107.3h0.73v7.79h-0.73V107.3z"/>
    	<path class="st2" d="M204.18,111.2c0-0.59,0.1-1.14,0.3-1.64c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85
    		s1.04-0.31,1.63-0.31c0.59,0,1.14,0.1,1.63,0.31c0.49,0.21,0.92,0.49,1.27,0.85c0.35,0.36,0.63,0.79,0.82,1.29
    		c0.2,0.5,0.3,1.04,0.3,1.64c0,0.59-0.1,1.14-0.3,1.64c-0.2,0.5-0.47,0.93-0.82,1.3c-0.35,0.36-0.78,0.65-1.27,0.85
    		c-0.5,0.2-1.04,0.3-1.63,0.3c-0.59,0-1.14-0.1-1.63-0.3s-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.8-0.83-1.3
    		C204.28,112.34,204.18,111.79,204.18,111.2z M204.9,111.2c0,0.48,0.08,0.93,0.23,1.35c0.15,0.42,0.37,0.78,0.66,1.09
    		c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26s0.96-0.09,1.37-0.26c0.41-0.18,0.75-0.42,1.04-0.73
    		c0.29-0.31,0.51-0.67,0.66-1.09c0.15-0.42,0.23-0.87,0.23-1.35c0-0.48-0.08-0.94-0.23-1.35c-0.15-0.42-0.37-0.78-0.66-1.09
    		s-0.63-0.55-1.04-0.73c-0.41-0.18-0.86-0.26-1.37-0.26s-0.96,0.09-1.37,0.26c-0.41,0.18-0.75,0.42-1.04,0.73
    		c-0.29,0.31-0.51,0.67-0.66,1.09C204.98,110.26,204.9,110.71,204.9,111.2z"/>
    	<path class="st2" d="M213.69,110.47c0-0.15,0.05-0.27,0.15-0.37c0.1-0.1,0.23-0.15,0.37-0.15c0.15,0,0.27,0.05,0.37,0.15
    		c0.1,0.1,0.15,0.23,0.15,0.37s-0.05,0.27-0.15,0.37c-0.1,0.1-0.23,0.15-0.37,0.15c-0.15,0-0.27-0.05-0.37-0.15
    		C213.74,110.74,213.69,110.62,213.69,110.47z M213.69,114.63c0-0.15,0.05-0.27,0.15-0.37c0.1-0.1,0.23-0.15,0.37-0.15
    		c0.15,0,0.27,0.05,0.37,0.15c0.1,0.1,0.15,0.23,0.15,0.37s-0.05,0.27-0.15,0.37c-0.1,0.1-0.23,0.15-0.37,0.15
    		c-0.15,0-0.27-0.05-0.37-0.15C213.74,114.9,213.69,114.78,213.69,114.63z"/>
    	<path class="st2" d="M219.58,107.3h0.73v3.43h0.07l3.77-3.43h1l-3.94,3.56l4.16,4.22h-1.04l-3.95-4.03h-0.07v4.03h-0.73V107.3z"/>
    	<path class="st2" d="M226.3,107.3h0.73v7.79h-0.73V107.3z"/>
    	<path class="st2" d="M230.89,107.96h-2.66v-0.66h6.05v0.66h-2.66v7.13h-0.73V107.96z"/>
    	<path class="st2" d="M240.72,107.3h0.75l3.28,7.79h-0.81l-0.85-2.07h-4.12l-0.88,2.07h-0.76L240.72,107.3z M241.06,108.1
    		l-1.81,4.27h3.58L241.06,108.1z"/>
    	<path class="st2" d="M245.87,107.3h0.94l4.74,6.82h0.02v-6.82h0.73v7.79h-0.94l-4.74-6.82h-0.02v6.82h-0.73V107.3z"/>
    	<path class="st2" d="M256.15,107.96h-2.66v-0.66h6.05v0.66h-2.66v7.13h-0.73V107.96z"/>
    	<path class="st2" d="M260.74,107.3h0.73v7.79h-0.73V107.3z"/>
    	<path class="st2" d="M272.87,113.87c-0.37,0.51-0.81,0.87-1.3,1.09c-0.49,0.22-1.02,0.33-1.6,0.33c-0.59,0-1.14-0.1-1.63-0.3
    		s-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.8-0.83-1.3c-0.2-0.5-0.3-1.05-0.3-1.64c0-0.59,0.1-1.14,0.3-1.64
    		c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85s1.04-0.31,1.63-0.31c0.53,0,1.02,0.09,1.48,0.28
    		c0.46,0.19,0.86,0.5,1.2,0.94l-0.59,0.5c-0.24-0.37-0.55-0.63-0.93-0.8c-0.38-0.17-0.76-0.25-1.16-0.25
    		c-0.51,0-0.96,0.09-1.37,0.26c-0.41,0.18-0.75,0.42-1.04,0.73c-0.29,0.31-0.51,0.67-0.66,1.09c-0.15,0.42-0.23,0.87-0.23,1.35
    		c0,0.48,0.08,0.93,0.23,1.35c0.15,0.42,0.37,0.78,0.66,1.09c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26
    		c0.2,0,0.4-0.02,0.62-0.07c0.21-0.05,0.42-0.12,0.62-0.22c0.2-0.1,0.39-0.22,0.58-0.37c0.18-0.15,0.34-0.33,0.48-0.54
    		L272.87,113.87z"/>
    	<path class="st2" d="M273.7,111.2c0-0.59,0.1-1.14,0.3-1.64c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85
    		s1.04-0.31,1.63-0.31c0.59,0,1.14,0.1,1.63,0.31c0.49,0.21,0.92,0.49,1.27,0.85c0.35,0.36,0.63,0.79,0.82,1.29
    		c0.2,0.5,0.3,1.04,0.3,1.64c0,0.59-0.1,1.14-0.3,1.64c-0.2,0.5-0.47,0.93-0.82,1.3c-0.35,0.36-0.78,0.65-1.27,0.85
    		c-0.5,0.2-1.04,0.3-1.63,0.3c-0.59,0-1.14-0.1-1.63-0.3s-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.8-0.83-1.3
    		C273.8,112.34,273.7,111.79,273.7,111.2z M274.42,111.2c0,0.48,0.08,0.93,0.23,1.35c0.15,0.42,0.37,0.78,0.66,1.09
    		c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26s0.96-0.09,1.37-0.26c0.41-0.18,0.75-0.42,1.04-0.73
    		c0.29-0.31,0.51-0.67,0.66-1.09c0.15-0.42,0.23-0.87,0.23-1.35c0-0.48-0.08-0.94-0.23-1.35c-0.15-0.42-0.37-0.78-0.66-1.09
    		s-0.63-0.55-1.04-0.73c-0.41-0.18-0.86-0.26-1.37-0.26s-0.96,0.09-1.37,0.26c-0.41,0.18-0.75,0.42-1.04,0.73
    		c-0.29,0.31-0.51,0.67-0.66,1.09C274.5,110.26,274.42,110.71,274.42,111.2z"/>
    	<path class="st2" d="M282.28,107.3h0.78l2.51,6.83l2.53-6.83h0.77l-2.96,7.79h-0.73L282.28,107.3z"/>
    	<path class="st2" d="M289.9,107.3h0.73v7.79h-0.73V107.3z"/>
    	<path class="st2" d="M292.66,107.3h2.41c0.67,0,1.25,0.08,1.72,0.25c0.47,0.16,0.86,0.38,1.17,0.63c0.31,0.26,0.56,0.54,0.74,0.85
    		s0.31,0.61,0.4,0.9s0.14,0.54,0.16,0.78c0.02,0.23,0.03,0.39,0.03,0.49c0,0.09-0.01,0.26-0.03,0.49c-0.02,0.23-0.08,0.49-0.16,0.78
    		s-0.22,0.58-0.4,0.9s-0.43,0.6-0.74,0.85c-0.31,0.26-0.7,0.47-1.17,0.63s-1.04,0.25-1.72,0.25h-2.41V107.3z M293.39,114.43h1.5
    		c0.51,0,0.99-0.06,1.44-0.19c0.45-0.13,0.84-0.32,1.17-0.59c0.33-0.26,0.59-0.6,0.78-1.01c0.19-0.41,0.29-0.89,0.29-1.45
    		c0-0.56-0.1-1.04-0.29-1.45c-0.19-0.41-0.45-0.74-0.78-1.01c-0.33-0.26-0.72-0.46-1.17-0.59c-0.45-0.13-0.93-0.19-1.44-0.19h-1.5
    		V114.43z"/>
    	<path class="st2" d="M104.1,121.17h-2.66v-0.66h6.05v0.66h-2.66v7.13h-0.73V121.17z"/>
    	<path class="st2" d="M108.69,120.5h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V120.5z"/>
    	<path class="st2" d="M115.21,120.5h2.05c0.1,0,0.24,0,0.42,0.01c0.18,0.01,0.37,0.03,0.57,0.07c0.21,0.04,0.41,0.1,0.63,0.18
    		c0.21,0.08,0.4,0.2,0.57,0.35c0.17,0.15,0.31,0.35,0.42,0.58c0.11,0.23,0.16,0.52,0.16,0.86c0,0.37-0.06,0.68-0.19,0.92
    		c-0.13,0.24-0.29,0.44-0.48,0.59s-0.41,0.26-0.64,0.34s-0.46,0.12-0.67,0.15l2.27,3.74h-0.83l-2.19-3.7h-1.35v3.7h-0.73V120.5z
    		 M115.94,123.94h1.54c0.38,0,0.69-0.05,0.93-0.14c0.24-0.09,0.42-0.21,0.56-0.35c0.13-0.14,0.22-0.29,0.27-0.45
    		s0.07-0.31,0.07-0.44s-0.02-0.28-0.07-0.44s-0.14-0.31-0.27-0.45c-0.13-0.14-0.32-0.26-0.56-0.35c-0.24-0.09-0.55-0.14-0.93-0.14
    		h-1.54V123.94z"/>
    	<path class="st2" d="M128.15,127.07c-0.37,0.51-0.81,0.87-1.3,1.09c-0.49,0.22-1.02,0.33-1.6,0.33c-0.59,0-1.14-0.1-1.63-0.3
    		s-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.8-0.83-1.3c-0.2-0.5-0.3-1.05-0.3-1.64c0-0.59,0.1-1.14,0.3-1.64
    		c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85s1.04-0.31,1.63-0.31c0.53,0,1.02,0.09,1.48,0.28
    		c0.46,0.19,0.86,0.5,1.2,0.94l-0.59,0.5c-0.24-0.37-0.55-0.63-0.93-0.8c-0.38-0.17-0.76-0.25-1.16-0.25
    		c-0.51,0-0.96,0.09-1.37,0.26c-0.41,0.18-0.75,0.42-1.04,0.73c-0.29,0.31-0.51,0.67-0.66,1.09c-0.15,0.42-0.23,0.87-0.23,1.35
    		c0,0.48,0.08,0.93,0.23,1.35c0.15,0.42,0.37,0.78,0.66,1.09c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26
    		c0.2,0,0.4-0.02,0.62-0.07c0.21-0.05,0.42-0.12,0.62-0.22c0.2-0.1,0.39-0.22,0.58-0.37c0.18-0.15,0.34-0.33,0.48-0.54
    		L128.15,127.07z"/>
    	<path class="st2" d="M129.48,120.5h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V120.5z"/>
    	<path class="st2" d="M136,120.5h2.05c0.1,0,0.24,0,0.42,0.01c0.18,0.01,0.37,0.03,0.57,0.07c0.21,0.04,0.41,0.1,0.63,0.18
    		c0.21,0.08,0.4,0.2,0.57,0.35c0.17,0.15,0.31,0.35,0.42,0.58c0.11,0.23,0.16,0.52,0.16,0.86c0,0.37-0.06,0.68-0.19,0.92
    		c-0.13,0.24-0.29,0.44-0.48,0.59s-0.41,0.26-0.64,0.34s-0.46,0.12-0.67,0.15l2.27,3.74h-0.83l-2.19-3.7h-1.35v3.7H136V120.5z
    		 M136.73,123.94h1.54c0.38,0,0.69-0.05,0.93-0.14c0.24-0.09,0.42-0.21,0.56-0.35c0.13-0.14,0.22-0.29,0.27-0.45
    		s0.07-0.31,0.07-0.44s-0.02-0.28-0.07-0.44s-0.14-0.31-0.27-0.45c-0.13-0.14-0.32-0.26-0.56-0.35c-0.24-0.09-0.55-0.14-0.93-0.14
    		h-1.54V123.94z"/>
    	<path class="st2" d="M145.38,120.5h2.24c0.27,0,0.56,0.03,0.85,0.09s0.57,0.17,0.81,0.32s0.45,0.37,0.6,0.63s0.24,0.6,0.24,1.01
    		c0,0.35-0.06,0.66-0.19,0.91c-0.13,0.26-0.3,0.47-0.52,0.63s-0.47,0.29-0.75,0.37c-0.28,0.08-0.58,0.12-0.89,0.12h-1.68v3.7h-0.73
    		V120.5z M146.11,123.94h1.65c0.21,0,0.41-0.02,0.6-0.07c0.2-0.05,0.37-0.12,0.53-0.23c0.15-0.11,0.28-0.25,0.37-0.42
    		c0.1-0.18,0.14-0.39,0.14-0.65c0-0.25-0.05-0.46-0.15-0.64c-0.1-0.18-0.23-0.32-0.38-0.43c-0.16-0.11-0.34-0.2-0.54-0.25
    		c-0.21-0.05-0.41-0.08-0.62-0.08h-1.61V123.94z"/>
    	<path class="st2" d="M151.7,120.5h2.05c0.1,0,0.24,0,0.42,0.01c0.18,0.01,0.37,0.03,0.57,0.07c0.21,0.04,0.41,0.1,0.63,0.18
    		c0.21,0.08,0.4,0.2,0.57,0.35c0.17,0.15,0.31,0.35,0.42,0.58c0.11,0.23,0.16,0.52,0.16,0.86c0,0.37-0.06,0.68-0.19,0.92
    		c-0.13,0.24-0.29,0.44-0.48,0.59s-0.41,0.26-0.64,0.34s-0.46,0.12-0.67,0.15l2.27,3.74h-0.83l-2.19-3.7h-1.35v3.7h-0.73V120.5z
    		 M152.42,123.94h1.54c0.38,0,0.69-0.05,0.93-0.14c0.24-0.09,0.42-0.21,0.56-0.35c0.13-0.14,0.22-0.29,0.27-0.45
    		s0.07-0.31,0.07-0.44s-0.02-0.28-0.07-0.44s-0.14-0.31-0.27-0.45c-0.13-0.14-0.32-0.26-0.56-0.35c-0.24-0.09-0.55-0.14-0.93-0.14
    		h-1.54V123.94z"/>
    	<path class="st2" d="M158.22,120.5h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V120.5z"/>
    	<path class="st2" d="M164.67,120.5h1.09l2.84,6.53l2.84-6.53h1.03v7.79h-0.73v-6.86h-0.02l-2.97,6.86h-0.32l-3.01-6.86h-0.02v6.86
    		h-0.73V120.5z"/>
    	<path class="st2" d="M174.52,120.5h0.73v7.79h-0.73V120.5z"/>
    	<path class="st2" d="M176.88,124.4c0-0.59,0.1-1.14,0.3-1.64c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85
    		s1.04-0.31,1.63-0.31c0.59,0,1.14,0.1,1.63,0.31c0.49,0.21,0.92,0.49,1.27,0.85c0.35,0.36,0.63,0.79,0.82,1.29
    		c0.2,0.5,0.3,1.04,0.3,1.64c0,0.59-0.1,1.14-0.3,1.64c-0.2,0.5-0.47,0.93-0.82,1.3c-0.35,0.36-0.78,0.65-1.27,0.85
    		c-0.5,0.2-1.04,0.3-1.63,0.3c-0.59,0-1.14-0.1-1.63-0.3s-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.8-0.83-1.3
    		C176.98,125.54,176.88,124.99,176.88,124.4z M177.6,124.4c0,0.48,0.08,0.93,0.23,1.35c0.15,0.42,0.37,0.78,0.66,1.09
    		c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26s0.96-0.09,1.37-0.26c0.41-0.18,0.75-0.42,1.04-0.73
    		c0.29-0.31,0.51-0.67,0.66-1.09c0.15-0.42,0.23-0.87,0.23-1.35c0-0.48-0.08-0.94-0.23-1.35c-0.15-0.42-0.37-0.78-0.66-1.09
    		s-0.63-0.55-1.04-0.73c-0.41-0.18-0.86-0.26-1.37-0.26s-0.96,0.09-1.37,0.26c-0.41,0.18-0.75,0.42-1.04,0.73
    		c-0.29,0.31-0.51,0.67-0.66,1.09C177.68,123.46,177.6,123.92,177.6,124.4z"/>
    	<path class="st2" d="M186.39,123.67c0-0.15,0.05-0.27,0.15-0.37c0.1-0.1,0.23-0.15,0.37-0.15c0.15,0,0.27,0.05,0.37,0.15
    		c0.1,0.1,0.15,0.23,0.15,0.37s-0.05,0.27-0.15,0.37c-0.1,0.1-0.23,0.15-0.37,0.15c-0.15,0-0.27-0.05-0.37-0.15
    		C186.44,123.94,186.39,123.82,186.39,123.67z M186.39,127.83c0-0.15,0.05-0.27,0.15-0.37c0.1-0.1,0.23-0.15,0.37-0.15
    		c0.15,0,0.27,0.05,0.37,0.15c0.1,0.1,0.15,0.23,0.15,0.37s-0.05,0.27-0.15,0.37c-0.1,0.1-0.23,0.15-0.37,0.15
    		c-0.15,0-0.27-0.05-0.37-0.15C186.44,128.1,186.39,127.98,186.39,127.83z"/>
    	<path class="st2" d="M192.28,120.5H193v3.43h0.07l3.77-3.43h1l-3.94,3.56l4.16,4.22h-1.04l-3.95-4.03H193v4.03h-0.73V120.5z"/>
    	<path class="st2" d="M199,120.5h0.73v7.79H199V120.5z"/>
    	<path class="st2" d="M203.58,121.17h-2.66v-0.66h6.05v0.66h-2.66v7.13h-0.73V121.17z"/>
    	<path class="st2" d="M211.03,120.5h2.05c0.1,0,0.24,0,0.42,0.01c0.18,0.01,0.37,0.03,0.57,0.07c0.21,0.04,0.41,0.1,0.63,0.18
    		c0.21,0.08,0.4,0.2,0.57,0.35c0.17,0.15,0.31,0.35,0.42,0.58c0.11,0.23,0.16,0.52,0.16,0.86c0,0.37-0.06,0.68-0.19,0.92
    		c-0.13,0.24-0.29,0.44-0.48,0.59s-0.41,0.26-0.64,0.34s-0.46,0.12-0.67,0.15l2.27,3.74h-0.83l-2.19-3.7h-1.35v3.7h-0.73V120.5z
    		 M211.76,123.94h1.54c0.38,0,0.69-0.05,0.93-0.14c0.24-0.09,0.42-0.21,0.56-0.35c0.13-0.14,0.22-0.29,0.27-0.45
    		s0.07-0.31,0.07-0.44s-0.02-0.28-0.07-0.44s-0.14-0.31-0.27-0.45c-0.13-0.14-0.32-0.26-0.56-0.35c-0.24-0.09-0.55-0.14-0.93-0.14
    		h-1.54V123.94z"/>
    	<path class="st2" d="M217.55,120.5h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V120.5z"/>
    	<path class="st2" d="M230.5,127.79c-0.46,0.26-0.93,0.44-1.41,0.54c-0.49,0.11-0.98,0.16-1.49,0.16c-0.59,0-1.14-0.1-1.63-0.3
    		s-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.8-0.83-1.3c-0.2-0.5-0.3-1.05-0.3-1.64c0-0.59,0.1-1.14,0.3-1.64
    		c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85s1.04-0.31,1.63-0.31c1.16,0,2.09,0.36,2.81,1.08l-0.53,0.55
    		c-0.12-0.14-0.26-0.27-0.43-0.39c-0.17-0.12-0.36-0.22-0.56-0.31c-0.2-0.08-0.41-0.15-0.63-0.2c-0.22-0.05-0.44-0.07-0.65-0.07
    		c-0.51,0-0.96,0.09-1.37,0.26c-0.41,0.18-0.75,0.42-1.04,0.73c-0.29,0.31-0.51,0.67-0.66,1.09c-0.15,0.42-0.23,0.87-0.23,1.35
    		c0,0.48,0.08,0.93,0.23,1.35c0.15,0.42,0.37,0.78,0.66,1.09c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26
    		c0.42,0,0.81-0.03,1.18-0.1c0.37-0.07,0.7-0.19,1-0.36v-2.62h-1.87v-0.66h2.6V127.79z"/>
    	<path class="st2" d="M232.63,120.5h2.05c0.1,0,0.24,0,0.42,0.01c0.18,0.01,0.37,0.03,0.57,0.07c0.21,0.04,0.41,0.1,0.63,0.18
    		c0.21,0.08,0.4,0.2,0.57,0.35c0.17,0.15,0.31,0.35,0.42,0.58c0.11,0.23,0.16,0.52,0.16,0.86c0,0.37-0.06,0.68-0.19,0.92
    		c-0.13,0.24-0.29,0.44-0.48,0.59s-0.41,0.26-0.64,0.34s-0.46,0.12-0.67,0.15l2.27,3.74h-0.83l-2.19-3.7h-1.35v3.7h-0.73V120.5z
    		 M233.36,123.94h1.54c0.38,0,0.69-0.05,0.93-0.14c0.24-0.09,0.42-0.21,0.56-0.35c0.13-0.14,0.22-0.29,0.27-0.45
    		s0.07-0.31,0.07-0.44s-0.02-0.28-0.07-0.44s-0.14-0.31-0.27-0.45c-0.13-0.14-0.32-0.26-0.56-0.35c-0.24-0.09-0.55-0.14-0.93-0.14
    		h-1.54V123.94z"/>
    	<path class="st2" d="M239.16,120.5h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V120.5z"/>
    	<path class="st2" d="M245.89,126.85c0.19,0.33,0.44,0.58,0.74,0.74c0.3,0.16,0.65,0.24,1.04,0.24c0.24,0,0.47-0.04,0.68-0.11
    		c0.21-0.07,0.4-0.18,0.56-0.31s0.28-0.29,0.37-0.48c0.09-0.19,0.14-0.4,0.14-0.63c0-0.27-0.06-0.5-0.17-0.67
    		c-0.11-0.18-0.27-0.32-0.46-0.43c-0.19-0.11-0.41-0.21-0.64-0.29c-0.24-0.08-0.48-0.16-0.74-0.24c-0.25-0.08-0.5-0.17-0.74-0.28
    		c-0.24-0.1-0.45-0.24-0.64-0.4c-0.19-0.17-0.34-0.37-0.46-0.62s-0.17-0.56-0.17-0.92c0-0.34,0.07-0.65,0.2-0.92
    		s0.32-0.49,0.55-0.67s0.5-0.32,0.8-0.41s0.62-0.14,0.95-0.14c0.43,0,0.82,0.08,1.18,0.23c0.36,0.15,0.68,0.4,0.94,0.75l-0.63,0.45
    		c-0.18-0.26-0.4-0.45-0.64-0.58c-0.25-0.13-0.54-0.19-0.87-0.19c-0.23,0-0.46,0.03-0.67,0.09c-0.21,0.06-0.4,0.15-0.56,0.28
    		c-0.16,0.12-0.28,0.27-0.38,0.46c-0.1,0.18-0.14,0.4-0.14,0.65c0,0.39,0.1,0.69,0.3,0.9c0.2,0.21,0.45,0.37,0.74,0.49
    		c0.3,0.12,0.62,0.23,0.97,0.32s0.67,0.21,0.97,0.37c0.3,0.15,0.54,0.37,0.74,0.64c0.2,0.28,0.3,0.66,0.3,1.14
    		c0,0.35-0.07,0.66-0.2,0.94s-0.31,0.5-0.53,0.69c-0.22,0.19-0.48,0.33-0.78,0.42c-0.29,0.1-0.6,0.14-0.91,0.14
    		c-0.51,0-0.99-0.09-1.42-0.27s-0.8-0.48-1.11-0.91L245.89,126.85z"/>
    	<path class="st2" d="M251.29,124.4c0-0.59,0.1-1.14,0.3-1.64c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85
    		s1.04-0.31,1.63-0.31c0.59,0,1.14,0.1,1.63,0.31c0.49,0.21,0.92,0.49,1.27,0.85c0.35,0.36,0.63,0.79,0.82,1.29
    		c0.2,0.5,0.3,1.04,0.3,1.64c0,0.59-0.1,1.14-0.3,1.64c-0.2,0.5-0.47,0.93-0.82,1.3c-0.35,0.36-0.78,0.65-1.27,0.85
    		c-0.5,0.2-1.04,0.3-1.63,0.3c-0.59,0-1.14-0.1-1.63-0.3s-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.8-0.83-1.3
    		C251.39,125.54,251.29,124.99,251.29,124.4z M252.02,124.4c0,0.48,0.08,0.93,0.23,1.35c0.15,0.42,0.37,0.78,0.66,1.09
    		c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26s0.96-0.09,1.37-0.26c0.41-0.18,0.75-0.42,1.04-0.73
    		c0.29-0.31,0.51-0.67,0.66-1.09c0.15-0.42,0.23-0.87,0.23-1.35c0-0.48-0.08-0.94-0.23-1.35c-0.15-0.42-0.37-0.78-0.66-1.09
    		s-0.63-0.55-1.04-0.73c-0.41-0.18-0.86-0.26-1.37-0.26s-0.96,0.09-1.37,0.26c-0.41,0.18-0.75,0.42-1.04,0.73
    		c-0.29,0.31-0.51,0.67-0.66,1.09C252.09,123.46,252.02,123.92,252.02,124.4z"/>
    	<path class="st2" d="M266.22,120.5h0.75l3.28,7.79h-0.81l-0.85-2.07h-4.12l-0.88,2.07h-0.76L266.22,120.5z M266.56,121.3
    		l-1.81,4.27h3.58L266.56,121.3z"/>
    	<path class="st2" d="M280.64,127.07c-0.37,0.51-0.81,0.87-1.3,1.09c-0.49,0.22-1.02,0.33-1.6,0.33c-0.59,0-1.14-0.1-1.63-0.3
    		s-0.92-0.48-1.27-0.85c-0.35-0.36-0.63-0.8-0.83-1.3c-0.2-0.5-0.3-1.05-0.3-1.64c0-0.59,0.1-1.14,0.3-1.64
    		c0.2-0.5,0.47-0.93,0.83-1.29c0.35-0.36,0.78-0.65,1.27-0.85s1.04-0.31,1.63-0.31c0.53,0,1.02,0.09,1.48,0.28
    		c0.46,0.19,0.86,0.5,1.2,0.94l-0.59,0.5c-0.24-0.37-0.55-0.63-0.93-0.8c-0.38-0.17-0.76-0.25-1.16-0.25
    		c-0.51,0-0.96,0.09-1.37,0.26c-0.41,0.18-0.75,0.42-1.04,0.73c-0.29,0.31-0.51,0.67-0.66,1.09c-0.15,0.42-0.23,0.87-0.23,1.35
    		c0,0.48,0.08,0.93,0.23,1.35c0.15,0.42,0.37,0.78,0.66,1.09c0.29,0.31,0.63,0.55,1.04,0.73c0.41,0.18,0.86,0.26,1.37,0.26
    		c0.2,0,0.4-0.02,0.62-0.07c0.21-0.05,0.42-0.12,0.62-0.22c0.2-0.1,0.39-0.22,0.58-0.37c0.18-0.15,0.34-0.33,0.48-0.54
    		L280.64,127.07z"/>
    	<path class="st2" d="M281.97,120.5h0.73v7.13h3.63v0.66h-4.36V120.5z"/>
    	<path class="st2" d="M289.86,120.5h0.75l3.28,7.79h-0.81l-0.85-2.07h-4.12l-0.88,2.07h-0.76L289.86,120.5z M290.2,121.3l-1.81,4.27
    		h3.58L290.2,121.3z"/>
    	<path class="st2" d="M295.21,126.85c0.19,0.33,0.44,0.58,0.74,0.74c0.3,0.16,0.65,0.24,1.04,0.24c0.24,0,0.47-0.04,0.68-0.11
    		c0.21-0.07,0.4-0.18,0.56-0.31s0.28-0.29,0.37-0.48c0.09-0.19,0.14-0.4,0.14-0.63c0-0.27-0.06-0.5-0.17-0.67
    		c-0.11-0.18-0.27-0.32-0.46-0.43c-0.19-0.11-0.41-0.21-0.64-0.29c-0.24-0.08-0.48-0.16-0.74-0.24c-0.25-0.08-0.5-0.17-0.74-0.28
    		c-0.24-0.1-0.45-0.24-0.64-0.4c-0.19-0.17-0.34-0.37-0.46-0.62s-0.17-0.56-0.17-0.92c0-0.34,0.07-0.65,0.2-0.92
    		s0.32-0.49,0.55-0.67s0.5-0.32,0.8-0.41s0.62-0.14,0.95-0.14c0.43,0,0.82,0.08,1.18,0.23c0.36,0.15,0.68,0.4,0.94,0.75l-0.63,0.45
    		c-0.18-0.26-0.4-0.45-0.64-0.58c-0.25-0.13-0.54-0.19-0.87-0.19c-0.23,0-0.46,0.03-0.67,0.09c-0.21,0.06-0.4,0.15-0.56,0.28
    		c-0.16,0.12-0.28,0.27-0.38,0.46c-0.1,0.18-0.14,0.4-0.14,0.65c0,0.39,0.1,0.69,0.3,0.9c0.2,0.21,0.45,0.37,0.74,0.49
    		c0.3,0.12,0.62,0.23,0.97,0.32s0.67,0.21,0.97,0.37c0.3,0.15,0.54,0.37,0.74,0.64c0.2,0.28,0.3,0.66,0.3,1.14
    		c0,0.35-0.07,0.66-0.2,0.94s-0.31,0.5-0.53,0.69c-0.22,0.19-0.48,0.33-0.78,0.42c-0.29,0.1-0.6,0.14-0.91,0.14
    		c-0.51,0-0.99-0.09-1.42-0.27s-0.8-0.48-1.11-0.91L295.21,126.85z"/>
    	<path class="st2" d="M301.12,120.5h4.76v0.66h-4.04v2.77h3.78v0.66h-3.78v3.04h4.21v0.66h-4.94V120.5z"/>
    	<path class="st2" d="M307.85,126.85c0.19,0.33,0.44,0.58,0.74,0.74c0.3,0.16,0.65,0.24,1.04,0.24c0.24,0,0.47-0.04,0.68-0.11
    		c0.21-0.07,0.4-0.18,0.56-0.31c0.16-0.13,0.28-0.29,0.37-0.48c0.09-0.19,0.14-0.4,0.14-0.63c0-0.27-0.06-0.5-0.17-0.67
    		c-0.11-0.18-0.27-0.32-0.46-0.43c-0.19-0.11-0.41-0.21-0.64-0.29c-0.24-0.08-0.48-0.16-0.74-0.24s-0.5-0.17-0.74-0.28
    		c-0.24-0.1-0.45-0.24-0.64-0.4s-0.34-0.37-0.46-0.62c-0.11-0.25-0.17-0.56-0.17-0.92c0-0.34,0.07-0.65,0.2-0.92
    		c0.14-0.27,0.32-0.49,0.55-0.67c0.23-0.18,0.5-0.32,0.8-0.41s0.62-0.14,0.95-0.14c0.42,0,0.82,0.08,1.18,0.23s0.68,0.4,0.94,0.75
    		l-0.63,0.45c-0.18-0.26-0.4-0.45-0.64-0.58c-0.25-0.13-0.54-0.19-0.88-0.19c-0.23,0-0.46,0.03-0.67,0.09s-0.4,0.15-0.56,0.28
    		c-0.16,0.12-0.28,0.27-0.38,0.46c-0.1,0.18-0.14,0.4-0.14,0.65c0,0.39,0.1,0.69,0.3,0.9c0.2,0.21,0.45,0.37,0.74,0.49
    		c0.3,0.12,0.62,0.23,0.97,0.32s0.67,0.21,0.97,0.37c0.3,0.15,0.54,0.37,0.74,0.64c0.2,0.28,0.3,0.66,0.3,1.14
    		c0,0.35-0.07,0.66-0.2,0.94s-0.31,0.5-0.53,0.69c-0.22,0.19-0.48,0.33-0.78,0.42c-0.29,0.1-0.6,0.14-0.91,0.14
    		c-0.51,0-0.99-0.09-1.42-0.27c-0.43-0.18-0.8-0.48-1.11-0.91L307.85,126.85z"/>
    </g>
    <text transform="matrix(1 0 0 1 469.0483 182.9875)" class="st6 st7 st8"><?php echo $id_str; ?></text>
    <text transform="matrix(1 0 0 1 437.4678 56.7064)" class="st6 st9 st10"><?php echo $nombre_completo; ?></text>
    <text transform="matrix(1 0 0 1 487.5532 116.2092)" class="st6 st9 st10"><?php echo $telefono; ?></text>
    <g>
    	<path class="st5" d="M158.02,170.24v1.29c-0.4-0.29-0.76-0.43-1.09-0.43c-0.35,0-0.63,0.12-0.85,0.37
    		c-0.22,0.23-0.33,0.54-0.33,0.93c0,0.34,0.08,0.64,0.23,0.88c0.08,0.13,0.21,0.3,0.4,0.51c0.18,0.21,0.42,0.46,0.71,0.75
    		c0.54,0.55,0.9,1.02,1.1,1.42c0.19,0.38,0.29,0.86,0.29,1.42c0,0.76-0.21,1.38-0.64,1.87c-0.43,0.48-0.98,0.72-1.64,0.72
    		c-0.56,0-1.04-0.16-1.44-0.46v-1.31c0.47,0.34,0.9,0.51,1.28,0.51c0.36,0,0.64-0.12,0.84-0.36s0.3-0.56,0.3-0.97
    		c0-0.36-0.08-0.68-0.23-0.96c-0.08-0.14-0.19-0.29-0.34-0.47s-0.32-0.37-0.54-0.59c-0.33-0.33-0.61-0.62-0.83-0.88
    		s-0.38-0.48-0.49-0.67c-0.2-0.37-0.3-0.84-0.3-1.41c0-0.77,0.2-1.37,0.6-1.82c0.4-0.45,0.94-0.68,1.62-0.68
    		C157.14,169.9,157.59,170.01,158.02,170.24z"/>
    	<path class="st5" d="M165.35,175.17c0,1.73-0.19,2.96-0.58,3.69c-0.39,0.73-1.03,1.09-1.94,1.09c-0.95,0-1.62-0.39-2.01-1.17
    		c-0.39-0.77-0.58-2.13-0.58-4.08c0-1.74,0.19-2.98,0.57-3.7c0.39-0.73,1.04-1.09,1.96-1.09c0.82,0,1.43,0.28,1.83,0.84
    		c0.26,0.38,0.45,0.91,0.57,1.61C165.29,173,165.35,173.94,165.35,175.17z M163.97,175.31c0-1.7-0.08-2.82-0.23-3.38
    		c-0.15-0.56-0.46-0.84-0.93-0.84s-0.78,0.26-0.94,0.77c-0.15,0.52-0.23,1.55-0.23,3.11c0,1.43,0.08,2.43,0.24,2.98
    		c0.17,0.53,0.47,0.79,0.93,0.79c0.44,0,0.75-0.25,0.91-0.74C163.88,177.53,163.97,176.63,163.97,175.31z"/>
    	<path class="st5" d="M167.5,170.03h1.74c0.72,0,1.25,0.17,1.61,0.51c0.44,0.45,0.67,1.12,0.67,2.04c0,0.7-0.12,1.27-0.35,1.69
    		c-0.24,0.43-0.57,0.69-1.01,0.79l1.8,4.77h-1.34l-1.8-4.8v4.8h-1.32V170.03z M168.82,174.38c0.51,0,0.87-0.12,1.09-0.36
    		s0.32-0.64,0.32-1.2c0-0.3-0.02-0.57-0.07-0.78c-0.04-0.22-0.11-0.39-0.21-0.53c-0.09-0.13-0.22-0.23-0.37-0.3
    		c-0.15-0.06-0.33-0.09-0.54-0.09h-0.22V174.38z"/>
    	<path class="st5" d="M173.17,170.03h4.3v1.16h-1.48v8.65h-1.29v-8.65h-1.52V170.03z"/>
    	<path class="st5" d="M179.04,170.03h3.51v1.12h-2.19v3.1h1.94v1.12h-1.94v3.35h2.19v1.12h-3.51V170.03z"/>
    	<path class="st5" d="M189.52,175.17c0,1.73-0.19,2.96-0.58,3.69c-0.39,0.73-1.03,1.09-1.94,1.09c-0.95,0-1.62-0.39-2.01-1.17
    		c-0.39-0.77-0.58-2.13-0.58-4.08c0-1.74,0.19-2.98,0.57-3.7c0.39-0.73,1.04-1.09,1.96-1.09c0.82,0,1.43,0.28,1.83,0.84
    		c0.26,0.38,0.45,0.91,0.57,1.61C189.46,173,189.52,173.94,189.52,175.17z M188.14,175.31c0-1.7-0.08-2.82-0.23-3.38
    		c-0.15-0.56-0.46-0.84-0.93-0.84s-0.78,0.26-0.94,0.77c-0.15,0.52-0.23,1.55-0.23,3.11c0,1.43,0.08,2.43,0.24,2.98
    		c0.17,0.53,0.47,0.79,0.93,0.79c0.44,0,0.75-0.25,0.91-0.74C188.05,177.53,188.14,176.63,188.14,175.31z"/>
    	<path class="st5" d="M192.28,173.17c0.21,0,0.39,0.08,0.54,0.24c0.15,0.15,0.23,0.33,0.23,0.54c0,0.22-0.08,0.41-0.23,0.56
    		s-0.34,0.23-0.55,0.23c-0.22,0-0.41-0.08-0.56-0.23c-0.15-0.16-0.23-0.34-0.23-0.56c0-0.22,0.08-0.4,0.23-0.55
    		C191.87,173.25,192.06,173.17,192.28,173.17z M192.28,178.36c0.21,0,0.39,0.08,0.54,0.23c0.15,0.15,0.23,0.34,0.23,0.55
    		s-0.08,0.4-0.23,0.55c-0.16,0.15-0.34,0.22-0.55,0.22c-0.11,0-0.21-0.02-0.31-0.06c-0.09-0.04-0.18-0.09-0.25-0.17
    		c-0.07-0.07-0.13-0.15-0.17-0.25c-0.04-0.1-0.06-0.2-0.06-0.31c0-0.22,0.08-0.4,0.23-0.55
    		C191.87,178.44,192.06,178.36,192.28,178.36z"/>
    	<path class="st5" d="M199.15,170.03h2.23v9.8h-1.26v-8.68h-0.97V170.03z"/>
    	<path class="st5" d="M205.39,172.66h-1.26v-0.26c0-0.44,0.04-0.81,0.11-1.12c0.07-0.31,0.19-0.57,0.35-0.77
    		c0.16-0.2,0.36-0.35,0.61-0.45c0.25-0.1,0.54-0.14,0.88-0.14c0.72,0,1.24,0.2,1.57,0.61s0.5,1.05,0.5,1.94
    		c0,0.73-0.08,1.25-0.23,1.57c-0.15,0.33-0.43,0.57-0.86,0.74c0.46,0.16,0.77,0.4,0.95,0.73c0.17,0.33,0.26,0.85,0.26,1.57
    		c0,0.99-0.19,1.71-0.56,2.18s-0.95,0.7-1.74,0.7c-1.35,0-2.02-0.77-2.02-2.32v-0.1v-0.07c0-0.05,0-0.08,0.01-0.09h1.24
    		c0,0.07-0.01,0.13-0.01,0.19c0,0.05,0,0.1,0,0.13c0,0.33,0.07,0.6,0.22,0.8c0.15,0.2,0.35,0.3,0.6,0.3c0.17,0,0.31-0.03,0.42-0.1
    		c0.12-0.07,0.21-0.17,0.29-0.32c0.07-0.15,0.13-0.34,0.16-0.57s0.05-0.51,0.05-0.84c0-0.6-0.09-1.03-0.27-1.29
    		c-0.18-0.26-0.48-0.39-0.9-0.39c-0.05,0-0.1,0-0.15,0.01c-0.06,0.01-0.12,0.01-0.19,0.02v-1.14h0.18c0.51,0,0.86-0.11,1.04-0.33
    		c0.18-0.22,0.27-0.64,0.27-1.25c0-1.02-0.26-1.52-0.77-1.52c-0.51,0-0.76,0.43-0.76,1.3L205.39,172.66z"/>
    	<path class="st5" d="M214.88,169.05h1.02l-5.84,13.48h-1.03L214.88,169.05z"/>
    	<path class="st5" d="M221.26,175.01c0,1.76-0.17,3.03-0.51,3.81c-0.33,0.75-0.9,1.13-1.71,1.13s-1.38-0.38-1.71-1.14
    		c-0.33-0.74-0.5-2.03-0.5-3.88s0.17-3.14,0.5-3.88c0.33-0.76,0.9-1.14,1.71-1.14c0.74,0,1.29,0.33,1.65,1
    		C221.07,171.62,221.26,172.99,221.26,175.01z M219.92,175.01c0-1.48-0.06-2.5-0.19-3.07c-0.13-0.56-0.36-0.84-0.69-0.84
    		s-0.57,0.28-0.7,0.84c-0.13,0.56-0.19,1.56-0.19,3.01s0.06,2.46,0.19,3.02c0.13,0.56,0.36,0.84,0.7,0.84
    		c0.33,0,0.56-0.28,0.69-0.83C219.85,177.45,219.92,176.46,219.92,175.01z"/>
    	<path class="st5" d="M224.55,172.66h-1.26v-0.26c0-0.44,0.04-0.81,0.11-1.12c0.07-0.31,0.19-0.57,0.35-0.77
    		c0.16-0.2,0.36-0.35,0.61-0.45c0.25-0.1,0.54-0.14,0.88-0.14c0.72,0,1.24,0.2,1.57,0.61s0.5,1.05,0.5,1.94
    		c0,0.73-0.08,1.25-0.23,1.57c-0.15,0.33-0.43,0.57-0.86,0.74c0.46,0.16,0.77,0.4,0.95,0.73c0.17,0.33,0.26,0.85,0.26,1.57
    		c0,0.99-0.19,1.71-0.56,2.18s-0.95,0.7-1.74,0.7c-1.35,0-2.02-0.77-2.02-2.32v-0.1v-0.07c0-0.05,0-0.08,0.01-0.09h1.24
    		c0,0.07-0.01,0.13-0.01,0.19c0,0.05,0,0.1,0,0.13c0,0.33,0.07,0.6,0.22,0.8c0.15,0.2,0.35,0.3,0.6,0.3c0.17,0,0.31-0.03,0.42-0.1
    		c0.12-0.07,0.21-0.17,0.29-0.32c0.07-0.15,0.13-0.34,0.16-0.57s0.05-0.51,0.05-0.84c0-0.6-0.09-1.03-0.27-1.29
    		c-0.18-0.26-0.48-0.39-0.9-0.39c-0.05,0-0.1,0-0.15,0.01c-0.06,0.01-0.12,0.01-0.19,0.02v-1.14h0.18c0.51,0,0.86-0.11,1.04-0.33
    		c0.18-0.22,0.27-0.64,0.27-1.25c0-1.02-0.26-1.52-0.77-1.52c-0.51,0-0.76,0.43-0.76,1.3L224.55,172.66z"/>
    	<path class="st5" d="M234.03,169.05h1.02l-5.84,13.48h-1.03L234.03,169.05z"/>
    	<path class="st5" d="M237.43,173.22h-1.29l-0.01-0.39c0-1.07,0.16-1.82,0.48-2.26c0.33-0.44,0.87-0.66,1.64-0.66
    		c1.44,0,2.16,0.8,2.16,2.4c0,1.08-0.54,2.63-1.62,4.67l-0.78,1.47c0,0.01-0.02,0.03-0.04,0.08c-0.02,0.04-0.05,0.1-0.09,0.18h2.42
    		v1.13H236c0.07-0.16,0.22-0.48,0.45-0.96c0.23-0.48,0.54-1.12,0.93-1.94c0.33-0.71,0.61-1.31,0.84-1.81
    		c0.22-0.5,0.39-0.9,0.51-1.22c0.23-0.63,0.34-1.18,0.34-1.64c0-0.81-0.28-1.22-0.84-1.22c-0.54,0-0.81,0.5-0.81,1.51l0.01,0.56
    		L237.43,173.22z"/>
    	<path class="st5" d="M246.65,175.01c0,1.76-0.17,3.03-0.51,3.81c-0.33,0.75-0.9,1.13-1.71,1.13s-1.38-0.38-1.71-1.14
    		c-0.33-0.74-0.5-2.03-0.5-3.88s0.17-3.14,0.5-3.88c0.33-0.76,0.9-1.14,1.71-1.14c0.74,0,1.29,0.33,1.65,1
    		C246.46,171.62,246.65,172.99,246.65,175.01z M245.3,175.01c0-1.48-0.06-2.5-0.19-3.07c-0.13-0.56-0.36-0.84-0.69-0.84
    		s-0.57,0.28-0.7,0.84c-0.13,0.56-0.19,1.56-0.19,3.01s0.06,2.46,0.19,3.02c0.13,0.56,0.36,0.84,0.7,0.84
    		c0.33,0,0.56-0.28,0.69-0.83C245.24,177.45,245.3,176.46,245.3,175.01z"/>
    	<path class="st5" d="M249.89,173.22h-1.29l-0.01-0.39c0-1.07,0.16-1.82,0.48-2.26c0.33-0.44,0.87-0.66,1.64-0.66
    		c1.44,0,2.16,0.8,2.16,2.4c0,1.08-0.54,2.63-1.62,4.67l-0.78,1.47c0,0.01-0.02,0.03-0.04,0.08c-0.02,0.04-0.05,0.1-0.09,0.18h2.42
    		v1.13h-4.3c0.07-0.16,0.22-0.48,0.45-0.96c0.23-0.48,0.54-1.12,0.93-1.94c0.33-0.71,0.61-1.31,0.84-1.81
    		c0.22-0.5,0.39-0.9,0.51-1.22c0.23-0.63,0.34-1.18,0.34-1.64c0-0.81-0.28-1.22-0.84-1.22c-0.54,0-0.81,0.5-0.81,1.51l0.01,0.56
    		L249.89,173.22z"/>
    	<path class="st5" d="M254.94,170.03h2.23v9.8h-1.26v-8.68h-0.97V170.03z"/>
    </g>
    </svg>
  </body>
</html>
