﻿const BING_AUTOSEARCH = {
    elements: {
        button: {
            start: document.getElementById("btn-start"),
            stop: document.getElementById("btn-stop")
        },
        select: {
            limit: document.getElementById("slc-limit"),
            interval: document.getElementById("slc-interval"),
            multitab: document.getElementById("slc-multitab"),
        },
        span: {
            progress: document.getElementById("span-progress"),
        },
        div: {
            settings: document.getElementById("div-settings"),
            timer: document.getElementById("div-timer"),
            bing: document.getElementById("div-bing")
        }
    },
    cookies: {
        set: (name, value, expires) => {
            try {
                let d = new Date();
                d.setTime(d.getTime() + (expires * 24 * 60 * 60 * 1000));

                let cookie = `${name}=${value};expires=${d.toUTCString()};path=/`;

                document.cookie = cookie;
            }
            catch (e) { }
        },
        get: (name) => {
            let value = null;

            try {
                let cookies = document.cookie.split(';');

                cookies.forEach((cookie) => {
                    if ((cookie + "=").trim().indexOf(name) == 0)
                        value = cookie.substring(name.length + 2, cookie.length);
                });
            }
            catch (e) { }

            return { name, value };
        },
        load: () => {
            let modal_help = new bootstrap.Modal(document.getElementById('modal-help'), {});

            let _need_help = BING_AUTOSEARCH.cookies.get("_need_help");
            let _multitab_mode = BING_AUTOSEARCH.cookies.get("_multitab_mode");
            let _search_interval = BING_AUTOSEARCH.cookies.get("_search_interval");
            let _search_limit = BING_AUTOSEARCH.cookies.get("_search_limit");

            if (!_need_help.value) {
                modal_help.show();

                BING_AUTOSEARCH.cookies.set("_need_help", BING_AUTOSEARCH.search.multitab.toString(), 365);
            }

            if (!_search_interval.value) {
                modal_help.show();

                BING_AUTOSEARCH.cookies.set("_search_interval", BING_AUTOSEARCH.search.interval.toString(), 365);
            }
            else {
                BING_AUTOSEARCH.elements.select.interval.value = BING_AUTOSEARCH.search.interval = parseInt(_search_interval.value.toString());
            }

            if (!_search_limit.value) {
                modal_help.show();

                BING_AUTOSEARCH.cookies.set("_search_limit", BING_AUTOSEARCH.search.limit.toString(), 365);
            }
            else {
                BING_AUTOSEARCH.elements.select.limit.value = BING_AUTOSEARCH.search.limit = parseInt(_search_limit.value.toString());
            }

            if (!_multitab_mode.value) {
                (function (a) {
                    if ((/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))))
                        BING_AUTOSEARCH.elements.select.multitab.value = "true";
                })(navigator.userAgent || navigator.vendor || window.opera);

                BING_AUTOSEARCH.cookies.set("_multitab_mode", BING_AUTOSEARCH.elements.select.multitab.value, 365);
            }
            else {
                BING_AUTOSEARCH.elements.select.multitab.value = _multitab_mode.value;
                BING_AUTOSEARCH.search.multitab = (_multitab_mode.value === "true");
            }
        }
    },
    search: {
        limit: 35,
        interval: 10000,
        multitab: false,
        engine: {
            terms: {
                lists: [
                    ["Ancestors: The Humankind Odyssey", "Angry Birds 2", "Angry Birds Blast!", "Angry Birds Dream Blast", "Angry Birds Epic", "Angry Birds Evolution", "Angry Birds FPS: First Person Slingshot", "Angry Birds Fight!", "Angry Birds Friends", "Angry Birds Go!", "Angry Birds Goal!", "Angry Birds Match", "Angry Birds Rio", "Angry Birds Seasons", "Angry Birds Space", "Angry Birds Stella", "Angry Birds Trilogy", "Angry Birds VR: Isle of Pigs", "Angry Birds: Action!", "Angry Birds: Star Wars", "Angry Birds: Star Wars II", "Angry Birds: Stella POP!", "Angry Birds: Transformers", "Animal Crossing", "Animal Crossing (Working Title)", "Animal Crossing Calculator", "Animal Crossing Clock", "Animal Crossing Plaza", "Animal Crossing: Amiibo Festival", "Animal Crossing: City Folk", "Animal Crossing: Happy Home Designer", "Animal Crossing: New Leaf", "Animal Crossing: Pocket Camp", "Animal Crossing: Wild World", "Anno 1800", "Anno 2070", "Anno 2205", "Apex Legends", "ArmA II", "ArmA II: Free", "ArmA II: Operation Arrowhead", "ArmA II: Reinforcements", "ArmA Mobile Ops", "ArmA Tactics", "ArmA: Cold War Assault", "ArmA: Combat Operations", "ArmA: Queen's Gambit", "Arma 3", "Asphalt", "Asphalt 3: Street Rules", "Asphalt 3D", "Asphalt 4: Elite Racing", "Asphalt 5", "Asphalt 6: Adrenaline", "Asphalt 7: Heat", "Asphalt 8", "Asphalt 8: Airborne", "Asphalt 9: Legends ", "Asphalt Overdrive", "Asphalt Street Storm Racing", "Asphalt Xtreme", "Asphalt: Injection", "Asphalt: Urban GT", "Asphalt: Urban GT 2", "Assassin's Creed", "Assassin's Creed Chronicles", "Assassin's Creed Chronicles: China", "Assassin's Creed Chronicles: India", "Assassin's Creed Chronicles: Russia", "Assassin's Creed II", "Assassin's Creed II Multiplayer", "Assassin's Creed II: Discovery", "Assassin's Creed III", "Assassin's Creed III: Liberation", "Assassin's Creed IV: Black Flag", "Assassin's Creed IV: Black Flag/Assassin's Creed Rogue", "Assassin's Creed Identity", "Assassin's Creed Liberation HD", "Assassin's Creed Odyssey", "Assassin's Creed Origins", "Assassin's Creed Rearmed", "Assassin's Creed Recollection", "Assassin's Creed Syndicate", "Assassin's Creed Unity", "Assassin's Creed Valhalla", "Assassin's Creed Vita (working title)", "Assassin's Creed: Alta\xefr's Chronicles", "Assassin's Creed: Bloodlines", "Assassin's Creed: Brotherhood", "Assassin's Creed: Ezio Trilogy", "Assassin's Creed: Freedom Cry", "Assassin's Creed: Heritage Collection", "Assassin's Creed: Lost Legacy", "Assassin's Creed: Pirates", "Assassin's Creed: Project Legacy", "Assassin's Creed: Rebellion", "Assassin's Creed: Revelations", "Assassin's Creed: Rising Phoenix", "Assassin's Creed: Rogue", "Assassin's Creed: The Americas Collection", "Assassin's Creed: The Ezio Collection", "Assassin's Creed: Utopia", "Automobilista", "Automobilista 2", "Back 4 Blood", "Batman: Arkham Asylum", "Batman: Arkham City", "Batman: Arkham Knight", "Batman: Arkham Origins", "Batman: Arkham Origins Blackgate", "Batman: Arkham Underworld", "Batman: Arkham VR", "Batman: Chaos in Gotham", "Batman: Dark Tomorrow", "Batman: Gotham City Racer", "Batman: Justice Unbalanced", "Batman: Partners in Peril", "Batman: Return of the Joker", "Batman: Return to Arkham", "Batman: Rise of Sin Tzu", "Batman: The Animated Series", "Batman: The Brave and the Bold: The Videogame", "Batman: The Caped Crusader", "Batman: The Dark Knight", "Batman: The Enemy Within - The Telltale Series", "Batman: The Movie", "Batman: The Video Game", "Batman: Toxic Chill", "Batman: Vengeance", "Battalion 1944", "Battlefield (2021)", "Battlefield 1", "Battlefield 1942", "Battlefield 1942: Secret Weapons of WWII", "Battlefield 1942: The Road to Rome", "Battlefield 1943", "Battlefield 2", "Battlefield 2142", "Battlefield 2142: Booster Pack - Northern Strike", "Battlefield 2: Armored Fury", "Battlefield 2: Euro Force", "Battlefield 2: Modern Combat", "Battlefield 2: Special Forces", "Battlefield 3", "Battlefield 3: Aftershock", "Battlefield 4", "Battlefield Hardline", "Battlefield V", "Battlefield Vietnam", "Battlefield: Bad Company", "Battlefield: Bad Company 2", "Beat Cop", "BioShock", "BioShock 2", "BioShock 4", "BioShock Infinite", "BioShock Infinite: Industrial Revolution", "BioShock: The Collection", "Black", "Bomberman", "Bomberman '93", "Bomberman '94", "Bomberman 2", "Bomberman 3DS", "Bomberman 64", "Bomberman 64: The Second Attack", "Bomberman B-Daman", "Bomberman Blast", "Bomberman Blitz", "Bomberman Collection", "Bomberman Collection Vol. 2", "Bomberman Fantasy Race", "Bomberman GB", "Bomberman GB3", "Bomberman Generation", "Bomberman Hardball", "Bomberman Hero", "Bomberman II", "Bomberman Jetters", "Bomberman Jetters: Densetsu no Bomberman", "Bomberman Jetters: Game Collection", "Bomberman Kart", "Bomberman Kart DX", "Bomberman Land", "Bomberman Land 2", "Bomberman Land 3", "Bomberman Land Touch!", "Bomberman Land Touch! 2", "Bomberman Live", "Bomberman Live: Battlefest", "Bomberman Max", "Bomberman Max 2", "Bomberman Online", "Bomberman PSP", "Bomberman Quest", "Bomberman Selection", "Bomberman Story DS", "Bomberman Touch: The Legend of Mystic Bomb", "Bomberman Tournament", "Bomberman Ultra", "Bomberman Wars", "Bomberman World", "Bomberman v1.8", "Bomberman: Act Zero", "Bomberman: Bakufuu Sentai Bomberman", "Bomberman: Party Edition", "Bomberman: Users Battle", "Brawlhalla", "Brothers in Arms 2: Global Front", "Brothers in Arms DS", "Brothers in Arms: D-Day", "Brothers in Arms: Double Time", "Brothers in Arms: Earned in Blood", "Brothers in Arms: Hell's Highway", "Brothers in Arms: Hour of Heroes", "Brothers in Arms: Road to Hill 30", "Burnout", "Burnout 2: Point of Impact", "Burnout 3: Takedown", "Burnout CRASH!", "Burnout Dominator", "Burnout Legends", "Burnout Paradise", "Burnout Revenge", "Burnout: Championship Drag Racing", "Bus & Cable-Car Simulator", "Bus Driver", "Bus Driver Simulator 2018", "Bus Mechanic Simulator", "Bus Simulator 16", "Bus Simulator 18", "Bus Simulator 2012", "Bus Simulator 21", "Bus Tycoon ND", "Cadillacs and Dinosaurs", "Cadillacs and Dinosaurs: The Second Cataclysm", "Call of Duty", "Call of Duty 2", "Call of Duty 2: Big Red One", "Call of Duty 3", "Call of Duty 4: Modern Warfare", "Call of Duty Action-Adventure", "Call of Duty Online", "Call of Duty: Advanced Warfare", "Call of Duty: Black Ops", "Call of Duty: Black Ops 4", "Call of Duty: Black Ops Declassified", "Call of Duty: Black Ops II", "Call of Duty: Black Ops III", "Call of Duty: Black Ops Zombies", "Call of Duty: Finest Hour", "Call of Duty: Ghosts", "Call of Duty: Heroes", "Call of Duty: Infinite Warfare", "Call of Duty: Infinite Warfare - Jackal Assault", "Call of Duty: Mobile", "Call of Duty: Modern Warfare", "Call of Duty: Modern Warfare 3", "Call of Duty: Modern Warfare Reflex Edition", "Call of Duty: Modern Warfare Remastered", "Call of Duty: Modern Warfare: Mobilized", "Call of Duty: Roads to Victory", "Call of Duty: Strike Team", "Call of Duty: United Offensive", "Call of Duty: Warzone", "Call of Duty: Warzone 2.0", "Call of Duty: WWII", "Call of Duty: World at War", "Call of Duty: World at War Final Fronts", "Call of Duty: World at War: Zombies", "Call of Juarez", "Call of Juarez: Bound in Blood", "Call of Juarez: Gunslinger", "Call of Juarez: The Cartel", "Capcom Arcade Cabinet", "Capcom Arcade Hits Volume 1", "Capcom Arcade Hits Volume 2", "Capcom Arcade Hits Volume 3", "Capcom Beat 'Em Up Bundle", "Capcom vs. SNK 2: Mark of the Millennium", "Capcom vs. SNK: Millennium Fight 2000", "Capcom vs. SNK: Millennium Fight 2000 Pro", "Capcom's MVP Football", "Capcom's Soccer Shootout", "Car Mechanic Simulator 2014", "Car Mechanic Simulator 2015", "Car Mechanic Simulator 2018", "Car Mechanic Simulator VR", "Carmageddon", "Carmageddon 64", "Carmageddon II: Carpocalypse Now", "Carmageddon Splat Pack", "Carmageddon TDR 2000", "Carmageddon: Max Damage", "Carmageddon: Reincarnation", "Chuck Rock", "Chuck Rock II: Son of Chuck", "Clash of Clans", "Combat Arms", "Company of Heroes", "Company of Heroes 2", "Company of Heroes 2: Ardennes Assault", "Company of Heroes 2: The Western Front Armies", "Company of Heroes Online", "Company of Heroes: Opposing Fronts", "Company of Heroes: Tales of Valor", "Contra", "Contra 4", "Contra Advance: The Alien Wars EX", "Contra Anniversary Collection", "Contra Evolution", "Contra Force", "Contra III: The Alien Wars", "Contra ReBirth", "Contra Return", "Contra: Hard Corps", "Contra: Legacy of War", "Contra: Rogue Corps", "Contra: Shattered Soldier", "Counter-Strike 2D", "Counter-Strike Neo", "Counter-Strike: Condition Zero", "Counter-Strike: Global Offensive", "Counter-Strike: Source", "Cuphead", "Cuphead & The Delicious Last Course", "DiRT", "DiRT 2", "DiRT 3", "DiRT 4", "DiRT Rally", "Diablo", "Diablo II", "Diablo II: Lord of Destruction", "Diablo III: Reaper of Souls", "Diablo IV", "Diablo: Hellfire", "Diablo: Immortal", "Don't Starve", "Don't Starve Together", "Donkey Kong", "Donkey Kong 3", "Donkey Kong 3: Dai Gyakushuu", "Donkey Kong 64", "Donkey Kong Classics", "Donkey Kong Country", "Donkey Kong Country 2: Diddy's Kong Quest", "Donkey Kong Country 3: Dixie Kong's Double Trouble!", "Donkey Kong Country Returns", "Donkey Kong Country: Tropical Freeze", "Donkey Kong Jr.", "Donkey Kong Jr. Math", "Donkey Kong Jr./Jr. Sansu Lesson", "Donkey Kong Land", "Donkey Kong Land 2", "Donkey Kong Land III", "Donkey Kong: Banana Kingdom", "Donkey Kong: Barrel Blast", "Donkey Kong: Jungle Beat", "Dragon Ball Z: Budokai Tenkaichi", "Dragon Ball Z: Budokai Tenkaichi 2", "Dragon Ball Z: Budokai Tenkaichi 3", "DuckTales", "DuckTales 2", "DuckTales: Remastered", "Ducktales: Scrooge's Loot", "Euro Truck Simulator 2", "Elden Ring", "F1 2000", "F1 2001", "F1 2002", "F1 2010", "F1 2011", "F1 2012", "F1 2013", "F1 2014", "F1 2015", "F1 2016", "F1 2017", "F1 2018", "F1 2019", "F1 2020", "FIFA 06: Road To FIFA World Cup", "FIFA 10", "FIFA 11", "FIFA 12", "FIFA 14", "FIFA 15", "FIFA 16", "FIFA 17", "FIFA 18", "FIFA 19", "FIFA 20", "FIFA 2000", "FIFA 2001", "FIFA 21", "FIFA 98: Road to World Cup", "FIFA 99", "FIFA International Soccer", "FIFA Manager 06", "FIFA Manager 07", "FIFA Manager 07: Extra Time", "FIFA Manager 08", "FIFA Manager 09", "FIFA Manager 10", "FIFA Manager 11", "FIFA Manager 12", "FIFA Manager 13", "FIFA Mobile", "FIFA Online 2", "FIFA Online 3", "FIFA Online 4", "FIFA Soccer 06", "FIFA Soccer 07", "FIFA Soccer 08", "FIFA Soccer 09", "FIFA Soccer 13", "FIFA Soccer 2002", "FIFA Soccer 2003", "FIFA Soccer 2004", "FIFA Soccer 2005", "FIFA Soccer 64", "FIFA Soccer 95", "FIFA Soccer 96", "FIFA Soccer 97", "FIFA Soccer Manager", "FIFA Soccer: Prime Stars", "FIFA Street", "FIFA Street 2", "FIFA Street 3", "Fall Guys", "Fallout", "Fallout 2", "Fallout 3", "Fallout 4", "Fallout 76", "Fallout Online", "Fallout Shelter", "Fallout Tactics: Brotherhood of Steel", "Fallout Trilogy", "Fallout: Brotherhood of Steel", "Fallout: New Vegas", "Far Cry", "Far Cry 2", "Far Cry 3", "Far Cry 3: Blood Dragon", "Far Cry 4", "Far Cry 4 Arcade Poker", "Far Cry 4 Arena Master", "Far Cry 5", "Far Cry 6", "Far Cry: Instincts", "Far Cry: Instincts - Evolution", "Far Cry: Instincts - Predator", "Far Cry: New Dawn", "Far Cry: Primal", "Far Cry: Vengeance", "Farming Simulator", "Farming Simulator 14", "Farming Simulator 15", "Farming Simulator 16", "Farming Simulator 17", "Farming Simulator 18", "Farming Simulator 19", "Farming Simulator 2008", "Farming Simulator 2009", "Farming Simulator 2011", "Farming Simulator 2012", "Farming Simulator 2013", "Final Fight", "Final Fight 2", "Final Fight 3", "Final Fight CD", "Final Fight One", "Final Fight Revenge", "Final Fight: Double Impact", "Final Fight: Streetwise", "Football Manager 2", "Football Manager 2008", "Football Manager 2009", "Football Manager 2010", "Football Manager 2011", "Football Manager 2012", "Football Manager 2013", "Football Manager 2014", "Football Manager 2015", "Football Manager 2016", "Football Manager 2017", "Football Manager 2018", "Football Manager 2019", "Football Manager 2020", "Football Manager Handheld", "Football Manager Handheld 2010", "Football Manager Handheld 2013", "Football Manager Handheld 2014", "Football Manager Live", "Football Manager Mobile 2016", "Fortnite", "Forza Horizon", "Forza Horizon 2", "Forza Horizon 2 Presents Fast & Furious", "Forza Horizon 3", "Forza Horizon 4", "Forza Horizon 4 (working title)", "Forza Motorsport", "Forza Motorsport 2", "Forza Motorsport 3", "Forza Motorsport 4", "Forza Motorsport 5", "Forza Motorsport 6", "Forza Motorsport 6: Apex", "Forza Motorsport 7", "Gangstar 2: Kings of L.A", "Gangstar New Orleans", "Gangstar Rio: City of Saints", "Gangstar Vegas", "Gangstar: West Coast Hustle", "Gears of War", "Gears of War 2", "Gears of War 3", "Gears of War 4", "Gears of War: Judgment", "Gears of War: Ultimate Edition", "Ghost of Tsushima", "God of War", "God of War Collection", "God of War II", "God of War III", "God of War Saga", "God of War: Ascension", "God of War: Chains of Olympus", "God of War: Ghost of Sparta", "God of War: Origins Collection", "Gran Turismo", "Gran Turismo 2", "Gran Turismo 3 A-Spec", "Gran Turismo 4", "Gran Turismo 4: Prologue", "Gran Turismo 5", "Gran Turismo 5 Prologue", "Gran Turismo 5 Prologue Spec III", "Gran Turismo 6", "Gran Turismo 7", "Gran Turismo Concept: 2001 Tokyo", "Gran Turismo Concept: 2002 Tokyo-Geneva", "Gran Turismo Concept: 2002 Tokyo-Seoul", "Gran Turismo HD", "Gran Turismo Sport", "Grand Theft Auto", "Grand Theft Auto 2", "Grand Theft Auto Advance", "Grand Theft Auto III", "Grand Theft Auto IV", "Grand Theft Auto V", "Grand Theft Auto: Chinatown Wars", "Grand Theft Auto: Episodes from Liberty City", "Grand Theft Auto: Liberty City Stories", "Grand Theft Auto: London 1961", "Grand Theft Auto: London 1969", "Grand Theft Auto: San Andreas", "Grand Theft Auto: Vice City", "Grand Theft Auto: Vice City Stories", "Grand Theft Auto: iFruit", "Guitar Hero", "Guitar Hero 5", "Guitar Hero Arcade", "Guitar Hero Encore: Rocks the 80s", "Guitar Hero II", "Guitar Hero III: Legends of Rock", "Guitar Hero Live", "Guitar Hero On Tour: Decades", "Guitar Hero On Tour: Modern Hits", "Guitar Hero World Tour", "Guitar Hero: Aerosmith", "Guitar Hero: Metallica", "Guitar Hero: On Tour", "Guitar Hero: Smash Hits", "Guitar Hero: Van Halen", "Guitar Hero: Warriors of Rock", "Guns, Gore & Cannoli", "Guns, Gore and Cannoli 2", "Halo 2", "Halo 2600", "Halo 3", "Halo 3: ODST", "Halo 4", "Halo 4: King of the Hill Fueled by Mountain Dew", "Halo 5: Guardians", "Halo Infinite", "Halo Online", "Halo Wars", "Halo Wars 2", "Halo Zero", "Halo: Combat Evolved", "Halo: Combat Evolved Anniversary", "Halo: Fireteam Raven", "Halo: Reach", "Halo: Spartan Assault", "Halo: Spartan Strike", "Halo: The Master Chief Collection", "Hitman 2", "Hitman 2 (working title)", "Hitman 2: Silent Assassin", "Hitman Go", "Hitman HD Trilogy", "Hitman: Absolution", "Hitman: Blood Money", "Hitman: Codename 47", "Hitman: Contracts", "Hitman: Sniper", "Hitman: Sniper Challenge", "Homefront", "Homefront: The Revolution", "Horizon Forbidden West", "Horizon Zero Dawn", "Hot Lava", "Hyper Scape", "I Am Bread", "Insurgency", "Insurgency 2", "Insurgency: Sandstorm", "International Superstar Soccer", "International Superstar Soccer '98", "International Superstar Soccer 2", "International Superstar Soccer 2000", "International Superstar Soccer 3", "International Superstar Soccer 64", "International Superstar Soccer Advance", "International Superstar Soccer Deluxe", "Just Cause", "Just Cause 2", "Just Cause 3", "Just Cause 4", "Just Dance", "Just Dance 2", "Just Dance 2014", "Just Dance 2015", "Just Dance 2016", "Just Dance 2017", "Just Dance 2018", "Just Dance 2019", "Just Dance 2020", "Just Dance 2021", "Just Dance 3", "Just Dance 4", "Just Dance Disney Party", "Just Dance Disney Party 2", "Just Dance Kids", "Just Dance Kids 2", "Just Dance Kids 2014", "Just Dance Now", "Just Dance Summer Party", "Just Dance Wii U", "Just Dance: Greatest Hits", "Kingdom Hearts", "Kingdom Hearts 358/2 Days", "Kingdom Hearts 3D: Dream Drop Distance", "Kingdom Hearts Dark Road", "Kingdom Hearts HD 1.5 ReMIX", "Kingdom Hearts HD II.5 Remix", "Kingdom Hearts HD II.8: Final Chapter Prologue", "Kingdom Hearts II", "Kingdom Hearts III", "Kingdom Hearts Melody of Memory", "Kingdom Hearts Re:Chain of Memories", "Kingdom Hearts Re:coded", "Kingdom Hearts Union χ[Cross]", "Kingdom Hearts - The Story So Far", "Kingdom Hearts: All In One Package", "Kingdom Hearts: Birth by Sleep", "Kingdom Hearts: Chain of Memories", "L.A. Noire", "L.A. Noire: The VR Case Files", "Lara Croft Tomb Raider: Anniversary", "Lara Croft Tomb Raider: Curse of the Sword", "Lara Croft Tomb Raider: Legend", "Lara Croft Tomb Raider: The Action Adventure", "Lara Croft Tomb Raider: The Angel of Darkness", "Lara Croft Tomb Raider: The Prophecy", "Lara Croft and the Guardian of Light", "Lara Croft and the Temple of Osiris", "Lara Croft: Go", "Lara Croft: Reflections", "Lara Croft: Relic Run", "League of Legends", "League of Legends: Wild Rift", "Left 4 Dead", "Left 4 Dead 2", "Left 4 Dead: Survivors", "Little Nightmares", "Little Nightmares II", "Little Ninja Brothers", "Madden NFL '94", "Madden NFL '95", "Madden NFL 06", "Madden NFL 07", "Madden NFL 08", "Madden NFL 09", "Madden NFL 09 All-Play", "Madden NFL 10", "Madden NFL 11", "Madden NFL 12", "Madden NFL 13", "Madden NFL 15", "Madden NFL 16", "Madden NFL 17", "Madden NFL 18", "Madden NFL 19", "Madden NFL 20", "Madden NFL 2000", "Madden NFL 2001", "Madden NFL 2002", "Madden NFL 2003", "Madden NFL 2004", "Madden NFL 2005", "Madden NFL 21", "Madden NFL 25", "Madden NFL 96", "Madden NFL 97", "Madden NFL 98", "Madden NFL 99", "Madden NFL Arcade", "Madden NFL Football", "Madden NFL Mobile", "Mafia", "Mafia II", "Mafia III", "Mario & Luigi: Bowser's Inside Story", "Mario & Luigi: Dream Team", "Mario & Luigi: Paper Jam", "Mario & Luigi: Partners in Time", "Mario & Luigi: Superstar Saga", "Mario & Luigi: Superstar Saga + Bowser's Minions", "Mario & Sonic at the London 2012 Olympic Games", "Mario & Sonic at the Olympic Games", "Mario & Sonic at the Olympic Winter Games", "Mario & Sonic at the Rio 2016 Olympic Games", "Mario & Sonic at the Sochi 2014 Winter Olympic Games", "Mario & Sonic at the Tokyo 2020 Olympic Games", "Mario & Wario", "Mario + Rabbids Kingdom Battle", "Mario Bros.", "Mario Bros. II", "Mario Bros. Special", "Mario Golf", "Mario Golf: Advance Tour", "Mario Golf: Toadstool Tour", "Mario Golf: World Tour", "Mario Hoops 3 on 3", "Mario Kart 64", "Mario Kart 7", "Mario Kart 8", "Mario Kart Arcade GP", "Mario Kart Arcade GP 2", "Mario Kart Arcade GP VR", "Mario Kart DS", "Mario Kart Live: Home Circuit", "Mario Kart Tour", "Mario Kart Wii", "Mario Kart Wii U (Working Title)", "Mario Kart: Arcade GP DX", "Mario Kart: Double Dash!!", "Mario Kart: Super Circuit", "Mario Lemieux Hockey", "Mario Paint", "Mario Party", "Mario Party 10", "Mario Party 2", "Mario Party 3", "Mario Party 4", "Mario Party 5", "Mario Party 6", "Mario Party 7", "Mario Party 8", "Mario Party 9", "Mario Party Advance", "Mario Party DS", "Mario Party Fushigi no Challenge World", "Mario Party Fushigi no Korokoro Catcher", "Mario Party-e", "Mario Party: Island Tour", "Mario Party: Star Rush", "Mario Party: The Top 100", "Mario Pinball Land", "Mario Power Tennis", "Mario Roulette", "Mario Sports Mix", "Mario Sports Superstars", "Mario Strikers Charged", "Mario Super Sluggers", "Mario Superstar Baseball", "Mario Teaches Typing", "Mario Teaches Typing 2", "Mario Tennis", "Mario Tennis Aces", "Mario Tennis Open", "Mario Tennis: Power Tour", "Mario Tennis: Ultra Smash", "Mario and Donkey Kong: Minis on the Move", "Mario is Missing!", "Mario no Photopi", "Mario vs. Donkey Kong", "Mario vs. Donkey Kong 2: March of the Minis", "Mario vs. Donkey Kong: Mini-Land Mayhem", "Mario vs. Donkey Kong: Minis March Again!", "Mario vs. Donkey Kong: Tipping Stars", "Mario's Brewery", "Mario's Cement Factory", "Mario's Early Years: Fun With Letters", "Mario's Early Years: Fun with Numbers", "Mario's Early Years: Preschool Fun", "Mario's Game Gallery", "Mario's Picross", "Mario's Super Picross", "Mario's Tennis", "Mario's Time Machine", "Marvel vs. Capcom 2: New Age of Heroes", "Marvel vs. Capcom 3: Fate of Two Worlds", "Marvel vs. Capcom Infinite", "Marvel vs. Capcom Origins", "Marvel vs. Capcom: Clash of Super Heroes", "Marvel's Spider-Man", "Marvel's Spider-Man: Miles Morales", "Mass Effect", "Mass Effect", "Mass Effect 2", "Mass Effect 3", "Mass Effect Datapad", "Mass Effect: Andromeda", "Mass Effect: Galaxy", "Mass Effect: Infiltrator", "Medal of Honor", "Medal of Honor Infiltrator", "Medal of Honor: Above and Beyond", "Medal of Honor: Airborne", "Medal of Honor: Allied Assault", "Medal of Honor: Allied Assault - Breakthrough", "Medal of Honor: Allied Assault - Spearhead", "Medal of Honor: European Assault", "Medal of Honor: Frontline", "Medal of Honor: Heroes", "Medal of Honor: Heroes 2", "Medal of Honor: Pacific Assault", "Medal of Honor: Rising Sun", "Medal of Honor: Underground", "Medal of Honor: Vanguard", "Medal of Honor: Warfighter", "Men of War", "Men of War II: Arena", "Men of War: Assault Squad", "Men of War: Assault Squad 2", "Men of War: Assault Squad 2 - Cold War", "Men of War: Call to Arms", "Men of War: Condemned Heroes", "Men of War: Vietnam", "Metal Slug", "Metal Slug 2: Super Vehicle - 001/II", "Metal Slug 3", "Metal Slug 4", "Metal Slug 5", "Metal Slug 6", "Metal Slug 7", "Metal Slug Advance", "Metal Slug Anthology", "Metal Slug Attack", "Metal Slug Defense", "Metal Slug Infinity", "Metal Slug Revolution", "Metal Slug XX", "Metal Slug Zero Online", "Metal Slug: 1st Mission", "Metal Slug: 2nd Mission", "Microsoft Flight Simulator", "Microsoft Flight Simulator (v1.0)", "Microsoft Flight Simulator (v2.0)", "Microsoft Flight Simulator (v3.0)", "Microsoft Flight Simulator (v4.0)", "Microsoft Flight Simulator (v5.0)", "Microsoft Flight Simulator 2000", "Microsoft Flight Simulator 2002", "Microsoft Flight Simulator 2004: A Century of Flight", "Microsoft Flight Simulator 98", "Microsoft Flight Simulator Aircraft & Scenery Designer", "Microsoft Flight Simulator X", "Microsoft Flight Simulator X: Acceleration", "Microsoft Flight Simulator for Windows 95", "Modern Combat 2: Black Pegasus", "Modern Combat 3: Fallen Nation", "Modern Combat 4: Zero Hour", "Modern Combat 5: Blackout", "Modern Combat Versus", "Modern Combat: Domination", "Modern Combat: Sandstorm", "Mortal Kombat", "Mortal Kombat 11", "Mortal Kombat 3", "Mortal Kombat 4", "Mortal Kombat Advance", "Mortal Kombat Arcade Kollection", "Mortal Kombat Gold", "Mortal Kombat II", "Mortal Kombat Mythologies: Sub-Zero", "Mortal Kombat Trilogy", "Mortal Kombat X", "Mortal Kombat X Mobile", "Mortal Kombat vs. DC Universe", "Mortal Kombat: Armageddon", "Mortal Kombat: Deadly Alliance", "Mortal Kombat: Deception", "Mortal Kombat: Shaolin Monks", "Mortal Kombat: Special Forces", "Mortal Kombat: Tournament Edition", "Mortal Kombat: Unchained", "MotoGP", "MotoGP '06", "MotoGP '07", "MotoGP 08", "MotoGP 09/10", "MotoGP 10/11", "MotoGP 14", "MotoGP 15", "MotoGP 17", "MotoGP 18", "MotoGP 19", "MotoGP 2", "MotoGP 20", "MotoGP13", "MotoGP3", "MotoGP4", "MotoGP: Ultimate Racing Technology", "MotoGP: Ultimate Racing Technology 3", "MultiVersus", "NBA '08", "NBA 06", "NBA 07", "NBA 09: The Inside", "NBA 10 The Inside", "NBA 2K", "NBA 2K Playgrounds 2", "NBA 2K1", "NBA 2K10", "NBA 2K10: Draft Combine", "NBA 2K11", "NBA 2K12", "NBA 2K13", "NBA 2K14", "NBA 2K15", "NBA 2K16", "NBA 2K17", "NBA 2K18", "NBA 2K19", "NBA 2K2", "NBA 2K20", "NBA 2K21", "NBA 2K3", "NBA 2K6", "NBA 2K7", "NBA 2K8", "NBA 2K9", "Naruto Gekitou Ninja Taisen 3", "Naruto Gekitou Ninja Taisen 4", "Naruto Gekitou Ninja Taisen Ex", "Naruto Konoha Senki", "Naruto Mobile", "Naruto Ninja Council 2 European Version", "Naruto Online", "Naruto RPG 2: Chidori vs. Rasengan", "Naruto Shippuden Clash Of Ninja Revolution 4", "Naruto Shippuden Ninja Destiny 2", "Naruto Shippuden Ultimate Ninja Heroes 3", "Naruto Shippuden: Clash of Ninja Revolution 3", "Naruto Shippuden: Dairansen! Kage Bunsen Emaki", "Naruto Shippuden: Dragon Blade Chronicles", "Naruto Shippuden: Kizuna Drive", "Naruto Shippuden: Narutimate Blazing", "Naruto Shippuden: Naruto vs. Sasuke", "Naruto Shippuden: Ninja Council 4", "Naruto Shippuden: Shinobi Rumble", "Naruto Shippuden: The New Era", "Naruto Shippuden: Ultimate Ninja 4", "Naruto Shippuden: Ultimate Ninja 5", "Naruto Shippuden: Ultimate Ninja Impact", "Naruto Shippuden: Ultimate Ninja Storm 2", "Naruto Shippuden: Ultimate Ninja Storm 3", "Naruto Shippuden: Ultimate Ninja Storm 3 Full Burst", "Naruto Shippuden: Ultimate Ninja Storm 4", "Naruto Shippuden: Ultimate Ninja Storm 4 - Road to Boruto", "Naruto Shippuden: Ultimate Ninja Storm Collection", "Naruto Shippuden: Ultimate Ninja Storm Generations", "Naruto Shippuden: Ultimate Ninja Storm Revolution", "Naruto Shippuuden: Gekitou Ninja Taisen! EX 2", "Naruto Shippuuden: Gekitou Ninja Taisen! EX 3", "Naruto Shippuuden: Narutimate Accel 3", "Naruto Shippūden: Gekitō Ninja Taisen! Special", "Naruto Shippūden: Legends: Akatsuki Rising", "Naruto Shippūden: Shinobi Retsuden 3", "Naruto to Boruto: Shinobi Striker", "Naruto x Boruto: Ninja Borutage", "Naruto: Clash of Ninja", "Naruto: Clash of Ninja 2", "Naruto: Clash of Ninja Revolution", "Naruto: Clash of Ninja Revolution 2", "Naruto: Konoha Ninpo Chou", "Naruto: Ninja Council", "Naruto: Ninja Council 2", "Naruto: Ninja Council 3", "Naruto: Ninja Destiny", "Naruto: Ninja Destiny II European Version", "Naruto: Ninja Masters", "Naruto: Path of the Ninja", "Naruto: Path of the Ninja 2", "Naruto: Powerful Shippuden", "Naruto: Rise of a Ninja", "Naruto: Shinobi no Sato no Jintori Kassen", "Naruto: Slugfest", "Naruto: The Broken Bond", "Naruto: Ultimate Ninja", "Naruto: Ultimate Ninja 2", "Naruto: Ultimate Ninja 3", "Naruto: Ultimate Ninja Heroes", "Naruto: Ultimate Ninja Heroes 2: Phantom Fortress", "Naruto: Ultimate Ninja Storm", "Naruto: Uzumaki Chronicles", "Naruto: Uzumaki Chronicles 2", "Need for Speed", "Need for Speed Edge", "Need for Speed GT", "Need for Speed Heat", "Need for Speed II", "Need for Speed III: Hot Pursuit", "Need for Speed Nitro", "Need for Speed Payback", "Need for Speed Rivals", "Need for Speed Underground", "Need for Speed Underground 2", "Need for Speed Underground: Rivals", "Need for Speed World", "Need for Speed: Carbon", "Need for Speed: Carbon - Own the City", "Need for Speed: High Stakes", "Need for Speed: Hot Pursuit", "Need for Speed: Hot Pursuit 2", "Need for Speed: Most Wanted", "Need for Speed: Most Wanted (2005)", "Need for Speed: Most Wanted 5-1-0", "Need for Speed: No Limits", "Need for Speed: Porsche Unleashed", "Need for Speed: ProStreet", "Need for Speed: SHIFT", "Need for Speed: The Run", "Need for Speed: Undercover", "Need for Speed: V-Rally", "Need for Speed: V-Rally 2", "OMSI: The Bus Simulator", "OMSI 2", "OmniBus", "PUBG: BATTLEGROUNDS", "Pac-Man", "Pac-Man & Galaga Dimensions", "Pac-Man + Tournaments", "Pac-Man 2", "Pac-Man 256", "Pac-Man 2: The New Adventures", "Pac-Man All-Stars", "Pac-Man Battle Royale", "Pac-Man Championship Edition DX", "Pac-Man Chomp Mania", "Pac-Man Collection", "Pac-Man Dash!", "Pac-Man Fever", "Pac-Man Friends", "Pac-Man Kart Rally", "Pac-Man Monsters", "Pac-Man Museum", "Pac-Man Party", "Pac-Man Party Royale", "Pac-Man Pinball", "Pac-Man Plus", "Pac-Man Pop!", "Pac-Man S", "Pac-Man Social", "Pac-Man Stories", "Pac-Man VR", "Pac-Man Vs.", "Pac-Man World", "Pac-Man World 2", "Pac-Man World 3", "Pac-Man World Rally", "Pac-Man and the Ghostly Adventures", "Pac-Man and the Ghostly Adventures 2", "Pac-Man: Adventures in Time", "Pac-Man: Championship Edition", "Pac-Man: Championship Edition 2", "Pac-Man: Championship Edition 2 + ARCADE GAME SERIES", "Pac-Man: Ralph Breaks the Maze", "Pac-Man: Special Color Edition", "Pok\xe9mon Advanced Generation: Pico for Everyone Pok\xe9mon Loud Battle!", "Pok\xe9mon Art Academy", "Pok\xe9mon Bank", "Pok\xe9mon Battle Revolution", "Pok\xe9mon Battle Trozei", "Pok\xe9mon Battrio", "Pok\xe9mon Black/White", "Pok\xe9mon Black/White Version 2", "Pok\xe9mon Box", "Pok\xe9mon Breeder Mini", "Pok\xe9mon Caf\xe9 Mix", "Pok\xe9mon Card GB2: GR-dan Sanjou!", "Pok\xe9mon Card Game: How To Play DS", "Pok\xe9mon Channel", "Pok\xe9mon Chasm Crosser", "Pok\xe9mon Co-Master", "Pok\xe9mon Colosseum", "Pok\xe9mon Conquest", "Pok\xe9mon Crystal", "Pok\xe9mon Dash", "Pok\xe9mon Diamond/Pearl", "Pok\xe9mon Dream Radar", "Pok\xe9mon Duel", "Pok\xe9mon Emerald", "Pok\xe9mon FireRed/LeafGreen", "Pok\xe9mon Fushigi no Dungeon: Ikuzo! Arashi/Mezase! Hikari/Susume! Honoo no Boukendan", "Pok\xe9mon Ga-Ol\xe9", "Pok\xe9mon Go", "Pok\xe9mon Gold/Silver", "Pok\xe9mon HeartGold/SoulSilver", "Pok\xe9mon Masters", "Pok\xe9mon Mega Get!", "Pok\xe9mon Mystery Dungeon: Blue/Red Rescue Team", "Pok\xe9mon Mystery Dungeon: Explorers of Darkness/Time", "Pok\xe9mon Mystery Dungeon: Explorers of Sky", "Pok\xe9mon Mystery Dungeon: Gates to Infinity", "Pok\xe9mon Mystery Dungeon: Go For It! Light Adventure Squad", "Pok\xe9mon Mystery Dungeon: Magnagate and the Infinite Labyrinth", "Pok\xe9mon Mystery Dungeon: Rescue Team DX", "Pok\xe9mon Omega Ruby/Alpha Sapphire", "Pok\xe9mon Party Mini", "Pok\xe9mon Picross", "Pok\xe9mon Pinball", "Pok\xe9mon Pinball Mini", "Pok\xe9mon Pinball: Ruby & Sapphire", "Pok\xe9mon Platinum", "Pok\xe9mon Play It!", "Pok\xe9mon Play It! 2", "Pok\xe9mon Pok\xe9 Ball Launcher", "Pok\xe9mon Project Studio Red/Blue Version", "Pok\xe9mon Puzzle Challenge", "Pok\xe9mon Puzzle Collection", "Pok\xe9mon Puzzle Collection Vol.2", "Pok\xe9mon Puzzle League", "Pok\xe9mon Quest", "Pok\xe9mon Race Mini", "Pok\xe9mon Ranger", "Pok\xe9mon Ranger: Guardian Signs", "Pok\xe9mon Ranger: Shadows of Almia", "Pok\xe9mon Red/Blue", "Pok\xe9mon Ruby/Sapphire", "Pok\xe9mon Rumble", "Pok\xe9mon Rumble Blast", "Pok\xe9mon Rumble U", "Pok\xe9mon Rumble World", "Pok\xe9mon Seek & Find	", "Pok\xe9mon Shuffle", "Pok\xe9mon Sleep", "Pok\xe9mon Smile", "Pok\xe9mon Snap", "Pok\xe9mon Stadium", "Pok\xe9mon Stadium 2", "Pok\xe9mon Sun/Moon", "Pok\xe9mon Super Mystery Dungeon", "Pok\xe9mon Team Rocket Blast Off", "Pok\xe9mon Team Turbo", "Pok\xe9mon Tetris Mini", "Pok\xe9mon Trading Card Game", "Pok\xe9mon Trading Card Game Online", "Pok\xe9mon Tretta", "Pok\xe9mon Trozei!", "Pok\xe9mon Typing Adventure", "Pok\xe9mon Ultra Sun/Ultra Moon", "Pok\xe9mon Unite", "Pok\xe9mon X/Y", "Pok\xe9mon XD: Gale of Darkness", "Pok\xe9mon Yellow: Special Pikachu Edition", "Pok\xe9mon Zany Cards", "Pok\xe9mon for Nintendo Switch (Working Title)", "Pok\xe9mon ie TAP?", "Pok\xe9mon: Masters Arena", "Police Simulator - Law Enforcement", "Police Simulator 18", "Police Simulator 2", "Pro Evolution Soccer", "Pro Evolution Soccer 2", "Pro Evolution Soccer 2008", "Pro Evolution Soccer 2009", "Pro Evolution Soccer 2010", "Pro Evolution Soccer 2011", "Pro Evolution Soccer 2012", "Pro Evolution Soccer 2013", "Pro Evolution Soccer 2014", "Pro Evolution Soccer 2015", "Pro Evolution Soccer 2016", "Pro Evolution Soccer 2017", "Pro Evolution Soccer 2018", "Pro Evolution Soccer 2019", "Pro Evolution Soccer 3", "Pro Evolution Soccer 4", "Pro Evolution Soccer 5", "Pro Evolution Soccer 6", "Pro Evolution Soccer Management", "Quake", "Quake 4", "Quake Arena Arcade", "Quake Champions", "Quake II", "Quake II Mission Pack: Ground Zero", "Quake II Mission Pack: The Reckoning", "Quake III Arena", "Quake III: Revolution", "Quake III: Team Arena", "Quake Live", "Quake Minus One", "Quake Mission Pack No 1: Scourge of Armagon", "Quake Mission Pack No 2: Dissolution of Eternity", "Ratchet & Clank", "Ratchet & Clank Collection", "Ratchet & Clank Future: A Crack in Time", "Ratchet & Clank Future: Quest for Booty", "Ratchet & Clank Future: Tools of Destruction", "Ratchet & Clank: All 4 One", "Ratchet & Clank: Before the Nexus", "Ratchet & Clank: Full Frontal Assault", "Ratchet & Clank: Ginga Saikyo Tristar Pack", "Ratchet & Clank: Going Commando", "Ratchet & Clank: Into the Nexus", "Ratchet & Clank: Rift Apart", "Ratchet & Clank: Size Matters", "Ratchet & Clank: Up Your Arsenal", "Ratchet: Deadlocked", "Rayman", "Rayman 10th Anniversary", "Rayman 2: The Great Escape", "Rayman 3", "Rayman 3: Hoodlum Havoc", "Rayman 3: Hoodlum Havoc Print Studio", "Rayman Activity Center", "Rayman Adventures", "Rayman Arena", "Rayman Bowling", "Rayman Brain Games", "Rayman By His Friends", "Rayman Designer", "Rayman Fiesta Run", "Rayman Forever", "Rayman Garden", "Rayman Gold", "Rayman Golf", "Rayman Kart", "Rayman Legends", "Rayman Legends Beatbox", "Rayman Legends Challenges App", "Rayman Mini", "Rayman Origins", "Rayman Raving Rabbids", "Rayman Raving Rabbids 2", "Rayman Raving Rabbids 4", "Rayman Raving Rabbids TV Party", "Rayman Rush", "Rayman and Rabbids Family Pack", "Rayman vs Cullcut", "Rayman: Hoodlum's Revenge", "Rayman: Jungle Run", "Rayman: Raving Rabbids", "Rayman: Slap, Flap, and Go!", "Real Football 2008", "Real Football 2009", "Real Football 2012", "Real Football 2013", "Real Heroes: Firefighter", "Red Dead Redemption", "Red Dead Redemption 2", "Red Dead Redemption: Undead Nightmare", "Red Dead Revolver", "Resident Evil", "Resident Evil 2", "Resident Evil 2 (1998)", "Resident Evil 3: Nemesis", "Resident Evil 4", "Resident Evil 5", "Resident Evil 6", "Resident Evil 7 biohazard", "Resident Evil Archives: Resident Evil", "Resident Evil Archives: Resident Evil Zero", "Resident Evil Chronicles HD Selection", "Resident Evil HD Remaster", "Resident Evil Mercenaries Vs.", "Resident Evil Origins Collection", "Resident Evil Portable", "Resident Evil Revelations Collection", "Resident Evil Revival Selection", "Resident Evil Triple Pack", "Resident Evil Village", "Resident Evil Zero", "Resident Evil Zero HD", "Resident Evil: Chronicles HD Collection", "Resident Evil: Code: Veronica", "Resident Evil: Code: Veronica X", "Resident Evil: Dead Aim", "Resident Evil: Deadly Silence", "Resident Evil: Degeneration", "Resident Evil: Director's Cut", "Resident Evil: Gaiden", "Resident Evil: Operation Raccoon City", "Resident Evil: Outbreak", "Resident Evil: Outbreak - File #2", "Resident Evil: Revelations", "Resident Evil: Revelations 2", "Resident Evil: Survivor", "Resident Evil: Survivor 2 - Code: Veronica", "Resident Evil: The Darkside Chronicles", "Resident Evil: The Mercenaries 3D", "Resident Evil: The Umbrella Chronicles", "Rock Band", "Rock Band 2", "Rock Band 3", "Rock Band 4", "Rock Band Blitz", "Rock Band Country Track Pack 2", "Rock Band Reloaded", "Rock Band Track Pack Volume 1", "Rock Band Track Pack Volume 2", "Rock Band Track Pack: Classic Rock", "Rock Band Unplugged", "Rock Band VR", "Rock Band: Country Track Pack", "Rock Band: Metal Track Pack", "Rocket League", "SNK 40th Anniversary Collection", "SNK Arcade Classics 0", "SNK Arcade Classics V.1", "SNK Gals Fighters", "SNK HEROINES Tag Team Frenzy", "SNK Slot Panic Kyuuji", "SNK vs. Capcom: Card Fighter's Clash - SNK & Capcom Version", "SNK vs. Capcom: Card Fighter's Clash 2 Expand Edition", "SNK vs. Capcom: Card Fighters DS", "SNK vs. Capcom: Match of the Millennium", "Saints Row", "Saints Row 2", "Saints Row 5", "Saints Row IV", "Saints Row IV: Re-Elected", "Saints Row: Drive-By", "Saints Row: Gat Out of Hell", "Saints Row: The Third", "Saints Row: Total Control", "Saints Row: Undercover", "Sea of Thieves", "Serious Sam", "Serious Sam 3: BFE", "Serious Sam 4", "Serious Sam Advance", "Serious Sam Classics: Revolution", "Serious Sam HD: The First Encounter", "Serious Sam HD: The Second Encounter", "Serious Sam II", "Serious Sam VR: The Last Hope", "Serious Sam's Bogus Detour", "Serious Sam: Double D", "Serious Sam: Kamikaze Attack!", "Serious Sam: Next Encounter", "Serious Sam: The First Encounter", "Serious Sam: The Greek Encounter", "Serious Sam: The Random Encounter", "Serious Sam: The Second Encounter", "Serious Sam: Tormental", "Shadow of the Tomb Raider", "Silent Hill", "Silent Hill 2", "Silent Hill 2: Restless Dreams", "Silent Hill 3", "Silent Hill 4: The Room", "Silent Hill Experience", "Silent Hill HD Collection", "Silent Hill: 0rigins", "Silent Hill: Book of Memories", "Silent Hill: Downpour", "Silent Hill: Homecoming", "Silent Hill: Orphan", "Silent Hill: Play Novel", "Silent Hill: Shattered Memories", "Silent Hill: The Arcade", "Silent Hill: The Escape", "SimCity", "SimCity 2000", "SimCity 2000 Network Edition", "SimCity 2000 Urban Renewal Kit", "SimCity 3000", "SimCity 3000 Unlimited", "SimCity 4", "SimCity 4: Rush Hour", "SimCity 64", "SimCity BuildIt", "SimCity Classic", "SimCity Creator", "SimCity DS", "SimCity Graphics Set 1: Ancient Cities", "SimCity Graphics Set 2: Future Cities", "SimCity Social", "SimCity Societies", "SimCity Societies: Destinations", "SimCity: Cities of Tomorrow", "SimCity: Terrain Editor", "Sonic & All-Stars Racing Transformed", "Sonic & Knuckles", "Sonic & Sega All-Stars Racing", "Sonic 2 In 1", "Sonic 3D Blast", "Sonic Advance", "Sonic Advance 2", "Sonic Advance 3", "Sonic Adventure", "Sonic Adventure 2", "Sonic Adventure 2: Battle", "Sonic Adventure DX: Director's Cut", "Sonic Athletics", "Sonic Battle", "Sonic Beat", "Sonic Blast", "Sonic Blast Heroes", "Sonic Blast Man", "Sonic Blast Man II", "Sonic Blast Man: Real Puncher", "Sonic Boom", "Sonic Boom: Fire & Ice", "Sonic Boom: Rise of Lyric", "Sonic Boom: Shattered Crystal", "Sonic CD", "Sonic Chronicles: The Dark Brotherhood", "Sonic Classic Collection", "Sonic Classics: 3-in-1", "Sonic Colors", "Sonic Compilation", "Sonic Crackers", "Sonic Dash", "Sonic Dash 2: Sonic Boom", "Sonic Drift", "Sonic Drift 2", "Sonic Eraser", "Sonic Forces", "Sonic Forces: Speed Battle", "Sonic Free Riders", "Sonic Fury", "Sonic Gems Collection", "Sonic Generations", "Sonic Heroes", "Sonic Jam", "Sonic Jump", "Sonic Jump Fever", "Sonic Labyrinth", "Sonic Lost World", "Sonic Mania", "Sonic Mega Collection", "Sonic Mega Collection Plus", "Sonic PC Collection", "Sonic Pinball Party", "Sonic R", "Sonic Racing", "Sonic Riders", "Sonic Riders: Zero Gravity", "Sonic Rivals", "Sonic Rivals 2", "Sonic Runners", "Sonic Runners Adventure", "Sonic Rush", "Sonic Rush Adventure", "Sonic Shuffle", "Sonic Spike", "Sonic Tweet", "Sonic Unleashed", "Sonic Wings Special", "Sonic X", "Sonic X-treme", "Sonic and the Black Knight", "Sonic and the Secret Rings", "Sonic at the Olympic Games", "Sonic at the Olympic Winter Games", "Sonic the Fighters", "Sonic the Hedgehog", "Sonic the Hedgehog 2", "Sonic the Hedgehog 3", "Sonic the Hedgehog 4: Episode I", "Sonic the Hedgehog 4: Episode II", "Sonic the Hedgehog Chaos", "Sonic the Hedgehog's Gameworld", "Sonic the Hedgehog: Pocket Adventure", "Sonic the Hedgehog: Spinball", "Sonic the Hedgehog: Triple Trouble", "Sonic's Edusoft", "Sonic's Schoolhouse", "Sonic's Ultimate Genesis Collection", "Street Fighter", "Street Fighter 2010: The Final Fight", "Street Fighter 25th Anniversary Collector's Set", "Street Fighter 30th Anniversary Collection", "Street Fighter Alpha 2", "Street Fighter Alpha 3", "Street Fighter Alpha 3 MAX", "Street Fighter Alpha Anthology", "Street Fighter Alpha: Warriors' Dreams", "Street Fighter Battle Combination", "Street Fighter Collection", "Street Fighter Collection 2", "Street Fighter EX", "Street Fighter EX Plus", "Street Fighter EX Plus Alpha", "Street Fighter EX2", "Street Fighter EX2 Plus", "Street Fighter EX3", "Street Fighter II Movie", "Street Fighter II Pinball", "Street Fighter II Turbo: Hyper Fighting", "Street Fighter II': Champion Edition", "Street Fighter II': Hyper Fighting", "Street Fighter II: The World Warrior", "Street Fighter III: 2nd Impact", "Street Fighter III: 3rd Strike", "Street Fighter III: Double Impact", "Street Fighter III: New Generation", "Street Fighter IV", "Street Fighter IV Champion Edition", "Street Fighter IV Volt", "Street Fighter IV: Arena", "Street Fighter Online: Mouse Generation", "Street Fighter Series", "Street Fighter V", "Street Fighter 6", "Street Fighter 6 Deluxe Edition", "Street Fighter 6 Ultimate Edition", "Street Fighter X All Capcom", "Street Fighter X Mega Man", "Street Fighter X Tekken", "Street Fighter: Anniversary Collection", "Street Fighter: Puzzle Spirits", "Streets of Rage", "Streets of Rage 2", "Streets of Rage 3", "Streets of Rage 4", "Streets of Rage Remake", "Super Mario 3D Land", "Super Mario 3D World", "Super Mario 64", "Super Mario 64 DS", "Super Mario Advance", "Super Mario All-Stars", "Super Mario All-Stars & Super Mario World", "Super Mario Bros.", "Super Mario Bros. 2", "Super Mario Bros. 3", "Super Mario Bros. 35", "Super Mario Bros. 3: Super Mario Advance 4", "Super Mario Bros. Deluxe", "Super Mario Bros. Mushroom World", "Super Mario Bros. Special", "Super Mario Bros.: The Lost Levels", "Super Mario Galaxy", "Super Mario Galaxy 2", "Super Mario Kart", "Super Mario Land", "Super Mario Land 2: 6 Golden Coins", "Super Mario Maker", "Super Mario Maker 2", "Super Mario Maker for Nintendo 3DS", "Super Mario Odyssey", "Super Mario Party", "Super Mario RPG: Legend of the Seven Stars", "Super Mario Run", "Super Mario Strikers", "Super Mario Sunshine", "Super Mario Wii U (Working Title)", "Super Mario World", "Super Mario World 2: Yoshi's Island", "Super Mario World: Super Mario Advance 2", "Super Mario's Wacky Worlds", "Super Street Fighter II", "Super Street Fighter II Turbo", "Super Street Fighter II Turbo HD Remix", "Super Street Fighter II: The New Challengers", "Super Street Fighter II: The Tournament Battle", "Super Street Fighter II: Turbo Revival", "Super Street Fighter IV", "Super Street Fighter IV: Pachislot Edition", "Surgeon Simulator 2", "Surgeon Simulator 2013", "Surgeon Simulator: Experience Reality", "Teenage Mutant Ninja Turtles 2: Battle Nexus", "Teenage Mutant Ninja Turtles 3: Mutant Nightmare", "Teenage Mutant Ninja Turtles Double Pack", "Teenage Mutant Ninja Turtles II:  Back from the Sewers", "Teenage Mutant Ninja Turtles III: Radical Rescue", "Teenage Mutant Ninja Turtles III: The Manhattan Project", "Teenage Mutant Ninja Turtles IV: Turtles in Time", "Teenage Mutant Ninja Turtles Legends", "Teenage Mutant Ninja Turtles VS Power Rangers: Ultimate Hero Clash!", "Teenage Mutant Ninja Turtles:  Fall of the Foot Clan", "Teenage Mutant Ninja Turtles: Arcade Attack", "Teenage Mutant Ninja Turtles: Battle Match", "Teenage Mutant Ninja Turtles: Brothers Unite", "Teenage Mutant Ninja Turtles: Danger of the Ooze", "Teenage Mutant Ninja Turtles: Dark Horizons", "Teenage Mutant Ninja Turtles: Donnie Saves A Princess", "Teenage Mutant Ninja Turtles: Double Damage", "Teenage Mutant Ninja Turtles: Half-Shell Heroes", "Teenage Mutant Ninja Turtles: Manhattan Missions", "Teenage Mutant Ninja Turtles: Master Splinter's Training Pack", "Teenage Mutant Ninja Turtles: Mutant Madness", "Teenage Mutant Ninja Turtles: Mutant Rumble", "Teenage Mutant Ninja Turtles: Mutants in Manhattan", "Teenage Mutant Ninja Turtles: Out of the Shadows", "Teenage Mutant Ninja Turtles: Portal Power", "Teenage Mutant Ninja Turtles: Return of the Shredder", "Teenage Mutant Ninja Turtles: Rooftop Run", "Teenage Mutant Ninja Turtles: Sewer Run", "Teenage Mutant Ninja Turtles: Shadow Heroes", "Teenage Mutant Ninja Turtles: Smash-Up", "Teenage Mutant Ninja Turtles: The HyperStone Heist", "Teenage Mutant Ninja Turtles: The Shredder Reborn", "Teenage Mutant Ninja Turtles: Tournament Fighters", "Teenage Mutant Ninja Turtles: Training Lair", "Teenage Mutant Ninja Turtles: Turtles in Time Re-Shelled", "Tekken", "Tekken 2", "Tekken 3", "Tekken 3D Prime Edition", "Tekken 4", "Tekken 5", "Tekken 6", "Tekken 6: Bloodline Rebellion", "Tekken 7", "Tekken 7: Fated Retribution", "Tekken Advance", "Tekken Arena", "Tekken Bowl", "Tekken Card Challenge", "Tekken Card Tournament", "Tekken Hybrid", "Tekken Mobile", "Tekken Pachi-Slot 3rd", "Tekken R", "Tekken Resolute", "Tekken Revolution", "Tekken Tag Tournament", "Tekken Tag Tournament 2", "Tekken X Street Fighter", "Tekken: Dark Resurrection", "Terraria", "The Elder Scrolls Adventures: Redguard", "The Elder Scrolls Anthology", "The Elder Scrolls II: Daggerfall", "The Elder Scrolls III: Bloodmoon", "The Elder Scrolls III: Morrowind", "The Elder Scrolls III: Tribunal", "The Elder Scrolls IV: Knights of the Nine", "The Elder Scrolls IV: Oblivion", "The Elder Scrolls IV: Shivering Isles", "The Elder Scrolls Online", "The Elder Scrolls Travels: Oblivion", "The Elder Scrolls Travels: Shadowkey", "The Elder Scrolls V: Skyrim", "The Elder Scrolls VI", "The Elder Scrolls: Arena", "The Elder Scrolls: Blades", "The Elder Scrolls: Legends", "The King of Fighters '94", "The King of Fighters '94 Re-bout", "The King of Fighters '95", "The King of Fighters '96", "The King of Fighters '97", "The King of Fighters '97 OL", "The King of Fighters '98 Ultimate Match", "The King of Fighters '98: The Slugfest", "The King of Fighters '98: Ultimate Match Online", "The King of Fighters '99", "The King of Fighters 02/03", "The King of Fighters 2000", "The King of Fighters 2000/2001", "The King of Fighters 2001", "The King of Fighters 2002 Unlimited Match", "The King of Fighters 2002: Challenge to Ultimate Battle", "The King of Fighters 2003", "The King of Fighters 2006", "The King of Fighters All Star", "The King of Fighters Collection: The Orochi Saga", "The King of Fighters EX2: Howling Blood", "The King of Fighters EX: Neo Blood", "The King of Fighters Encounter", "The King of Fighters Extreme", "The King of Fighters Kyo", "The King of Fighters Online", "The King of Fighters XI", "The King of Fighters XII", "The King of Fighters XIII", "The King of Fighters XIV", "The King of Fighters XV", "The King of Fighters for Girls", "The King of Fighters-i 002", "The King of Fighters: Battle de Paradise", "The King of Fighters: Dream Match 1999", "The King of Fighters: Evolution", "The King of Fighters: Maximum Impact", "The King of Fighters: Maximum Impact Regulation A", "The King of Fighters: NESTS Hen", "The King of Fighters: Neowave", "The King of Fighters: Sky Stage", "The King of Fighters: World", "The Legend of Zelda", "The Legend of Zelda: A Link Between Worlds", "The Legend of Zelda: A Link to the Past", "The Legend of Zelda: A Link to the Past & Four Swords", "The Legend of Zelda: Breath of the Wild", "The Legend of Zelda: Breath of the Wild Sequel (Working Title)", "The Legend of Zelda: Collector's Edition", "The Legend of Zelda: Four Swords Adventures", "The Legend of Zelda: Link's Awakening", "The Legend of Zelda: Link's Awakening DX", "The Legend of Zelda: Majora's Mask", "The Legend of Zelda: Majora's Mask 3D", "The Legend of Zelda: Ocarina of Time", "The Legend of Zelda: Ocarina of Time 3D", "The Legend of Zelda: Oracle of Ages", "The Legend of Zelda: Oracle of Seasons", "The Legend of Zelda: Phantom Hourglass", "The Legend of Zelda: Skyward Sword", "The Legend of Zelda: Spirit Tracks", "The Legend of Zelda: Tetra's Trackers", "The Legend of Zelda: The Minish Cap", "The Legend of Zelda: The Wind Waker", "The Legend of Zelda: The Wind Waker HD", "The Legend of Zelda: Tri Force Heroes", "The Legend of Zelda: Twilight Princess", "The Legend of Zelda: Twilight Princess HD", "The Simpsons: Hit & Run", "The Sims", "The Sims 2", "The Sims 2 Castaway", "The Sims 2: Apartment Life", "The Sims 2: Apartment Pets", "The Sims 2: Bon Voyage", "The Sims 2: Celebration Stuff", "The Sims 2: Family Fun Stuff", "The Sims 2: Free Time", "The Sims 2: Glamour Life Stuff", "The Sims 2: H&M Fashion Stuff", "The Sims 2: Happy Holiday Stuff", "The Sims 2: Holiday Party Pack", "The Sims 2: IKEA Home Stuff", "The Sims 2: Kitchen and Bath Stuff", "The Sims 2: Mansion & Garden Stuff", "The Sims 2: Nightlife", "The Sims 2: Open for Business", "The Sims 2: Pets", "The Sims 2: Seasons", "The Sims 2: Super Collection", "The Sims 2: Teen Style Stuff", "The Sims 2: University", "The Sims 3", "The Sims 3 High-End Loft Stuff", "The Sims 3 Seasons", "The Sims 3: Ambitions", "The Sims 3: DIESEL Stuff", "The Sims 3: Dragon Valley", "The Sims 3: Fast Lane Stuff", "The Sims 3: Generations", "The Sims 3: Into the Future", "The Sims 3: Island Paradise", "The Sims 3: Katy Perry Sweet Treats", "The Sims 3: Late Night", "The Sims 3: Master Suite Stuff", "The Sims 3: Outdoor Living Stuff", "The Sims 3: Pets", "The Sims 3: Showtime", "The Sims 3: Supernatural", "The Sims 3: Town Life Stuff", "The Sims 3: University Life", "The Sims 3: World Adventures", "The Sims 4", "The Sims Carnival: Bumper Blast", "The Sims DJ", "The Sims Medieval", "The Sims Medieval: Pirates and Nobles", "The Sims Mobile", "The Sims Pool", "The Sims Social", "The Sims: Bowling", "The Sims: Bustin' Out", "The Sims: Carnival - SnapCity", "The Sims: Castaway Stories", "The Sims: Hot Date", "The Sims: House Party", "The Sims: Life Stories", "The Sims: Livin' Large", "The Sims: Makin' Magic", "The Sims: Online", "The Sims: Pet Stories", "The Sims: Superstar", "The Sims: Unleashed", "The Sims: Vacation", "Tom & Jerry: Hunting High and Low", "Tom & Jerry: Mousehunt", "Tom & Jerry: The Ultimate Game of Cat and Mouse!", "Tom Clancy's Ghost Recon", "Tom Clancy's Ghost Recon 2 - 2007: First Contact", "Tom Clancy's Ghost Recon 2 - 2011: Final Assault", "Tom Clancy's Ghost Recon 2: Summit Strike", "Tom Clancy's Ghost Recon Breakpoint", "Tom Clancy's Ghost Recon Commander", "Tom Clancy's Ghost Recon Phantoms", "Tom Clancy's Ghost Recon: Advanced Warfighter", "Tom Clancy's Ghost Recon: Advanced Warfighter 2", "Tom Clancy's Ghost Recon: Desert Siege", "Tom Clancy's Ghost Recon: Future Soldier", "Tom Clancy's Ghost Recon: Island Thunder", "Tom Clancy's Ghost Recon: Jungle Storm", "Tom Clancy's Ghost Recon: Predator", "Tom Clancy's Ghost Recon: Shadow Wars", "Tom Clancy's Ghost Recon: Wildlands", "Tom Clancy's Rainbow 6: Patriots", "Tom Clancy's Rainbow Six", "Tom Clancy's Rainbow Six 3: Athena Sword", "Tom Clancy's Rainbow Six 3: Black Arrow", "Tom Clancy's Rainbow Six 3: Iron Wrath", "Tom Clancy's Rainbow Six 3: Raven Shield", "Tom Clancy's Rainbow Six Mission Pack: Eagle Watch", "Tom Clancy's Rainbow Six Quarantine", "Tom Clancy's Rainbow Six: Covert Ops Essentials", "Tom Clancy's Rainbow Six: Critical Hour", "Tom Clancy's Rainbow Six: Lockdown", "Tom Clancy's Rainbow Six: Lone Wolf", "Tom Clancy's Rainbow Six: Rogue Spear", "Tom Clancy's Rainbow Six: Rogue Spear - Black Thorn", "Tom Clancy's Rainbow Six: Rogue Spear Mission Pack - Urban Operations", "Tom Clancy's Rainbow Six: Shadow Vanguard", "Tom Clancy's Rainbow Six: Siege", "Tom Clancy's Rainbow Six: Take-Down: Missions in Korea", "Tom Clancy's Rainbow Six: Vegas", "Tom Clancy's Rainbow Six: Vegas 2", "Tom Clancy's Ruthless.com", "Tom Clancy's The Division", "Tom Clancy's The Division 2", "Tomb Raider", "Tomb Raider (1996)", "Tomb Raider Arcade", "Tomb Raider II", "Tomb Raider III: Adventures of Lara Croft", "Tomb Raider Level Editor", "Tomb Raider: Chronicles", "Tomb Raider: The Golden Mask", "Tomb Raider: The Last Revelation", "Tomb Raider: The Lost Artifact", "Tomb Raider: Underworld", "Tomb Raider: Unfinished Business", "Tony Hawk's American Sk8land", "Tony Hawk's American Wasteland", "Tony Hawk's Downhill Jam", "Tony Hawk's Motion and Hue Pixel Painter", "Tony Hawk's Pro Skater", "Tony Hawk's Pro Skater 1+2", "Tony Hawk's Pro Skater 2", "Tony Hawk's Pro Skater 2x", "Tony Hawk's Pro Skater 3", "Tony Hawk's Pro Skater 4", "Tony Hawk's Pro Skater 5", "Tony Hawk's Pro Skater HD", "Tony Hawk's Project 8", "Tony Hawk's Proving Ground", "Tony Hawk's Shred Session", "Tony Hawk's Skate Jam", "Tony Hawk's Underground", "Tony Hawk's Underground 2", "Tony Hawk's Underground 2: Remix", "Tony Hawk: RIDE", "Tony Hawk: SHRED", "Top Gear", "Top Gear 2", "Top Gear 3000", "Top Gear GT Championship", "Top Gear Hyperbike", "Top Gear Overdrive", "Top Gear Pocket", "Top Gear Pocket 2", "Top Gear RPM Tuning", "Top Gear Rally", "Top Gear Rally 2", "Top Gear: Dare Devil", "Toy Story 2", "Toy Story 2: Buzz Lightyear to the Rescue!", "Toy Story 2: Woody Sousaku Daisakusen!!", "Toy Story 3", "Toy Story 3: The Video Game", "Toy Story Activity Center", "Toy Story Drop!", "Toy Story Mania!", "Toy Story: Smash It!", "Ultimate Mortal Kombat", "Ultimate Mortal Kombat 3", "Ultra Street Fighter II: The Final Challengers", "Ultra Street Fighter IV", "Uncharted 2: Among Thieves", "Uncharted 3: Drake's Deception", "Uncharted 4: A Thief's End", "Uncharted Tides: Port Royal", "Uncharted Water Online: Cruz del Sur", "Uncharted Waters", "Uncharted Waters 2: New Horizons", "Uncharted Waters Online", "Uncharted Waters Origin", "Uncharted: Drake's Fortune", "Uncharted: Fight for Fortune", "Uncharted: Fortune Hunter", "Uncharted: Golden Abyss", "Uncharted: The Lost Legacy", "Uncharted: The Nathan Drake Collection", "WWE '12", "WWE '13", "WWE 2K Battlegrounds", "WWE 2K14", "WWE 2K15", "WWE 2K16", "WWE 2K17", "WWE 2K18", "WWE 2K19", "WWE 2K20", "World of Warcraft", "Worms", "Worms 2", "Worms 2: Armageddon", "Worms 3", "Worms 3D", "Worms 4", "Worms 4: Mayhem", "Worms Armageddon", "Worms Battlegrounds", "Worms Blast", "Worms Clan Wars", "Worms Collection", "Worms Crazy Golf", "Worms Forts: Under Siege", "Worms Pinball", "Worms Reloaded", "Worms Revolution", "Worms Rumble", "Worms Ultimate Mayhem", "Worms W.M.D", "Worms World Party", "Worms and Reinforcements: United", "Worms: A Space Oddity", "Worms: Battle Islands", "Worms: Open Warfare", "Worms: Open Warfare 2", "Worms: Reinforcements", "Worms: The Director's Cut", "Worms: The Revolution Collection", "XCOM 2", "XCOM 2: War of the Chosen", "XCOM: Chimera Squad", "XCOM: Enemy Unknown", "XCOM: Enemy Within", "Yakuza 0", "Yakuza 2", "Yakuza 3", "Yakuza 4", "Yakuza 5", "Yakuza 6: The Song of Life", "Yakuza Fury", "Yakuza Kiwami", "Yakuza Kiwami 2", "Yakuza Online", "Yakuza: Dead Souls", "Yoshi Topsy-Turvy", "Yoshi Touch & Go", "Yoshi for Nintendo Switch (Working Title)", "Yoshi no Cookie: Kuruppon Oven de Cookie", "Yoshi's Cookie", "Yoshi's Island DS", "Yoshi's Island: Super Mario Advance 3", "Yoshi's New Island", "Yoshi's Safari", "Yoshi's Story", "Yoshi's Woolly World", "Zoo Tycoon", "Zoo Tycoon 2", "Zoo Tycoon 2: African Adventure", "Zoo Tycoon 2: Endangered Species", "Zoo Tycoon 2: Extinct Animals", "Zoo Tycoon 2: Marine Mania", "Zoo Tycoon 2: Zookeeper Collection", "Zoo Tycoon DS 2", "Zoo Tycoon: Dinosaur Digs", "Zoo Tycoon: Marine Mania", "Zoo Tycoon: Ultimate Animal Collection", "Zorro: Quest for Justice"],
                    ["Alfa Romeo 145", "Alfa Romeo 146", "Alfa Romeo 147", "Alfa Romeo 155", "Alfa Romeo 156", "Alfa Romeo 156 Sportwagon", "Alfa Romeo 159", "Alfa Romeo 159 Sportwagon", "Alfa Romeo 164", "Alfa Romeo 166", "Alfa Romeo 4C", "Alfa Romeo Brera", "Alfa Romeo GTV", "Alfa Romeo MiTo", "Alfa Romeo Crosswagon", "Alfa Romeo Spider", "Alfa Romeo GT", "Alfa Romeo Giulietta", "Alfa Romeo Giulia", "Audi 100", "Audi 100 Avant", "Audi 80", "Audi 80 Avant", "Audi 80 Cabrio", "Audi 90", "Audi A1", "Audi A2", "Audi A3", "Audi A3 Cabriolet", "Audi A3 Limuzina", "Audi A3 Sportback", "Audi A4", "Audi A4 Allroad", "Audi A4 Avant", "Audi A4 Cabriolet", "Audi A5", "Audi A5 Cabriolet", "Audi A5 Sportback", "Audi A6", "Audi A6 Allroad", "Audi A6 Avant", "Audi A7", "Audi A8", "Audi A8 Long", "Audi Q3", "Audi Q5", "Audi Q7", "Audi R8", "Audi RS4 Cabriolet", "Audi RS4/RS4 Avant", "Audi RS5", "Audi RS6 Avant", "Audi RS7", "Audi S3/S3 Sportback", "Audi S4 Cabriolet", "Audi S4/S4 Avant", "Audi S5/S5 Cabriolet", "Audi S6/RS6", "Audi S7", "Audi S8", "Audi SQ5", "Audi TT Coup\xe9", "Audi TT Roadster", "Audi TTS", "BMW i3", "BMW i8", "BMW M3", "BMW M4", "BMW M5", "BMW M6", "BMW Rad 1", "BMW Rad 1 Cabrio", "BMW Rad 1 Coup\xe9", "BMW Rad 2", "BMW Rad 2 Active Tourer", "BMW Rad 2 Coup\xe9", "BMW Rad 2 Gran Tourer", "BMW Rad 3", "BMW Rad 3 Cabrio", "BMW Rad 3 Compact", "BMW Rad 3 Coup\xe9", "BMW Rad 3 GT", "BMW Rad 3 Touring", "BMW Rad 4", "BMW Rad 4 Cabrio", "BMW Rad 4 Gran Coup\xe9", "BMW Rad 5", "BMW Rad 5 GT", "BMW Rad 5 Touring", "BMW Rad 6", "BMW Rad 6 Cabrio", "BMW Rad 6 Coup\xe9", "BMW Rad 6 Gran Coup\xe9", "BMW Rad 7", "BMW Rad 8 Coup\xe9", "BMW X1", "BMW X3", "BMW X4", "BMW X5", "BMW X6", "BMW Z3", "BMW Z3 Coup\xe9", "BMW Z3 Roadster", "BMW Z4", "BMW Z4 Roadster", "Chevrolet Alero", "Chevrolet Aveo", "Chevrolet Camaro", "Chevrolet Captiva", "Chevrolet Corvette", "Chevrolet Cruze", "Chevrolet Cruze SW", "Chevrolet Epica", "Chevrolet Equinox", "Chevrolet Evanda", "Chevrolet HHR", "Chevrolet Kalos", "Chevrolet Lacetti", "Chevrolet Lacetti SW", "Chevrolet Lumina", "Chevrolet Malibu", "Chevrolet Matiz", "Chevrolet Monte Carlo", "Chevrolet Nubira", "Chevrolet Orlando", "Chevrolet Spark", "Chevrolet Suburban", "Chevrolet Tacuma", "Chevrolet Tahoe", "Chevrolet Trax", "Chrysler 300 C", "Chrysler 300 C Touring", "Chrysler 300 M", "Chrysler Crossfire", "Chrysler Grand Voyager", "Chrysler LHS", "Chrysler Neon", "Chrysler Pacifica", "Chrysler Plymouth", "Chrysler PT Cruiser", "Chrysler Sebring", "Chrysler Sebring Convertible", "Chrysler Stratus", "Chrysler Stratus Cabrio", "Chrysler Town & Country", "Chrysler Voyager", "Citro\xebn Berlingo", "Citro\xebn C-Crosser", "Citro\xebn C-Eliss\xe9e", "Citro\xebn C-Zero", "Citro\xebn C1", "Citro\xebn C2", "Citro\xebn C3", "Citro\xebn C3 Picasso", "Citro\xebn C4", "Citro\xebn C4 Aircross", "Citro\xebn C4 Cactus", "Citro\xebn C4 Coup\xe9", "Citro\xebn C4 Grand Picasso", "Citro\xebn C4 Sedan", "Citro\xebn C5", "Citro\xebn C5 Break", "Citro\xebn C5 Tourer", "Citro\xebn C6", "Citro\xebn C8", "Citro\xebn DS3", "Citro\xebn DS4", "Citro\xebn DS5", "Citro\xebn Evasion", "Citro\xebn Jumper", "Citro\xebn Jumpy", "Citro\xebn Saxo", "Citro\xebn Nemo", "Citro\xebn Xantia", "Citro\xebn Xsara", "Dacia Dokker", "Dacia Duster", "Dacia Lodgy", "Dacia Logan", "Dacia Logan MCV", "Dacia Logan Van", "Dacia Sandero", "Dacia Solenza", "Daewoo Espero", "Daewoo Kalos", "Daewoo Lacetti", "Daewoo Lanos", "Daewoo Leganza", "Daewoo Lublin", "Daewoo Matiz", "Daewoo Nexia", "Daewoo Nubira", "Daewoo Nubira kombi", "Daewoo Racer", "Daewoo Tacuma", "Daewoo Tico", "Dodge Avenger", "Dodge Caliber", "Dodge Challenger", "Dodge Charger", "Dodge Grand Caravan", "Dodge Journey", "Dodge Magnum", "Dodge Nitro", "Dodge RAM", "Dodge Stealth", "Dodge Viper", "Fiat 1100", "Fiat 126", "Fiat 500", "Fiat 500L", "Fiat 500X", "Fiat 850", "Fiat Barchetta", "Fiat Brava", "Fiat Cinquecento", "Fiat Coup\xe9", "Fiat Croma", "Fiat Doblo", "Fiat Doblo Cargo", "Fiat Doblo Cargo Combi", "Fiat Ducato", "Fiat Ducato Van", "Fiat Ducato Kombi", "Fiat Ducato Podvozok", "Fiat Florino", "Fiat Florino Combi", "Fiat Freemont", "Fiat Grande Punto", "Fiat Idea", "Fiat Linea", "Fiat Marea", "Fiat Marea Weekend", "Fiat Multipla", "Fiat Palio Weekend", "Fiat Panda", "Fiat Panda Van", "Fiat Punto", "Fiat Punto Cabriolet", "Fiat Punto Evo", "Fiat Punto Van", "Fiat Qubo", "Fiat Scudo", "Fiat Scudo Van", "Fiat Scudo Kombi", "Fiat Sedici", "Fiat Seicento", "Fiat Stilo", "Fiat Stilo Multiwagon", "Fiat Strada", "Fiat Talento", "Fiat Tipo", "Fiat Ulysse", "Fiat Uno", "Fiat X1/9", "Ford Aerostar", "Ford B-Max", "Ford C-Max", "Ford Cortina", "Ford Cougar", "Ford Edge", "Ford Escort", "Ford Escort Cabrio", "Ford Escort kombi", "Ford Explorer", "Ford F-150", "Ford F-250", "Ford Fiesta", "Ford Focus", "Ford Focus C-Max", "Ford Focus CC", "Ford Focus kombi", "Ford Fusion", "Ford Galaxy", "Ford Grand C-Max", "Ford Ka", "Ford Kuga", "Ford Maverick", "Ford Mondeo", "Ford Mondeo Combi", "Ford Mustang", "Ford Orion", "Ford Puma", "Ford Ranger", "Ford S-Max", "Ford Sierra", "Ford Street Ka", "Ford Tourneo Connect", "Ford Tourneo Custom", "Ford Transit", "Ford Transit", "Ford Transit Bus", "Ford Transit Connect LWB", "Ford Transit Courier", "Ford Transit Custom", "Ford Transit kombi", "Ford Transit Tourneo", "Ford Transit Valnik", "Ford Transit Van", "Ford Transit Van 350", "Ford Windstar", "Honda Accord", "Honda Accord Coup\xe9", "Honda Accord Tourer", "Honda City", "Honda Civic", "Honda Civic Aerodeck", "Honda Civic Coup\xe9", "Honda Civic Tourer", "Honda Civic Type R", "Honda CR-V", "Honda CR-X", "Honda CR-Z", "Honda FR-V", "Honda HR-V", "Honda Insight", "Honda Integra", "Honda Jazz", "Honda Legend", "Honda Prelude", "Hummer H2", "Hummer H3", "Hyundai Accent", "Hyundai Atos", "Hyundai Atos Prime", "Hyundai Coup\xe9", "Hyundai Elantra", "Hyundai Galloper", "Hyundai Genesis", "Hyundai Getz", "Hyundai Grandeur", "Hyundai H 350", "Hyundai H1", "Hyundai H1 Bus", "Hyundai H1 Van", "Hyundai H200", "Hyundai i10", "Hyundai i20", "Hyundai i30", "Hyundai i30 CW", "Hyundai i40", "Hyundai i40 CW", "Hyundai ix20", "Hyundai ix35", "Hyundai ix55", "Hyundai Lantra", "Hyundai Matrix", "Hyundai Santa Fe", "Hyundai Sonata", "Hyundai Terracan", "Hyundai Trajet", "Hyundai Tucson", "Hyundai Veloster", "Infiniti EX", "Infiniti FX", "Infiniti G", "Infiniti G Coup\xe9", "Infiniti M", "Infiniti Q", "Infiniti QX", "Jaguar Daimler", "Jaguar F-Pace", "Jaguar F-Type", "Jaguar S-Type", "Jaguar Sovereign", "Jaguar X-Type", "Jaguar X-type Estate", "Jaguar XE", "Jaguar XF", "Jaguar XJ", "Jaguar XJ12", "Jaguar XJ6", "Jaguar XJ8", "Jaguar XJ8", "Jaguar XJR", "Jaguar XK", "Jaguar XK8 Convertible", "Jaguar XKR", "Jaguar XKR Convertible", "Jeep Cherokee", "Jeep Commander", "Jeep Compass", "Jeep Grand Cherokee", "Jeep Patriot", "Jeep Renegade", "Jeep Wrangler", "Kia Avella", "Kia Besta", "Kia Carens", "Kia Carnival", "Kia Cee`d", "Kia Cee`d SW", "Kia Cerato", "Kia K 2500", "Kia Magentis", "Kia Opirus", "Kia Optima", "Kia Picanto", "Kia Pregio", "Kia Pride", "Kia Pro Cee`d", "Kia Rio", "Kia Rio Combi", "Kia Rio sedan", "Kia Sephia", "Kia Shuma", "Kia Sorento", "Kia Soul", "Kia Sportage", "Kia Venga", "Land Rover 109", "Land Rover Defender", "Land Rover Discovery", "Land Rover Discovery Sport", "Land Rover Freelander", "Land Rover Range Rover", "Land Rover Range Rover Evoque", "Land Rover Range Rover Sport", "Lexus CT", "Lexus GS", "Lexus GS 300", "Lexus GX", "Lexus IS", "Lexus IS 200", "Lexus IS 250 C", "Lexus IS-F", "Lexus LS", "Lexus LX", "Lexus NX", "Lexus RC F", "Lexus RX", "Lexus RX 300", "Lexus RX 400h", "Lexus RX 450h", "Lexus SC 430", "MINI Cooper", "MINI Cooper Cabrio", "MINI Cooper Clubman", "MINI Cooper D", "MINI Cooper D Clubman", "MINI Cooper S", "MINI Cooper S Cabrio", "MINI Cooper S Clubman", "MINI Countryman", "MINI Mini One", "MINI One D", "Mazda 121", "Mazda 2", "Mazda 3", "Mazda 323", "Mazda 323 Combi", "Mazda 323 Coup\xe9", "Mazda 323 F", "Mazda 5", "Mazda 6", "Mazda 6 Combi", "Mazda 626", "Mazda 626 Combi", "Mazda B-Fighter", "Mazda B2500", "Mazda BT", "Mazda CX-3", "Mazda CX-5", "Mazda CX-7", "Mazda CX-9", "Mazda Demio", "Mazda MPV", "Mazda MX-3", "Mazda MX-5", "Mazda MX-6", "Mazda Premacy", "Mazda RX-7", "Mazda RX-8", "Mazda Xedox 6", "Mercedes-Benz 100 D", "Mercedes-Benz 115", "Mercedes-Benz 124", "Mercedes-Benz 126", "Mercedes-Benz 190", "Mercedes-Benz 190 D", "Mercedes-Benz 190 E", "Mercedes-Benz 200 - 300", "Mercedes-Benz 200 D", "Mercedes-Benz 200 E", "Mercedes-Benz 210 Van", "Mercedes-Benz 210 kombi", "Mercedes-Benz 310 Van", "Mercedes-Benz 310 kombi", "Mercedes-Benz 230 - 300 CE Coup\xe9", "Mercedes-Benz 260 - 560 SE", "Mercedes-Benz 260 - 560 SEL", "Mercedes-Benz 500 - 600 SEC Coup\xe9", "Mercedes-Benz Trieda A", "Mercedes-Benz A", "Mercedes-Benz A L", "Mercedes-Benz AMG GT", "Mercedes-Benz Trieda B", "Mercedes-Benz Trieda C", "Mercedes-Benz C", "Mercedes-Benz C Sportcoup\xe9", "Mercedes-Benz C T", "Mercedes-Benz Citan", "Mercedes-Benz CL", "Mercedes-Benz CL", "Mercedes-Benz CLA", "Mercedes-Benz CLC", "Mercedes-Benz CLK Cabrio", "Mercedes-Benz CLK Coup\xe9", "Mercedes-Benz CLS", "Mercedes-Benz Trieda E", "Mercedes-Benz E", "Mercedes-Benz E Cabrio", "Mercedes-Benz E Coup\xe9", "Mercedes-Benz E T", "Mercedes-Benz Trieda G", "Mercedes-Benz G Cabrio", "Mercedes-Benz GL", "Mercedes-Benz GLA", "Mercedes-Benz GLC", "Mercedes-Benz GLE", "Mercedes-Benz GLK", "Mercedes-Benz Trieda M", "Mercedes-Benz MB 100", "Mercedes-Benz Trieda R", "Mercedes-Benz Trieda S", "Mercedes-Benz S", "Mercedes-Benz S Coup\xe9", "Mercedes-Benz SL", "Mercedes-Benz SLC", "Mercedes-Benz SLK", "Mercedes-Benz SLR", "Mercedes-Benz Sprinter", "Mitsubishi 3000 GT", "Mitsubishi ASX", "Mitsubishi Carisma", "Mitsubishi Colt", "Mitsubishi Colt CC", "Mitsubishi Eclipse", "Mitsubishi Fuso canter", "Mitsubishi Galant", "Mitsubishi Galant Combi", "Mitsubishi Grandis", "Mitsubishi L200", "Mitsubishi L200 Pick up", "Mitsubishi L200 Pick up Allrad", "Mitsubishi L300", "Mitsubishi Lancer", "Mitsubishi Lancer Combi", "Mitsubishi Lancer Evo", "Mitsubishi Lancer Sportback", "Mitsubishi Outlander", "Mitsubishi Pajero", "Mitsubishi Pajeto Pinin", "Mitsubishi Pajero Pinin Wagon", "Mitsubishi Pajero Sport", "Mitsubishi Pajero Wagon", "Mitsubishi Space Star", "Nissan 100 NX", "Nissan 200 SX", "Nissan 350 Z", "Nissan 350 Z Roadster", "Nissan 370 Z", "Nissan Almera", "Nissan Almera Tino", "Nissan Cabstar E - T", "Nissan Cabstar TL2 Valnik", "Nissan e-NV200", "Nissan GT-R", "Nissan Insterstar", "Nissan Juke", "Nissan King Cab", "Nissan Leaf", "Nissan Maxima", "Nissan Maxima QX", "Nissan Micra", "Nissan Murano", "Nissan Navara", "Nissan Note", "Nissan NP300 Pickup", "Nissan NV200", "Nissan NV400", "Nissan Pathfinder", "Nissan Patrol", "Nissan Patrol GR", "Nissan Pickup", "Nissan Pixo", "Nissan Primastar", "Nissan Primastar Combi", "Nissan Primera", "Nissan Primera Combi", "Nissan Pulsar", "Nissan Qashqai", "Nissan Serena", "Nissan Sunny", "Nissan Terrano", "Nissan Tiida", "Nissan Trade", "Nissan Vanette Cargo", "Nissan X-Trail", "Opel Agila", "Opel Ampera", "Opel Antara", "Opel Astra", "Opel Astra cabrio", "Opel Astra caravan", "Opel Astra coup\xe9", "Opel Calibra", "Opel Campo", "Opel Cascada", "Opel Corsa", "Opel Frontera", "Opel Insignia", "Opel Insignia kombi", "Opel Kadett", "Opel Meriva", "Opel Mokka", "Opel Movano", "Opel Omega", "Opel Signum", "Opel Vectra", "Opel Vectra Caravan", "Opel Vivaro", "Opel Vivaro Kombi", "Opel Zafira", "Peugeot 1007", "Peugeot 107", "Peugeot 106", "Peugeot 108", "Peugeot 2008", "Peugeot 205", "Peugeot 205 Cabrio", "Peugeot 206", "Peugeot 206 CC", "Peugeot 206 SW", "Peugeot 207", "Peugeot 207 CC", "Peugeot 207 SW", "Peugeot 306", "Peugeot 307", "Peugeot 307 CC", "Peugeot 307 SW", "Peugeot 308", "Peugeot 308 CC", "Peugeot 308 SW", "Peugeot 309", "Peugeot 4007", "Peugeot 4008", "Peugeot 405", "Peugeot 406", "Peugeot 407", "Peugeot 407 SW", "Peugeot 5008", "Peugeot 508", "Peugeot 508 SW", "Peugeot 605", "Peugeot 806", "Peugeot 607", "Peugeot 807", "Peugeot Bipper", "Peugeot RCZ", "Porsche 911 Carrera", "Porsche 911 Carrera Cabrio", "Porsche 911 Targa", "Porsche 911 Turbo", "Porsche 924", "Porsche 944", "Porsche 997", "Porsche Boxster", "Porsche Cayenne", "Porsche Cayman", "Porsche Macan", "Porsche Panamera", "Renault Captur", "Renault Clio", "Renault Clio Grandtour", "Renault Espace", "Renault Express", "Renault Fluence", "Renault Grand Espace", "Renault Grand Modus", "Renault Grand Scenic", "Renault Kadjar", "Renault Kangoo", "Renault Kangoo Express", "Renault Koleos", "Renault Laguna", "Renault Laguna Grandtour", "Renault Latitude", "Renault Mascott", "Renault M\xe9gane", "Renault M\xe9gane CC", "Renault M\xe9gane Combi", "Renault M\xe9gane Grandtour", "Renault M\xe9gane Coup\xe9", "Renault M\xe9gane Sc\xe9nic", "Renault Sc\xe9nic", "Renault Talisman", "Renault Talisman Grandtour", "Renault Thalia", "Renault Twingo", "Renault Wind", "Renault Zo\xe9", "Rover 200", "Rover 214", "Rover 218", "Rover 25", "Rover 400", "Rover 414", "Rover 416", "Rover 620", "Rover 75", "Saab 9-3", "Saab 9-3 Cabriolet", "Saab 9-3 Coup\xe9", "Saab 9-3 SportCombi", "Saab 9-5", "Saab 9-5 SportCombi", "Saab 900", "Saab 900 C", "Saab 900 C Turbo", "Saab 9000", "Seat Alhambra", "Seat Altea", "Seat Altea XL", "Seat Arosa", "Seat Cordoba", "Seat Cordoba Vario", "Seat Exeo", "Seat Ibiza", "Seat Ibiza ST", "Seat Exeo ST", "Seat Leon", "Seat Leon ST", "Seat Inca", "Seat Mii", "Seat Toledo", "Smart Cabrio", "Smart City-Coup\xe9", "Smart Compact Pulse", "Smart Forfour", "Smart Fortwo cabrio", "Smart Fortwo coup\xe9", "Smart Roadster", "Subaru BRZ", "Subaru Forester", "Subaru Impreza", "Subaru Impreza Wagon", "Subaru Justy", "Subaru Legacy", "Subaru Legacy Wagon", "Subaru Legacy Outback", "Subaru Levorg", "Subaru Outback", "Subaru SVX", "Subaru Tribeca", "Subaru Tribeca B9", "Subaru XV", "Suzuki Alto", "Suzuki Baleno", "Suzuki Baleno kombi", "Suzuki Grand Vitara", "Suzuki Grand Vitara XL-7", "Suzuki Ignis", "Suzuki Jimny", "Suzuki Kizashi", "Suzuki Liana", "Suzuki Samurai", "Suzuki Splash", "Suzuki Swift", "Suzuki SX4", "Suzuki SX4 Sedan", "Suzuki Vitara", "Suzuki Wagon R+", "Toyota 4-Runner", "Toyota Auris", "Toyota Avensis", "Toyota Avensis Combi", "Toyota Avensis Van Verso", "Toyota Aygo", "Toyota Camry", "Toyota Carina", "Toyota Celica", "Toyota Corolla", "Toyota Corolla Combi", "Toyota Corolla sedan", "Toyota Corolla Verso", "Toyota FJ Cruiser", "Toyota GT86", "Toyota Hiace", "Toyota Hiace Van", "Toyota Highlander", "Toyota Hilux", "Toyota Land Cruiser", "Toyota MR2", "Toyota Paseo", "Toyota Picnic", "Toyota Prius", "Toyota RAV4", "Toyota Sequoia", "Toyota Starlet", "Toyota Supra", "Toyota Tundra", "Toyota Urban Cruiser", "Toyota Verso", "Toyota Yaris", "Toyota Yaris Verso", "Volkswagen Amarok", "Volkswagen Beetle", "Volkswagen Bora", "Volkswagen Bora Variant", "Volkswagen Caddy", "Volkswagen Caddy Van", "Volkswagen Life", "Volkswagen California", "Volkswagen Caravelle", "Volkswagen CC", "Volkswagen Crafter", "Volkswagen Crafter Van", "Volkswagen Crafter Kombi", "Volkswagen CrossTouran", "Volkswagen Eos", "Volkswagen Fox", "Volkswagen Golf", "Volkswagen Golf Cabrio", "Volkswagen Golf Plus", "Volkswagen Golf Sportvan", "Volkswagen Golf Variant", "Volkswagen Jetta", "Volkswagen LT", "Volkswagen Lupo", "Volkswagen Multivan", "Volkswagen New Beetle", "Volkswagen New Beetle Cabrio", "Volkswagen Passat", "Volkswagen Passat Alltrack", "Volkswagen Passat CC", "Volkswagen Passat Variant", "Volkswagen Passat Variant Van", "Volkswagen Phaeton", "Volkswagen Polo", "Volkswagen Polo Van", "Volkswagen Polo Variant", "Volkswagen Scirocco", "Volkswagen Sharan", "Volkswagen T4", "Volkswagen T4 Caravelle", "Volkswagen T4 Multivan", "Volkswagen T5", "Volkswagen T5 Caravelle", "Volkswagen T5 Multivan", "Volkswagen T5 Transporter Shuttle", "Volkswagen Tiguan", "Volkswagen Touareg", "Volkswagen Touran", "Volvo 240", "Volvo 340", "Volvo 360", "Volvo 460", "Volvo 850", "Volvo 850 kombi", "Volvo C30", "Volvo C70", "Volvo C70 Cabrio", "Volvo C70 Coup\xe9", "Volvo S40", "Volvo S60", "Volvo S70", "Volvo S80", "Volvo S90", "Volvo V40", "Volvo V50", "Volvo V60", "Volvo V70", "Volvo V90", "Volvo XC60", "Volvo XC70", "Volvo XC90", "Škoda Favorit", "Škoda Felicia", "Škoda Citigo", "Škoda Fabia", "Škoda Fabia Combi", "Škoda Fabia Sedan", "Škoda Felicia Combi", "Škoda Octavia", "Škoda Octavia Combi", "Škoda Roomster", "Škoda Yeti", "Škoda Rapid", "Škoda Rapid Spaceback", "Škoda Superb", "Škoda Superb Combi"],
                    ["(Don't Fear) The Reaper", "(I Can't Get No) Satisfaction", "(Sittin' On) The Dock of the Bay", "(We're Gonna) Rock Around The Clock", "(What's So Funny 'Bout) Peace, Love And Understanding", "(White Man) In Hammersmith Palais", "(Your Love Keeps Lifting Me) Higher And Higher", "1999", "96 Tears", "99 Problems", "A Change Is Gonna Come", "A Day in the Life", "A Hard Day's Night", "A Whiter Shade of Pale", "Ain't No Sunshine", "Ain't That a Shame", "Alison", "All Along the Watchtower", "All Apologies", "All I Have to Do Is Dream", "All Shook Up", "All You Need Is Love", "All the Young Dudes", "Alone Again Or", "American Idiot", "Anarchy in the U.K.", "Another Brick In The Wall (Part II)", "Baba O'Riley", "Baby I Need Your Loving", "Baby Love", "Back in Black", "Bad Moon Rising", "Be My Baby", "Be", "Beast of Burden", "Beat It", "Beautiful Day", "Big Pimpin' (feat. UGK)", "Billie Jean", "Bitter Sweet Symphony", "Bizarre Love Triangle", "Black Dog", "Blitzkrieg Bop", "Blowin' in the Wind", "Blue Eyes Crying In The Rain", "Blue Suede Shoes", "Blue Suede Shoes", "Blueberry Hill", "Bo Diddley", "Bohemian Rhapsody", "Boom Boom", "Born in the U.S.A.", "Born to Be Wild", "Born to Run", "Both Sides Now", "Bridge Over Troubled Water", "Bring the Noise", "Brown Eyed Girl", "Brown Eyed Handsome Man", "Brown Sugar", "Buddy Holly", "Bye Bye Love", "C'mon Everybody", "California Dreamin'", "California Girls", "California Love (remix) (feat. Dr. Dre & Roger Troutman)", "Call Me", "Can't Buy Me Love", "Can't Help Falling in Love", "Candle in the Wind", "Caroline, No", "Cathy's Clown", "Chain Of Fools", "Changes", "Chapel Of Love", "Clocks", "Come Go With Me", "Come Together", "Come as You Are", "Comfortably Numb", "Complete Control", "Cortez the Killer", "Crazy", "Crazy", "Crazy in Love (feat.  Jay", "Cry Me a River", "Crying", "Cupid", "Da Ya Think I'm Sexy?", "Dance To The Music", "Dancing Barefoot", "Dancing Queen", "Dancing in the Street", "Desolation Row", "Do Right Woman, Do Right Man", "Do You Believe In Magic", "Don't Be Cruel", "Don't Let Me Be Misunderstood", "Don't Worry Baby", "Dream On", "Earth Angel", "Eight Miles High", "Eleanor Rigby", "Enter Sandman", "Every Breath You Take", "Everybody Needs Somebody To Love", "Everyday", "Everyday People", "Fake Plastic Trees", "Family Affair", "Fast Car", "Fight the Power", "Fire and Rain", "Flash Light", "Folsom Prison Blues", "For What It's Worth", "For Your Precious Love", "Fortunate Son", "Foxey Lady", "Free Bird", "Free Fallin'", "Fuck tha Police", "Georgia On My Mind", "Get Up (I Feel Like Being a) Sex Machine", "Get Up, Stand Up", "Get Ur Freak On", "Gimme Shelter", "Gimme Some Lovin'", "Gloria", "Go Your Own Way", "God Only Knows", "God Save the Queen", "Good Golly", "Good Lovin'", "Good Times", "Good Vibrations", "Goodbye Yellow Brick Road", "Got My Mojo Working", "Great Balls of Fire", "Green Onions", "Hallelujah", "He Stopped Loving Her Today", "He's a Rebel", "Heart of Glass", "Heart of Gold", "Heartbreak Hotel", "Heartbreaker", "Hello", "Help!", "Heroes", "Heroin", "Hey Joe", "Hey Jude", "Hey Ya!", "Higher Ground", "Highway 61 Revisited", "Highway To Hell", "Hit the Road Jack", "Honky Tonk Women", "Hoochie Coochie Man", "Hot Fun In The Summertime", "Hot Stuff", "Hotel California", "Hound Dog", "How Deep Is Your Love", "How Soon Is Now?", "I Can See for Miles", "I Can't Explain", "I Can't Help Myself", "I Can't Make You Love Me", "I Can't Stop Loving You", "I Fall to Pieces", "I Feel Love", "I Fought the Law", "I Got You (I Feel Good)", "I Got You Babe", "I Got a Woman", "I Heard It Through the Grapevine", "I Know You Got Soul", "I Love Rock 'N Roll", "I Never Loved a Man (the Way I Love You)", "I Only Have Eyes for You", "I Put A Spell On You", "I Saw Her Standing There", "I Shot The Sheriff", "I Still Haven't Found What I'm Looking For", "I Walk the Line", "I Wanna Be Sedated", "I Wanna Be Your Dog", "I Want To Know What Love Is", "I Want You Back", "I Want to Hold Your Hand", "I Will Survive", "I'll Feel A Whole Lot Better", "I'll Take You There", "I'm A Man", "I'm Eighteen", "I'm So Lonesome I Could Cry", "I'm Waiting for the Man", "I've Been Loving You Too Long (To Stop Now)", "Ignition (Remix)", "Imagine", "In Bloom", "In Da Club", "In Dreams", "In My Life", "In My Room", "In The Still Of The Nite", "In the Midnight Hour", "Into The Mystic", "Iron Man", "It's A Man's Man's Man's World", "It's Your Thing", "Jailhouse Rock", "Jesus Walks", "Jim Dandy", "Johnny B. Goode", "Jolene", "Juicy", "Jumpin' Jack Flash", "Just Like Heaven", "Just Like a Woman", "Just My Imagination (Running Away With Me)", "Kashmir", "Killing Me Softly With His Song", "Kiss", "Knocking On Heaven's Door", "La Bamba", "Lady Marmalade", "Last Nite", "Layla", "Leader of the Pack", "Lean on Me", "Let It Be", "Let's Get It On", "Let's Stay Together", "Light My Fire", "Like a Prayer", "Like a Rolling Stone", "Little Red Corvette", "Little Wing", "Living For The City", "London Calling", "Lonely Teardrops", "Long Tall Sally", "Loser", "Losing My Religion", "Louie Louie", "Love And Happiness", "Love Me Tender", "Love Shack", "Love Will Tear Us Apart", "Lust For Life", "Mack the Knife", "Maggie May", "Mannish Boy", "Many Rivers to Cross", "Maps", "Marquee Moon", "Maybe", "Maybe I'm Amazed", "Maybellene", "Me And Bobby McGee", "Midnight Train To Georgia", "Miss You", "Mississippi", "Moment of Surrender", "Money (That's What I Want)", "Money Honey", "Monkey Gone to Heaven", "Moondance", "Mr. Tambourine Man", "Mr. Tambourine Man", "Mustang Sally", "My Generation", "My Girl", "My Sweet Lord", "Mystery Train", "New Year's Day", "No Woman, No Cry", "Norwegian Wood (This Bird Has Flown)", "Not Fade Away", "Nothing Compares 2 U", "Nowhere To Run", "Nuthin' but a 'G' Thang", "O", "Ode to Billie Joe", "Oh", "Oh", "One", "One More Time", "One Way or Another", "Only the Lonely", "Ooo Baby Baby", "Paint It, Black", "Papa Was a Rollin' Stone", "Papa's Got a Brand New Bag", "Paper Planes", "Paradise City", "Paranoid", "Paranoid Android", "Peggy Sue", "Penny Lane", "People Get Ready", "Personal Jesus", "Personality Crisis", "Piano Man", "Pictures of You", "Piece of My Heart", "Pink Houses", "Planet Rock", "Please Please Me", "Please, Please, Please", "Positively 4th Street", "Pressure Drop", "Pride (in the Name of Love)", "Proud Mary", "Purple Haze", "Purple Rain", "Push It", "Radio Free Europe", "Rain", "Ramble On", "Rapper's Delight", "Rave On", "Reach Out I'll Be There", "Redemption Song", "Rehab", "Remember (Walkin' In The Sand)", "Respect", "Respect Yourself", "Ring of Fire", "River Deep", "Roadrunner", "Rock Lobster", "Rock and Roll Music", "Rocket Man (I Think It's Going To Be A Long, Long Time)", "Rockin' in the Free World", "Roll Over Beethoven", "Rollin' Stone", "Roxanne", "Ruby Tuesday", "Runaround Sue", "Runaway", "Running On Empty", "Sabotage", "Sail Away", "Save the Last Dance for Me", "Say It Loud (I'm Black and I'm Proud)", "School's Out", "September Gurls", "Seven Nation Army", "Sexual Healing", "Shake", "She Loves You", "She's Not There", "Sheena Is a Punk Rocker", "Shop Around", "Should I Stay or Should I Go", "Shout (Parts 1 & 2)", "Sign 'O' The Times", "Since U Been Gone", "Sloop John B", "Smells Like Teen Spirit", "Smoke on the Water", "Smokestack Lightning", "Somebody to Love", "Something", "Son of a Preacher Man", "Soul Man", "Spanish Harlem", "Spirit in the Sky", "Spoonful", "Stairway to Heaven", "Stan (feat. Dido)", "Stand By Me", "Stand!", "Standing In The Shadows Of Love", "Stayin' Alive", "Stills & Nash, Suite: Judy Blue Eyes", "Stills, Nash & Young", "Strawberry Fields Forever", "Street Fighting Man", "Subterranean Homesick Blues", "Summer Babe (Winter Version)", "Summer in the City", "Summertime Blues", "Sunday Bloody Sunday", "Sunshine of Your Love", "Super Freak", "Superstition", "Surrender", "Suspicious Minds", "Sweet Child o' Mine", "Sweet Dreams (Are Made of This)", "Sweet Emotion", "Sweet Home Alabama", "Sweet Jane", "Sweet Little Sixteen", "Sympathy for the Devil", "Take Me Out", "Take Me To The River", "Tangled Up in Blue", "Tears in Heaven", "Tell It Like It Is", "Thank You (Falettinme Be Mice Elf Agin)", "That Lady (Parts 1 & 2)", "That'll Be the Day", "That's All Right", "That's Entertainment", "The Boxer", "The Boys Of Summer", "The End", "The Girl Can't Help It", "The Great Pretender", "The Harder They Come", "The House of the Rising Sun", "The Letter", "The Loco", "The Message", "The Night They Drove Old Dixie Down", "The Rising", "The Sound of Silence", "The Thrill Is Gone", "The Times They Are a", "The Tracks Of My Tears", "The Twist", "The Wanderer", "The Weight", "The Wind Cries Mary", "There Goes My Baby", "Thirteen", "Thunder Road", "Ticket to Ride", "Tighten Up", "Time to Pretend", "Tiny Dancer", "Tired Of Being Alone", "Tonight's the Night", "Train in Vain", "Try a Little Tenderness", "Tumbling Dice", "Tutti", "Umbrella (feat. Jay", "Unchained Melody", "Under the Boardwalk", "Up On the Roof", "Visions of Johanna", "Voodoo Child (Slight Return)", "Wake Up Little Susie", "Walk On By", "Walk This Way", "Walk This Way", "Walk away Ren\xe9e", "Walk on the Wild Side", "Walking In The Rain", "Watching The Detectives", "Waterloo Sunset", "We Gotta Get Out Of This Place", "We Will Rock You", "We've Only Just Begun", "Welcome to the Jungle", "What'd I Say", "What's Going On", "What's Love Got to Do With It", "When A Man Loves A Woman", "When Doves Cry", "Where Did Our Love Go", "While My Guitar Gently Weeps", "Whipping Post", "White Rabbit", "White Room", "Who Do You Love?", "Who'll Stop the Rain", "Whole Lotta Love", "Whole Lotta Shakin' Going On", "Why Do Fools Fall In Love", "Wichita Lineman", "Wild Horses", "Wild Thing", "Will You Love Me Tomorrow", "William", "Wind and Fire", "Wish You Were Here", "With a Little Help My Friends", "With or Without You", "Won't Get Fooled Again", "Wonderful World", "Yesterday", "You Are the Sunshine of My Life", "You Can't Always Get What You Want", "You Keep Me Hangin' On", "You Really Got Me", "You Send Me", "You've Lost That Lovin' Feelin'", "Young Americans", "Young Blood", "Your Cheatin' Heart", "Your Song", "Ziggy Stardust"],
                    ["2Pac", "50 Cent", "ABBA", "AC/DC", "Aaron Neville", "Aerosmith", "Afrika Bambaataa & the Soulsonic Force", "Al Green", "Alice Cooper", "Amy Winehouse", "Archie Bell & The Drells", "Aretha Franklin", "B.B. King", "Barrett Strong", "Beastie Boys", "Beck", "Bee Gees", "Ben E. King", "Beyonc\xe9", "Big Brother & The Holding Company", "Big Joe Turner", "Big Star", "Bill Haley & His Comets", "Bill Withers", "Billy Joel", "Black Sabbath", "Blondie", "Blue \xd6yster Cult", "Bo Diddley", "Bob Dylan", "Bob Marley & The Wailers", "Bobbie Gentry", "Bobby Darin", "Bonnie Raitt", "Booker T. & The MG's", "Bruce Springsteen", "Buddy Holly", "Buddy Holly & The Crickets", "Buffalo Springfield", "Carl Perkins", "Carpenters", "Cheap Trick", "Chic", "Chubby Checker", "Chuck Berry", "Coldplay", "Cream", "Creedence Clearwater Revival", "Crosby", "Daft Punk", "David Bowie", "Deep Purple", "Del Shannon", "Depeche Mode", "Derek and the Dominos", "Dion", "Dionne Warwick", "Dolly Parton", "Don Henley", "Donna Summer", "Dr. Dre", "Dusty Springfield", "Eagles", "Earth", "Eddie Cochran", "Elton John", "Elvis Costello", "Elvis Costello & The Attractions", "Elvis Presley", "Eminem", "Eric B. & Rakim", "Eric Clapton", "Eurythmics", "Fats Domino", "Fleetwood Mac", "Foreigner", "Frankie Lymon & The Teenagers", "Franz Ferdinand", "Gene Vincent & His Blue Caps", "George Harrison", "George Jones", "Gladys Knight & The Pips", "Glen Campbell", "Gloria Gaynor", "Gnarls Barkley", "Grandmaster Flash and the Furious Five", "Green day", "Guns N' Roses", "Hank Williams", "Howlin' Wolf", "Iggy Pop", "Ike & Tina Turner", "Jackie Wilson", "Jackson Browne", "James Brown", "James Taylor", "Janis Joplin", "Jay-Z", "Jeff Buckley", "Jefferson Airplane", "Jerry Lee Lewis", "Jimmy Cliff", "Joan Jett and The Blackhearts", "John Lee Hooker", "John Lennon", "John Mellencamp", "Johnny Cash", "Joni Mitchell", "Joy Division", "Justin Timberlake", "Kanye West", "Kelly Clarkson", "Labelle", "Lavern Baker", "Led Zeppelin", "Lionel Richie", "Little Eva", "Little Richard", "Lou Reed", "Love", "Lynyrd Skynyrd", "M.I.A.", "MGMT", "Madonna", "Martha and the Vandellas", "Marvin Gaye", "Metallica", "Michael Jackson", "Missy Elliott", "Mott the Hoople", "Muddy Waters", "N.W.A", "Neil Young", "Neil Young & Crazy Horse", "New Order", "New York Dolls", "Nirvana", "Norman Greenbaum", "Otis Redding", "OutKast", "Parliament", "Patsy Cline", "Patti Smith Group", "Paul McCartney", "Pavement", "Percy Sledge", "Pink Floyd", "Pixies", "Prince", "Prince and The Revolution", "Procol Harum", "Public Enemy", "Queen", "R. Kelly", "R.E.M.", "Radiohead", "Ramones", "Randy Newman", "Ray Charles", "Rick James", "Rihanna", "Ritchie Valens", "Roberta Flack", "Rod Stewart", "Roy Orbison", "Run-D.M.C.", "Salt-N-Pepa", "Sam & Dave", "Sam Cooke", "Screamin' Jay Hawkins", "Sex Pistols", "Simon & Garfunkel", "Sinead O'Connor", "Sly & The Family Stone", "Smokey Robinson and the Miracles", "Solomon Burke", "Sonny & Cher", "Steppenwolf", "Stevie Wonder", "Television", "The Allman Brothers Band", "The Animals", "The B-52's", "The Band", "The Beach Boys", "The Beatles", "The Bobby Fuller Four", "The Box Tops", "The Byrds", "The Chantels", "The Clash", "The Coasters", "The Crystals", "The Cure", "The Del-Vikings", "The Dells", "The Dixie Cups", "The Doors", "The Drifters", "The Everly Brothers", "The Five Satins", "The Five Stairsteps", "The Flamingos", "The Four Tops", "The Impressions", "The Isley Brothers", "The Jackson 5", "The Jam", "The Jimi Hendrix Experience", "The Kingsmen", "The Kinks", "The Left Banke", "The Lovin' Spoonful", "The Mamas & The Papas", "The Modern Lovers", "The Notorious B.I.G", "The Penguins", "The Platters", "The Police", "The Rascals", "The Righteous Brothers", "The Rolling Stones", "The Ronettes", "The Shangri-Las", "The Shirelles", "The Smiths", "The Spencer Davis Group", "The Staple Singers", "The Stooges", "The Strokes", "The Sugarhill Gang", "The Supremes", "The Temptations", "The Troggs", "The Velvet Underground", "The Verve", "The White Stripes", "The Who", "The Zombies", "Them", "Tina Turner", "Tom Petty", "Toot and the Maytals", "Tracy Chapman", "U2", "Van Morrison", "Weezer", "Willie Nelson", "Wilson Pickett", "Yeah Yeah Yeahs"],
                    ["Adam Jensen (Deus-Ex)", "Agent 47 (Hitman)", "Akuma (Street Fighter)", "Alucard (Castlevania)", "Arthas Menethil (Warcraft)", "Arthur Morgan (Red Dead Redemption)", "Atreus (God of War)", "Bayonetta", "Big Boss / Snake ( Metal Gear)", "Big Daddy (Bioshock)", "Booker DeWitt (Bioshock)", "Caius Cosades (Elder Scrolls)", "Cammy (Street Fighter)", "Captain Price (Call of Duty)", "Chun-Li (Street Fighter)", "Cloud Strife (Final Fantasy)", "Commander Shepard (Mass Effect)", "Cortana (Halo)", "Deckard Cain (Diablo)", "Diddy Kong (Donkey Kong / Mario)", "Dog (Duck Hunt)", "Donkey Kong", "Doom Guy (Doom)", "Dovahkiin (Elder Scrolls)", "Duke Nukem", "E. Honda (Street Fighter)", "Edward Kenway (Assassin's Creed)", "Ellie (The Last of Us)", "Ezio Auditore da Firenze (Assassin's Creed)", "Fox McCloud (Star Fox)", "Geralt of Rivia (The Witcher)", "Gordon Freeman (Half-Life)", "Guybrush Threepwood (Monkey Island)", "Illidan Stormrage (Warcraft)", "JC Denton (Deus-Ex)", "Jack of Blades (Fable)", "Jill Valentine (Resident Evil)", "Joel Miller (The Last of Us)", "John Marston (Red Dead Redemption)", "Juri (Street Fighter)", "Ken (Street Fighter)", "Kitana (Mortal Kombat)", "Kratos (God of War)", "Lara Croft", "Lightning (Final Fantasy)", "Link (The Legend of Zelda)", "Luigi (Mario)", "M. Bison (Street Fighter)", "Marcus Fenix (Gears of War)", "Marcus Holloway (Watch Dogs)", "Mario (Super Mario)", "Master Chief (Halo)", "Max Payne", "Maxwell (Don't Starve Together)", "Mordin Solus (Mass Effect)", "Nathan Drake (Uncharted)", "Paarthurnax (Elder Scrolls)", "Pac-Man", "Pikachu (Pokemon)", "Princess Zelda (Legend of Zelda)", "Raiden (Metal Gear)", "Ryu (Street Fighter)", "Sam Fisher (Splinter Cell)", "Sarah Louise Kerrigan (Starcraft / Heroes of the Storm)", "Scorpion (Mortal Kombat)", "Scrooge McDuck (DuckTales Remastered)", "Senua (Hellblade)", "Sephiroth (Final Fantasy)", "Solaire of Astora (Dark Souls)", "Sonic the Hedgehog", "Spyro", "Sylvanas Windrunner (Warcraft)", "Thrall (Warcraft)", "Tiny Tina (Borderlands)", "Tom Nook (Animal Crossing)", "Tommy Vercetti (Grand Theft Auto)", "Trevor Philips (Grand Theft Auto)", "Vaas Montenegro (Far Cry)", "WX-78 (Don't Starve Together)", "Wagstaff (Don't Starve Together)", "Walter (Don't Starve Together)", "Wanda (Don't Starve Together)", "Warly (Don't Starve Together)", "Webber (Don't Starve Together)", "Wendy (Don't Starve Together)", "Wes (Don't Starve Together)", "Wickerbottom (Don't Starve Together)", "Wigfrid (Don't Starve Together)", "Willow (Don't Starve Together)", "Wilson (Don't Starve Together)", "Winona (Don't Starve Together)", "Wolfgang (Don't Starve Together)", "Wonkey (Don't Starve Together)", "Woodie (Don't Starve Together)", "Wormwood (Don't Starve Together)", "Wortox (Don't Starve Together)", "Wurt (Don't Starve Together)"],
                    ["12 Angry Men (1957)", "12 Years a Slave (2013)", "12th Fail (2023)", "1917 (2019)", "2001: A Space Odyssey (1968)", "3 Idiots (2009)", "A Beautiful Mind (2001)", "A Clockwork Orange (1971)", "A Separation (2011)", "Aladdin (1992)", "Alien (1979)", "Aliens (1986)", "All About Eve (1950)", "Amadeus (1984)", "American Beauty (1999)", "American History X (1998)", "Amores Perros (2000)", "Am\xe9lie (2001)", "Apocalypse Now (1979)", "Avengers: Endgame (2019)", "Avengers: Infinity War (2018)", "Back to the Future (1985)", "Barry Lyndon (1975)", "Batman Begins (2005)", "Before Sunrise (1995)", "Before Sunset (2004)", "Ben-Hur (1959)", "Bicycle Thieves (1948)", "Blade Runner (1982)", "Braveheart (1995)", "Capernaum (2018)", "Casablanca (1942)", "Casino (1995)", "Catch Me If You Can (2002)", "Children of Heaven (1997)", "Chinatown (1974)", "Cinema Paradiso (1988)", "Citizen Kane (1941)", "City Lights (1931)", "City of God (2002)", "Coco (2017)", "Come and See (1985)", "Cool Hand Luke (1967)", "Dances with Wolves (1990)", "Dangal (2016)", "Dead Poets Society (1989)", "Dial M for Murder (1954)", "Die Hard (1988)", "Django Unchained (2012)", "Double Indemnity (1944)", "Downfall (2004)", "Dr, Strangelove or: How I Learned to Stop Worrying and Love the Bomb (1964)", "Drishyam (2015)", "Dune: Part Two (2024)", "Eternal Sunshine of the Spotless Mind (2004)", "Fargo (1996)", "Fight Club (1999)", "Finding Nemo (2003)", "For a Few Dollars More (1965)", "Ford v Ferrari (2019)", "Forrest Gump (1994)", "Full Metal Jacket (1987)", "Gladiator (2000)", "Godzilla Minus One (2023)", "Gone Girl (2014)", "Gone with the Wind (1939)", "Good Will Hunting (1997)", "Goodfellas (1990)", "Gran Torino (2008)", "Grave of the Fireflies (1988)", "Green Book (2018)", "Groundhog Day (1993)", "Hachi: A Dog's Tale (2009)", "Hacksaw Ridge (2016)", "Hamilton (2020)", "Harakiri (1962)", "Harry Potter and the Deathly Hallows: Part 2 (2011)", "Heat (1995)", "High and Low (1963)", "Hotel Rwanda (2004)", "How to Train Your Dragon (2010)", "Howl's Moving Castle (2004)", "Ikiru (1952)", "In the Name of the Father (1993)", "Incendies (2010)", "Inception (2010)", "Indiana Jones and the Last Crusade (1989)", "Inglourious Basterds (2009)", "Inside Out (2015)", "Interstellar (2014)", "Into the Wild (2007)", "It Happened One Night (1934)", "It's a Wonderful Life (1946)", "Jai Bhim (2021)", "Jaws (1975)", "Joker (2019)", "Judgment at Nuremberg (1961)", "Jurassic Park (1993)", "Kill Bill: Vol, 1 (2003)", "Klaus (2019)", "L,A, Confidential (1997)", "La haine (1995)", "Lawrence of Arabia (1962)", "Life Is Beautiful (1997)", "Like Stars on Earth (2007)", "Lock, Stock and Two Smoking Barrels (1998)", "Logan (2017)", "L\xe9on: The Professional (1994)", "M (1931)", "Mad Max: Fury Road (2015)", "Mary and Max (2009)", "Memento (2000)", "Memories of Murder (2003)", "Metropolis (1927)", "Million Dollar Baby (2004)", "Modern Times (1936)", "Monsters, Inc (2001)", "Monty Python and the Holy Grail (1975)", "Mr, Smith Goes to Washington (1939)", "My Father and My Son (2005)", "My Neighbor Totoro (1988)", "Network (1976)", "No Country for Old Men (2007)", "North by Northwest (1959)", "Oldboy (2003)", "On the Waterfront (1954)", "Once Upon a Time in America (1984)", "Once Upon a Time in the West (1968)", "One Flew Over the Cuckoo's Nest (1975)", "Oppenheimer (2023)", "Pan's Labyrinth (2006)", "Parasite (2019)", "Paths of Glory (1957)", "Pirates of the Caribbean: The Curse of the Black Pearl (2003)", "Platoon (1986)", "Princess Mononoke (1997)", "Prisoners (2013)", "Psycho (1960)", "Pulp Fiction (1994)", "Raging Bull (1980)", "Raiders of the Lost Ark (1981)", "Ran (1985)", "Rashomon (1950)", "Ratatouille (2007)", "Rear Window (1954)", "Rebecca (1940)", "Requiem for a Dream (2000)", "Reservoir Dogs (1992)", "Rocky (1976)", "Room (2015)", "Rush (2013)", "Saving Private Ryan (1998)", "Scarface (1983)", "Schindler's List (1993)", "Se7en (1995)", "Seven Samurai (1954)", "Sherlock Jr, (1924)", "Shutter Island (2010)", "Singin' in the Rain (1952)", "Snatch (2000)", "Some Like It Hot (1959)", "Spider-Man: Across the Spider-Verse (2023)", "Spider-Man: Into the Spider-Verse (2018)", "Spider-Man: No Way Home (2021)", "Spirited Away (2001)", "Spotlight (2015)", "Stand by Me (1986)", "Star Wars: Episode IV - A New Hope (1977)", "Star Wars: Episode V - The Empire Strikes Back (1980)", "Star Wars: Episode VI - Return of the Jedi (1983)", "Sunset Blvd, (1950)", "Taxi Driver (1976)", "Terminator 2: Judgment Day (1991)", "The Apartment (1960)", "The Battle of Algiers (1966)", "The Best Years of Our Lives (1946)", "The Big Lebowski (1998)", "The Boat (1981)", "The Bridge on the River Kwai (1957)", "The Dark Knight (2008)", "The Dark Knight Rises (2012)", "The Deer Hunter (1978)", "The Departed (2006)", "The Elephant Man (1980)", "The Exorcist (1973)", "The Father (2020)", "The General (1926)", "The Godfather (1972)", "The Godfather Part II (1974)", "The Gold Rush (1925)", "The Good, the Bad and the Ugly (1966)", "The Grand Budapest Hotel (2014)", "The Grapes of Wrath (1940)", "The Great Dictator (1940)", "The Great Escape (1963)", "The Green Mile (1999)", "The Handmaiden (2016)", "The Help (2011)", "The Hunt (2012)", "The Incredibles (2004)", "The Intouchables (2011)", "The Iron Giant (1999)", "The Kid (1921)", "The Lion King (1994)", "The Lives of Others (2006)", "The Lord of the Rings: The Fellowship of the Ring (2001)", "The Lord of the Rings: The Return of the King (2003)", "The Lord of the Rings: The Two Towers (2002)", "The Matrix (1999)", "The Passion of Joan of Arc (1928)", "The Pianist (2002)", "The Prestige (2006)", "The Secret in Their Eyes (2009)", "The Seventh Seal (1957)", "The Shawshank Redemption (1994)", "The Shining (1980)", "The Silence of the Lambs (1991)", "The Sixth Sense (1999)", "The Sound of Music (1965)", "The Sting (1973)", "The Terminator (1984)", "The Thing (1982)", "The Third Man (1949)", "The Treasure of the Sierra Madre (1948)", "The Truman Show (1998)", "The Usual Suspects (1995)", "The Wages of Fear (1953)", "The Wizard of Oz (1939)", "The Wolf of Wall Street (2013)", "There Will Be Blood (2007)", "Three Billboards Outside Ebbing, Missouri (2017)", "To Be or Not to Be (1942)", "To Kill a Mockingbird (1962)", "Tokyo Story (1953)", "Top Gun: Maverick (2022)", "Toy Story (1995)", "Toy Story 3 (2010)", "Trainspotting (1996)", "Unforgiven (1992)", "Up (2009)", "V for Vendetta (2005)", "Vertigo (1958)", "WALL\xb7E (2008)", "Warrior (2011)", "Whiplash (2014)", "Wild Strawberries (1957)", "Wild Tales (2014)", "Witness for the Prosecution (1957)", "Yojimbo (1961)", "Your Name (2016)"]
                ],
                random: () => {
                    // Pilih salah satu list secara acak
                    let list = BING_AUTOSEARCH.search.engine.terms.lists[Math.floor(Math.random() * BING_AUTOSEARCH.search.engine.terms.lists.length)];
                    
                    // Ambil 5 kata acak dari list yang dipilih
                    let selectedTerms = [];
                    for (let i = 0; i < 5; i++) {
                        let randomIndex = Math.floor(Math.random() * list.length);
                        selectedTerms.push(list[randomIndex]);
                    }
                    
                    // Gabungkan 5 kata menjadi satu term dengan spasi sebagai pemisah
                    let combinedTerm = selectedTerms.join(" ");
                    
                    return combinedTerm;
                }
            },
            form: {
                params: [
                    "QBLH", "QBRE", "HDRSC1", "LGWQS1", "LGWQS2", "LGWQS3", "R5FD", "R5FD1", "R5FD2", "R5FD3", "R5FD4", "R5FD5", "R5FD6", "R5FD7", "QSRE1", "QSRE2", "QSRE3", "QSRE4", "QSRE5", "QSRE6", "QSRE7", "QSRE8"
                ],
                random: () => {
                    return BING_AUTOSEARCH.search.engine.form.params[Math.floor(Math.random() * BING_AUTOSEARCH.search.engine.form.params.length)]
                }
            },
            window: {
                open: (search) => {
                    try {
                        let w = window.open(search.url);

                        if (w) {
                            setTimeout(() => {
                                w.close();
                            }, (search.interval <= 10000 && BING_AUTOSEARCH.search.interval !== 9999 ? search.interval : 10000) - 500);
                        }
                    }
                    catch (e) { }
                }
            },
            iframe: {
                add: (search) => {
                    let iframe = document.createElement("iframe");

                    iframe.setAttribute("src", search.url);
                    iframe.setAttribute("title", search.term);
                    iframe.setAttribute("data-index", search.index);

                    if (BING_AUTOSEARCH.elements.div.bing.firstChild)
                        BING_AUTOSEARCH.elements.div.bing.removeChild(BING_AUTOSEARCH.elements.div.bing.firstChild);

                    BING_AUTOSEARCH.elements.div.bing.appendChild(iframe);
                }
            },
            settings: {
                toString: () => {
                    try {
                        return `${BING_AUTOSEARCH.elements.select.limit.options[BING_AUTOSEARCH.elements.select.limit.selectedIndex].text}, ${BING_AUTOSEARCH.elements.select.interval.options[BING_AUTOSEARCH.elements.select.interval.selectedIndex].text} interval and Multi-tab Mode ${BING_AUTOSEARCH.elements.select.multitab.options[BING_AUTOSEARCH.elements.select.multitab.selectedIndex].text}`;
                    }
                    catch (e) {
                        return `Oops! There was an error loading the settings, please clear your browser cookies and reload the page to continue`;
                    }
                }
            },
            progress: {
                update: (search) => {
                    let progress = `(${search.index < 10 ? "0" + search.index : search.index}/${BING_AUTOSEARCH.search.limit < 10 ? "0" + BING_AUTOSEARCH.search.limit : BING_AUTOSEARCH.search.limit})`;

                    document.title = `${progress} - Bing Auto Search Running`;
                    BING_AUTOSEARCH.elements.span.progress.innerText = progress;
                }
            },
            timer: {
                next: null,
                complete: null,
                toClockFormat: (milliseconds, showHours = false) => {
                    let hrs = Math.floor((milliseconds / (1000 * 60 * 60)) % 24);
                    let min = Math.floor((milliseconds / 1000 / 60) % 60);
                    let sec = Math.floor((milliseconds / 1000) % 60);

                    return `${showHours ? String(hrs).padStart(2, '0') + ":" : ""}${String(min).padStart(2, '0')}:${String(sec).padStart(2, '0')}`;
                },
                updateEstimatedTime: (search) => {
                    let now = new Date();
                    let next = new Date(now.getTime() + BING_AUTOSEARCH.search.interval);
                    let complete = new Date(now.getTime() + (BING_AUTOSEARCH.search.interval * (BING_AUTOSEARCH.search.limit - search.index)));

                    if (search.index === BING_AUTOSEARCH.search.limit)
                        next = now;

                    BING_AUTOSEARCH.search.engine.timer.next = next;
                    BING_AUTOSEARCH.search.engine.timer.complete = complete;
                },
                run: () => {
                    let now = new Date();
                    let next = (BING_AUTOSEARCH.search.engine.timer.next - now);
                    let complete = (BING_AUTOSEARCH.search.engine.timer.complete - now);

                    if (BING_AUTOSEARCH.search.interval === 9999) {
                        BING_AUTOSEARCH.elements.div.timer.innerHTML = `<strong>Auto Search Running:</strong> 10~60 seconds (random) auto search interval active.`;
                    }
                    else if (complete >= 0) {
                        BING_AUTOSEARCH.elements.div.timer.innerHTML = `<strong>Auto Search Running:</strong> ${next >= 0 ? `New auto search in ${BING_AUTOSEARCH.search.engine.timer.toClockFormat(next)}` : "Finishing last auto search"}, estimated time to complete ${BING_AUTOSEARCH.search.engine.timer.toClockFormat(complete, true)}.`;

                        setTimeout(() => {
                            BING_AUTOSEARCH.search.engine.timer.run();
                        }, 1000);
                    }
                    else {
                        BING_AUTOSEARCH.elements.div.timer.innerHTML = `<strong>Auto Search Running:</strong> Stopping the auto search process...`;
                    }
                }
            }
        },
        generate: () => {
            let searches = new Array();
            let randomDelay = 0;

            do
            {
                let term = BING_AUTOSEARCH.search.engine.terms.random();

                if (!searches.includes(term)) {
                    let index = searches.length + 1;
                    let url = `https://www.bing.com/search?q=${encodeURIComponent(term.toLowerCase())}&FORM=${BING_AUTOSEARCH.search.engine.form.random()}`;                
                    let delay = BING_AUTOSEARCH.search.interval * searches.length;

                    if (BING_AUTOSEARCH.search.interval === 9999 && searches.length > 0)
                        delay = randomDelay = ((Math.floor(Math.random() * 51) + 10) * 1000) + randomDelay;

                    searches.push({ term, url, index, delay });
                }

            } while (searches.length < BING_AUTOSEARCH.search.limit)

            return searches;
        },
        start: () => {
            let searches = BING_AUTOSEARCH.search.generate();

            searches.forEach((search) => {
                setTimeout(() => {
                    BING_AUTOSEARCH.search.engine.progress.update(search);
                    BING_AUTOSEARCH.search.engine.timer.updateEstimatedTime(search);

                    if (search.index === BING_AUTOSEARCH.search.limit) {
                        setTimeout(() => {
                            BING_AUTOSEARCH.search.stop();
                        }, (search.interval <= 10000 && BING_AUTOSEARCH.search.interval !== 9999 ? search.interval : 10000));
                    }

                    if (search.delay === 0)
                        BING_AUTOSEARCH.search.engine.timer.run();

                    if (!BING_AUTOSEARCH.search.multitab)
                        BING_AUTOSEARCH.search.engine.iframe.add(search);
                    else
                        BING_AUTOSEARCH.search.engine.window.open(search);
                }, search.delay);
            });
        },
        stop: () => {
            window.open("https://rewards.bing.com/pointsbreakdown");

            location.reload();
        }
    },
    load: () => {
        BING_AUTOSEARCH.cookies.load();

        BING_AUTOSEARCH.elements.button.start.addEventListener("click", () => {
            BING_AUTOSEARCH.elements.button.start.style.display = "none";
            BING_AUTOSEARCH.elements.button.stop.style.display = "inline-block";

            BING_AUTOSEARCH.search.start();
        });

        BING_AUTOSEARCH.elements.button.stop.addEventListener("click", () => {
            BING_AUTOSEARCH.search.stop();
        });

        BING_AUTOSEARCH.elements.select.multitab.addEventListener("change", () => {
            BING_AUTOSEARCH.cookies.set("_multitab_mode", BING_AUTOSEARCH.elements.select.multitab.value, 365);
            location.reload();
        });

        BING_AUTOSEARCH.elements.select.limit.addEventListener("change", () => {
            BING_AUTOSEARCH.cookies.set("_search_limit", BING_AUTOSEARCH.elements.select.limit.value, 365);
            location.reload();
        });

        BING_AUTOSEARCH.elements.select.interval.addEventListener("change", () => {
            BING_AUTOSEARCH.cookies.set("_search_interval", BING_AUTOSEARCH.elements.select.interval.value, 365);
            location.reload();
        });

        BING_AUTOSEARCH.elements.div.settings.innerHTML = `<strong>Auto Search Settings:</strong> ${BING_AUTOSEARCH.search.engine.settings.toString()}.`;
    }
};

window.addEventListener("load", () => {
    BING_AUTOSEARCH.load();

    window.dataLayer = window.dataLayer || [];

    function gtag() {
        dataLayer.push(arguments);
    }

    gtag('js', new Date());
    gtag('config', 'G-YXNCPPFVCW');
});
